/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.app.Notification;
import android.content.Context;
import android.support.v4.app.NotificationCompat;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.NotificationChannelProvider;
import com.novoda.downloadmanager.NotificationCreator;
import com.novoda.downloadmanager.NotificationCustomizer;
import com.novoda.downloadmanager.NotificationInformation;

class DownloadBatchStatusNotificationCreator
implements NotificationCreator<DownloadBatchStatus> {
    private final Context applicationContext;
    private final NotificationCustomizer<DownloadBatchStatus> notificationCustomizer;
    private NotificationChannelProvider notificationChannelProvider;
    private int previousNotificationId;
    private DownloadBatchStatus.Status previousStatus;
    private NotificationCompat.Builder builder;

    DownloadBatchStatusNotificationCreator(Context context, NotificationCustomizer<DownloadBatchStatus> customizer, NotificationChannelProvider notificationChannelProvider) {
        this.applicationContext = context.getApplicationContext();
        this.notificationCustomizer = customizer;
        this.notificationChannelProvider = notificationChannelProvider;
    }

    @Override
    public void setNotificationChannelProvider(NotificationChannelProvider notificationChannelProvider) {
        this.notificationChannelProvider = notificationChannelProvider;
    }

    @Override
    public NotificationInformation createNotification(final DownloadBatchStatus downloadBatchStatus) {
        return new NotificationInformation(){

            @Override
            public int getId() {
                return downloadBatchStatus.getDownloadBatchId().hashCode();
            }

            @Override
            public Notification getNotification() {
                int notificationId = this.getId();
                DownloadBatchStatus.Status status = downloadBatchStatus.status();
                if (DownloadBatchStatusNotificationCreator.this.builder == null || this.hasChanged(DownloadBatchStatusNotificationCreator.this.previousNotificationId, status)) {
                    DownloadBatchStatusNotificationCreator.this.builder = new NotificationCompat.Builder(DownloadBatchStatusNotificationCreator.this.applicationContext, DownloadBatchStatusNotificationCreator.this.notificationChannelProvider.channelId());
                    DownloadBatchStatusNotificationCreator.this.previousNotificationId = notificationId;
                    DownloadBatchStatusNotificationCreator.this.previousStatus = status;
                }
                return DownloadBatchStatusNotificationCreator.this.notificationCustomizer.customNotificationFrom(DownloadBatchStatusNotificationCreator.this.builder, downloadBatchStatus);
            }

            private boolean hasChanged(int notificationId, DownloadBatchStatus.Status status) {
                return DownloadBatchStatusNotificationCreator.this.previousNotificationId != notificationId || !DownloadBatchStatusNotificationCreator.this.previousStatus.equals((Object)status);
            }

            @Override
            public NotificationCustomizer.NotificationDisplayState notificationDisplayState() {
                return DownloadBatchStatusNotificationCreator.this.notificationCustomizer.notificationDisplayState(downloadBatchStatus);
            }
        };
    }
}

