/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.Nullable;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.DownloadError;
import java.security.InvalidParameterException;

public interface DownloadBatchStatus {
    public DownloadBatchTitle getDownloadBatchTitle();

    public String storageRoot();

    public int percentageDownloaded();

    public long bytesDownloaded();

    public long bytesTotalSize();

    public DownloadBatchId getDownloadBatchId();

    public Status status();

    public long downloadedDateTimeInMillis();

    @Nullable
    public DownloadError downloadError();

    public boolean notificationSeen();

    public static enum Status {
        QUEUED,
        DOWNLOADING,
        PAUSED,
        ERROR,
        DELETING,
        DELETED,
        DOWNLOADED,
        WAITING_FOR_NETWORK,
        UNKNOWN;


        public String toRawValue() {
            return this.name();
        }

        public static Status from(String rawValue) {
            for (Status status : Status.values()) {
                if (!status.name().equals(rawValue)) continue;
                return status;
            }
            throw new InvalidParameterException("Batch status " + rawValue + " not supported");
        }
    }
}

