/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.WorkerThread;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadFile;
import com.novoda.downloadmanager.Logger;
import java.util.List;

final class DownloadBatchSizeCalculator {
    private DownloadBatchSizeCalculator() {
    }

    @WorkerThread
    static long getTotalSize(List<DownloadFile> downloadFiles, DownloadBatchStatus.Status status, DownloadBatchId downloadBatchId) {
        long totalBatchSize = 0L;
        for (DownloadFile downloadFile : downloadFiles) {
            if (status == DownloadBatchStatus.Status.DELETING || status == DownloadBatchStatus.Status.DELETED || status == DownloadBatchStatus.Status.PAUSED) {
                Logger.w("abort getTotalSize file " + downloadFile.id().rawId() + " from batch " + downloadBatchId.rawId() + " with status " + (Object)((Object)status) + " returns 0 as totalFileSize");
                return 0L;
            }
            long totalFileSize = downloadFile.getTotalSize();
            if (totalFileSize == 0L) {
                Logger.w("file " + downloadFile.id().rawId() + " from batch " + downloadBatchId.rawId() + " with status " + (Object)((Object)status) + " returns 0 as totalFileSize");
                return 0L;
            }
            totalBatchSize += totalFileSize;
        }
        return totalBatchSize;
    }
}

