/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.Batch;
import com.novoda.downloadmanager.BatchFile;
import com.novoda.downloadmanager.ConnectionChecker;
import com.novoda.downloadmanager.DownloadBatch;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchRequirementRule;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.DownloadBatchTitleCreator;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadFile;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.DownloadsBatchPersistence;
import com.novoda.downloadmanager.DownloadsFilePersistence;
import com.novoda.downloadmanager.FallbackDownloadFileIdProvider;
import com.novoda.downloadmanager.FileCallbackThrottle;
import com.novoda.downloadmanager.FileDownloader;
import com.novoda.downloadmanager.FileOperations;
import com.novoda.downloadmanager.FilePath;
import com.novoda.downloadmanager.FilePathCreator;
import com.novoda.downloadmanager.FilePersistence;
import com.novoda.downloadmanager.FileSizeRequester;
import com.novoda.downloadmanager.InternalFileSize;
import com.novoda.downloadmanager.InternalFileSizeCreator;
import com.novoda.downloadmanager.LiteDownloadBatchStatus;
import com.novoda.downloadmanager.LiteDownloadFileStatus;
import com.novoda.downloadmanager.Optional;
import com.novoda.downloadmanager.StorageRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class DownloadBatchFactory {
    private static final boolean NOTIFICATION_NOT_SEEN = false;
    private static final int BYTES_DOWNLOADED = 0;
    private static final int TOTAL_BATCH_SIZE_BYTES = 0;
    private static final Optional<DownloadError> DOWNLOAD_ERROR = Optional.absent();

    private DownloadBatchFactory() {
    }

    static DownloadBatch newInstance(Batch batch, FileOperations fileOperations, DownloadsBatchPersistence downloadsBatchPersistence, DownloadsFilePersistence downloadsFilePersistence, FileCallbackThrottle fileCallbackThrottle, ConnectionChecker connectionChecker, DownloadBatchRequirementRule downloadBatchRequirementRule) {
        DownloadBatchTitle downloadBatchTitle = DownloadBatchTitleCreator.createFrom(batch);
        StorageRoot storageRoot = batch.storageRoot();
        DownloadBatchId downloadBatchId = batch.downloadBatchId();
        long downloadedDateTimeInMillis = System.currentTimeMillis();
        List<BatchFile> batchFiles = batch.batchFiles();
        ArrayList<DownloadFile> downloadFiles = new ArrayList<DownloadFile>(batchFiles.size());
        for (BatchFile batchFile : batchFiles) {
            String networkAddress = batchFile.networkAddress();
            InternalFileSize fileSize = InternalFileSizeCreator.unknownFileSize();
            FilePersistence filePersistence = fileOperations.filePersistenceCreator().create();
            FilePath filePath = FilePathCreator.create(batchFile.path(), batchFile.path());
            DownloadFileId downloadFileId = FallbackDownloadFileIdProvider.downloadFileIdFor(batch.downloadBatchId(), batchFile);
            LiteDownloadFileStatus downloadFileStatus = new LiteDownloadFileStatus(downloadBatchId, downloadFileId, DownloadFileStatus.Status.QUEUED, fileSize, filePath);
            FileDownloader fileDownloader = fileOperations.fileDownloaderCreator().create();
            FileSizeRequester fileSizeRequester = fileOperations.fileSizeRequester();
            DownloadFile downloadFile = new DownloadFile(downloadBatchId, downloadFileId, networkAddress, downloadFileStatus, filePath, fileSize, fileDownloader, fileSizeRequester, filePersistence, downloadsFilePersistence);
            downloadFiles.add(downloadFile);
        }
        LiteDownloadBatchStatus liteDownloadBatchStatus = new LiteDownloadBatchStatus(downloadBatchId, downloadBatchTitle, storageRoot.path(), downloadedDateTimeInMillis, 0L, 0L, DownloadBatchStatus.Status.UNKNOWN, false, DOWNLOAD_ERROR);
        return new DownloadBatch(liteDownloadBatchStatus, downloadFiles, new HashMap<DownloadFileId, Long>(), downloadsBatchPersistence, fileCallbackThrottle, connectionChecker, downloadBatchRequirementRule);
    }
}

