/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.novoda.downloadmanager.ConnectionChecker;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchRequirementRule;
import com.novoda.downloadmanager.DownloadBatchSizeCalculator;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchStatusCallback;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadErrorFactory;
import com.novoda.downloadmanager.DownloadFile;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.DownloadsBatchPersistence;
import com.novoda.downloadmanager.DownloadsNetworkRecoveryCreator;
import com.novoda.downloadmanager.FileCallbackThrottle;
import com.novoda.downloadmanager.InternalDownloadBatchStatus;
import com.novoda.downloadmanager.InternalDownloadFileStatus;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.Optional;
import java.util.List;
import java.util.Map;

class DownloadBatch {
    private static final int ZERO_BYTES = 0;
    private static final String STATUS = "status";
    private final Map<DownloadFileId, Long> fileBytesDownloadedMap;
    private final InternalDownloadBatchStatus downloadBatchStatus;
    private final List<DownloadFile> downloadFiles;
    private final DownloadsBatchPersistence downloadsBatchPersistence;
    private final FileCallbackThrottle fileCallbackThrottle;
    private final ConnectionChecker connectionChecker;
    private final DownloadBatchRequirementRule downloadBatchRequirementRule;
    private long totalBatchSizeBytes;
    private DownloadBatchStatusCallback callback;
    private final DownloadFile.Callback fileDownloadCallback = new DownloadFile.Callback(){

        @Override
        public void onUpdate(InternalDownloadFileStatus downloadFileStatus) {
            DownloadBatch.this.fileBytesDownloadedMap.put(downloadFileStatus.downloadFileId(), downloadFileStatus.bytesDownloaded());
            long currentBytesDownloaded = DownloadBatch.getBytesDownloadedFrom(DownloadBatch.this.fileBytesDownloadedMap);
            DownloadBatch.this.downloadBatchStatus.updateDownloaded(currentBytesDownloaded);
            if (currentBytesDownloaded > DownloadBatch.this.totalBatchSizeBytes) {
                DownloadError downloadError = DownloadErrorFactory.createSizeMismatchError(downloadFileStatus);
                DownloadBatch.this.downloadBatchStatus.markAsError(Optional.of(downloadError), DownloadBatch.this.downloadsBatchPersistence);
                DownloadBatch.this.fileCallbackThrottle.update(DownloadBatch.this.downloadBatchStatus);
                return;
            }
            if (currentBytesDownloaded == DownloadBatch.this.totalBatchSizeBytes && DownloadBatch.this.totalBatchSizeBytes != 0L) {
                DownloadBatch.this.downloadBatchStatus.markAsDownloaded(DownloadBatch.this.downloadsBatchPersistence);
            }
            if (downloadFileStatus.isMarkedAsError()) {
                DownloadBatch.this.downloadBatchStatus.markAsError(downloadFileStatus.error(), DownloadBatch.this.downloadsBatchPersistence);
            }
            if (downloadFileStatus.isMarkedAsWaitingForNetwork()) {
                DownloadBatch.this.downloadBatchStatus.markAsWaitingForNetwork(DownloadBatch.this.downloadsBatchPersistence);
            }
            DownloadBatch.this.fileCallbackThrottle.update(DownloadBatch.this.downloadBatchStatus);
        }
    };

    DownloadBatch(InternalDownloadBatchStatus internalDownloadBatchStatus, List<DownloadFile> downloadFiles, Map<DownloadFileId, Long> fileBytesDownloadedMap, DownloadsBatchPersistence downloadsBatchPersistence, FileCallbackThrottle fileCallbackThrottle, ConnectionChecker connectionChecker, DownloadBatchRequirementRule downloadBatchRequirementRule) {
        this.downloadFiles = downloadFiles;
        this.fileBytesDownloadedMap = fileBytesDownloadedMap;
        this.downloadBatchStatus = internalDownloadBatchStatus;
        this.downloadsBatchPersistence = downloadsBatchPersistence;
        this.fileCallbackThrottle = fileCallbackThrottle;
        this.connectionChecker = connectionChecker;
        this.downloadBatchRequirementRule = downloadBatchRequirementRule;
    }

    void setCallback(DownloadBatchStatusCallback callback) {
        this.callback = callback;
        this.fileCallbackThrottle.setCallback(callback);
    }

    void download() {
        String rawBatchId = this.downloadBatchStatus.getDownloadBatchId().rawId();
        Logger.v("start sync download " + rawBatchId + ", " + STATUS + " " + (Object)((Object)this.downloadBatchStatus.status()));
        if (DownloadBatch.shouldAbortStartingBatch(this.connectionChecker, this.callback, this.downloadBatchStatus, this.downloadsBatchPersistence)) {
            Logger.v("abort starting download " + rawBatchId + ", " + STATUS + " " + (Object)((Object)this.downloadBatchStatus.status()));
            return;
        }
        DownloadBatch.markAsDownloadingIfNeeded(this.downloadBatchStatus, this.downloadsBatchPersistence, this.callback);
        this.updateTotalSize();
        Logger.v("batch " + this.downloadBatchStatus.getDownloadBatchId().rawId() + " " + STATUS + " " + (Object)((Object)this.downloadBatchStatus.status()) + " totalBatchSize " + this.totalBatchSizeBytes);
        if (DownloadBatch.shouldAbortAfterGettingTotalBatchSize(this.downloadBatchStatus, this.downloadsBatchPersistence, this.callback, this.downloadBatchRequirementRule, this.totalBatchSizeBytes)) {
            Logger.v("abort after getting total batch size download " + rawBatchId + ", " + STATUS + " " + (Object)((Object)this.downloadBatchStatus.status()));
            return;
        }
        for (DownloadFile downloadFile : this.downloadFiles) {
            if (DownloadBatch.batchCannotContinue(this.downloadBatchStatus, this.connectionChecker, this.downloadsBatchPersistence, this.callback)) break;
            downloadFile.download(this.fileDownloadCallback);
        }
        if (DownloadBatch.networkError(this.downloadBatchStatus)) {
            DownloadBatch.processNetworkError(this.downloadBatchStatus, this.callback, this.downloadsBatchPersistence);
        }
        DownloadBatch.deleteBatchIfNeeded(this.downloadBatchStatus, this.downloadsBatchPersistence, this.callback);
        DownloadBatch.notifyCallback(this.callback, this.downloadBatchStatus);
        this.fileCallbackThrottle.stopUpdates();
        Logger.v("end sync download " + rawBatchId);
    }

    private static boolean shouldAbortStartingBatch(ConnectionChecker connectionChecker, DownloadBatchStatusCallback callback, InternalDownloadBatchStatus downloadBatchStatus, DownloadsBatchPersistence downloadsBatchPersistence) {
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETED) {
            return true;
        }
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETING) {
            DownloadBatch.deleteBatchIfNeeded(downloadBatchStatus, downloadsBatchPersistence, callback);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.PAUSED) {
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        if (DownloadBatch.connectionNotAllowedForDownload(connectionChecker, downloadBatchStatus.status())) {
            DownloadBatch.processNetworkError(downloadBatchStatus, callback, downloadsBatchPersistence);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DOWNLOADED) {
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        return false;
    }

    private static void deleteBatchIfNeeded(InternalDownloadBatchStatus downloadBatchStatus, DownloadsBatchPersistence downloadsBatchPersistence, DownloadBatchStatusCallback callback) {
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETING) {
            Logger.v("sync delete and mark as deleted batch " + downloadBatchStatus.getDownloadBatchId().rawId());
            downloadBatchStatus.markAsDeleted();
            downloadsBatchPersistence.deleteSync(downloadBatchStatus);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
        }
    }

    private static void notifyCallback(DownloadBatchStatusCallback callback, InternalDownloadBatchStatus downloadBatchStatus) {
        if (callback != null) {
            callback.onUpdate(downloadBatchStatus.copy());
        }
    }

    private static boolean connectionNotAllowedForDownload(ConnectionChecker connectionChecker, DownloadBatchStatus.Status status) {
        return !connectionChecker.isAllowedToDownload() && status != DownloadBatchStatus.Status.DOWNLOADED;
    }

    private static void processNetworkError(InternalDownloadBatchStatus downloadBatchStatus, DownloadBatchStatusCallback callback, DownloadsBatchPersistence downloadsBatchPersistence) {
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETING) {
            Logger.v("abort processNetworkError, the batch " + downloadBatchStatus.getDownloadBatchId().rawId() + " is deleting");
            return;
        }
        downloadBatchStatus.markAsWaitingForNetwork(downloadsBatchPersistence);
        DownloadBatch.notifyCallback(callback, downloadBatchStatus);
        Logger.v("scheduleRecovery for batch " + downloadBatchStatus.getDownloadBatchId().rawId() + ", " + STATUS + " " + (Object)((Object)downloadBatchStatus.status()));
        DownloadsNetworkRecoveryCreator.getInstance().scheduleRecovery();
    }

    private static void markAsDownloadingIfNeeded(InternalDownloadBatchStatus downloadBatchStatus, DownloadsBatchPersistence downloadsBatchPersistence, DownloadBatchStatusCallback callback) {
        if (downloadBatchStatus.status() != DownloadBatchStatus.Status.DOWNLOADED) {
            Logger.v("mark " + downloadBatchStatus.getDownloadBatchId().rawId() + " from " + (Object)((Object)downloadBatchStatus.status()) + " to DOWNLOADING");
            downloadBatchStatus.markAsDownloading(downloadsBatchPersistence);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
        }
    }

    private static boolean shouldAbortAfterGettingTotalBatchSize(InternalDownloadBatchStatus downloadBatchStatus, DownloadsBatchPersistence downloadsBatchPersistence, DownloadBatchStatusCallback callback, DownloadBatchRequirementRule downloadBatchRequirementRule, long totalBatchSizeBytes) {
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.PAUSED) {
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETING) {
            DownloadBatch.deleteBatchIfNeeded(downloadBatchStatus, downloadsBatchPersistence, callback);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        if (totalBatchSizeBytes <= 0L) {
            DownloadBatch.processNetworkError(downloadBatchStatus, callback, downloadsBatchPersistence);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        if (downloadBatchRequirementRule.hasViolatedRule(downloadBatchStatus)) {
            Optional<DownloadError> error = Optional.fromNullable(new DownloadError(DownloadError.Type.REQUIREMENT_RULE_VIOLATED));
            downloadBatchStatus.markAsError(error, downloadsBatchPersistence);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        return false;
    }

    private static boolean batchCannotContinue(InternalDownloadBatchStatus downloadBatchStatus, ConnectionChecker connectionChecker, DownloadsBatchPersistence downloadsBatchPersistence, DownloadBatchStatusCallback callback) {
        DownloadBatchStatus.Status status = downloadBatchStatus.status();
        if (DownloadBatch.connectionNotAllowedForDownload(connectionChecker, status)) {
            downloadBatchStatus.markAsWaitingForNetwork(downloadsBatchPersistence);
            DownloadBatch.notifyCallback(callback, downloadBatchStatus);
            return true;
        }
        return status == DownloadBatchStatus.Status.ERROR || status == DownloadBatchStatus.Status.DELETING || status == DownloadBatchStatus.Status.DELETED || status == DownloadBatchStatus.Status.PAUSED || status == DownloadBatchStatus.Status.WAITING_FOR_NETWORK;
    }

    private static long getBytesDownloadedFrom(Map<DownloadFileId, Long> fileBytesDownloadedMap) {
        long bytesDownloaded = 0L;
        for (Map.Entry<DownloadFileId, Long> entry : fileBytesDownloadedMap.entrySet()) {
            bytesDownloaded += entry.getValue().longValue();
        }
        return bytesDownloaded;
    }

    private static boolean networkError(InternalDownloadBatchStatus downloadBatchStatus) {
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETING) {
            Logger.v("abort networkError check because the batch " + downloadBatchStatus.getDownloadBatchId().rawId() + " is deleting");
            return false;
        }
        DownloadBatchStatus.Status status = downloadBatchStatus.status();
        if (status == DownloadBatchStatus.Status.WAITING_FOR_NETWORK) {
            return true;
        }
        if (status == DownloadBatchStatus.Status.ERROR) {
            DownloadError downloadError = downloadBatchStatus.downloadError();
            return downloadError != null && downloadError.type() == DownloadError.Type.NETWORK_ERROR_CANNOT_DOWNLOAD_FILE;
        }
        return false;
    }

    void pause() {
        Logger.v("pause batch " + this.downloadBatchStatus.getDownloadBatchId().rawId() + ", " + STATUS + " " + (Object)((Object)this.downloadBatchStatus.status()));
        DownloadBatchStatus.Status status = this.downloadBatchStatus.status();
        if (status == DownloadBatchStatus.Status.PAUSED || status == DownloadBatchStatus.Status.DOWNLOADED) {
            return;
        }
        this.downloadBatchStatus.markAsPaused(this.downloadsBatchPersistence);
        DownloadBatch.notifyCallback(this.callback, this.downloadBatchStatus);
        for (DownloadFile downloadFile : this.downloadFiles) {
            downloadFile.pause();
        }
    }

    void waitForNetwork() {
        DownloadBatchStatus.Status status = this.downloadBatchStatus.status();
        if (status != DownloadBatchStatus.Status.DOWNLOADING) {
            return;
        }
        for (DownloadFile downloadFile : this.downloadFiles) {
            downloadFile.waitForNetwork();
        }
    }

    void resume() {
        DownloadBatchStatus.Status status = this.downloadBatchStatus.status();
        if (status == DownloadBatchStatus.Status.QUEUED || status == DownloadBatchStatus.Status.DOWNLOADING || status == DownloadBatchStatus.Status.DOWNLOADED) {
            return;
        }
        this.downloadBatchStatus.markAsQueued(this.downloadsBatchPersistence);
        DownloadBatch.notifyCallback(this.callback, this.downloadBatchStatus);
        for (DownloadFile downloadFile : this.downloadFiles) {
            downloadFile.resume();
        }
    }

    void delete() {
        DownloadBatchStatus.Status status = this.downloadBatchStatus.status();
        if (status == DownloadBatchStatus.Status.DELETING || status == DownloadBatchStatus.Status.DELETED) {
            Logger.v("abort delete batch " + this.downloadBatchStatus.getDownloadBatchId().rawId() + " because the " + STATUS + " is " + (Object)((Object)status));
            return;
        }
        this.downloadBatchStatus.markAsDeleting();
        Logger.v("delete request for batch " + this.downloadBatchStatus.getDownloadBatchId().rawId() + ", " + STATUS + " " + (Object)((Object)this.downloadBatchStatus.status()) + ", should be deleting");
        DownloadBatch.notifyCallback(this.callback, this.downloadBatchStatus);
        for (DownloadFile downloadFile : this.downloadFiles) {
            downloadFile.delete();
        }
        if (status == DownloadBatchStatus.Status.PAUSED || status == DownloadBatchStatus.Status.DOWNLOADED || status == DownloadBatchStatus.Status.WAITING_FOR_NETWORK || status == DownloadBatchStatus.Status.ERROR) {
            Logger.v("delete async paused or downloaded batch " + this.downloadBatchStatus.getDownloadBatchId().rawId());
            this.downloadsBatchPersistence.deleteAsync(this.downloadBatchStatus, downloadBatchId -> {
                Logger.v("delete paused or downloaded mark as deleted: " + downloadBatchId.rawId());
                this.downloadBatchStatus.markAsDeleted();
                DownloadBatch.notifyCallback(this.callback, this.downloadBatchStatus);
            });
        }
        Logger.v("delete request for batch end " + this.downloadBatchStatus.getDownloadBatchId().rawId() + ", " + STATUS + ": " + (Object)((Object)this.downloadBatchStatus.status()) + ", should be deleting");
    }

    DownloadBatchId getId() {
        return this.downloadBatchStatus.getDownloadBatchId();
    }

    InternalDownloadBatchStatus status() {
        return this.downloadBatchStatus;
    }

    @Nullable
    DownloadFileStatus downloadFileStatusWith(DownloadFileId downloadFileId) {
        for (DownloadFile downloadFile : this.downloadFiles) {
            if (!downloadFile.matches(downloadFileId)) continue;
            return downloadFile.fileStatus();
        }
        return null;
    }

    void persistAsync() {
        this.downloadsBatchPersistence.persistAsync(this.downloadBatchStatus.getDownloadBatchTitle(), this.downloadBatchStatus.getDownloadBatchId(), this.downloadBatchStatus.status(), this.downloadFiles, this.downloadBatchStatus.downloadedDateTimeInMillis(), this.downloadBatchStatus.notificationSeen(), this.downloadBatchStatus.storageRoot());
    }

    @WorkerThread
    void persist() {
        this.downloadsBatchPersistence.persist(this.downloadBatchStatus.getDownloadBatchTitle(), this.downloadBatchStatus.getDownloadBatchId(), this.downloadBatchStatus.status(), this.downloadFiles, this.downloadBatchStatus.downloadedDateTimeInMillis(), this.downloadBatchStatus.notificationSeen(), this.downloadBatchStatus.storageRoot());
    }

    @WorkerThread
    void updateTotalSize() {
        if (this.totalBatchSizeBytes == 0L) {
            this.totalBatchSizeBytes = DownloadBatchSizeCalculator.getTotalSize(this.downloadFiles, this.downloadBatchStatus.status(), this.downloadBatchStatus.getDownloadBatchId());
        }
        this.downloadBatchStatus.updateTotalSize(this.totalBatchSizeBytes);
    }
}

