/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.ConnectionType;
import com.novoda.merlin.MerlinsBeard;

class ConnectionChecker {
    private final MerlinsBeard merlinsBeard;
    private ConnectionType allowedConnectionType;

    ConnectionChecker(MerlinsBeard merlinsBeard, ConnectionType allowedConnectionType) {
        this.merlinsBeard = merlinsBeard;
        this.allowedConnectionType = allowedConnectionType;
    }

    boolean isAllowedToDownload() {
        switch (this.allowedConnectionType) {
            case UNMETERED: {
                return this.merlinsBeard.isConnectedToWifi();
            }
            case METERED: {
                return this.merlinsBeard.isConnectedToMobileNetwork();
            }
        }
        return true;
    }

    void updateAllowedConnectionType(ConnectionType allowedConnectionType) {
        this.allowedConnectionType = allowedConnectionType;
    }
}

