/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.BatchFile;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileIdCreator;
import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.Optional;

public class CompletedDownloadFile {
    private final String fileId;
    private final String originalFileLocation;
    private final String newFileLocation;
    private final FileSize fileSize;
    private final String originalNetworkAddress;

    public CompletedDownloadFile(String fileId, String originalFileLocation, String newFileLocation, FileSize fileSize, String originalNetworkAddress) {
        this.fileId = fileId;
        this.originalFileLocation = originalFileLocation;
        this.newFileLocation = newFileLocation;
        this.fileSize = fileSize;
        this.originalNetworkAddress = originalNetworkAddress;
    }

    public String fileId() {
        return this.fileId;
    }

    public String originalFileLocation() {
        return this.originalFileLocation;
    }

    public String newFileLocation() {
        return this.newFileLocation;
    }

    public FileSize fileSize() {
        return this.fileSize;
    }

    public String originalNetworkAddress() {
        return this.originalNetworkAddress;
    }

    public BatchFile asBatchFile() {
        DownloadFileId downloadFileId = DownloadFileIdCreator.createFrom(this.fileId);
        return new BatchFile(this.originalNetworkAddress, Optional.of(downloadFileId), this.newFileLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedDownloadFile that = (CompletedDownloadFile)o;
        if (this.fileId != null ? !this.fileId.equals(that.fileId) : that.fileId != null) {
            return false;
        }
        if (this.originalFileLocation != null ? !this.originalFileLocation.equals(that.originalFileLocation) : that.originalFileLocation != null) {
            return false;
        }
        if (this.newFileLocation != null ? !this.newFileLocation.equals(that.newFileLocation) : that.newFileLocation != null) {
            return false;
        }
        if (this.fileSize != null ? !this.fileSize.equals(that.fileSize) : that.fileSize != null) {
            return false;
        }
        return this.originalNetworkAddress != null ? this.originalNetworkAddress.equals(that.originalNetworkAddress) : that.originalNetworkAddress == null;
    }

    public int hashCode() {
        int result = this.fileId != null ? this.fileId.hashCode() : 0;
        result = 31 * result + (this.originalFileLocation != null ? this.originalFileLocation.hashCode() : 0);
        result = 31 * result + (this.newFileLocation != null ? this.newFileLocation.hashCode() : 0);
        result = 31 * result + (this.fileSize != null ? this.fileSize.hashCode() : 0);
        result = 31 * result + (this.originalNetworkAddress != null ? this.originalNetworkAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CompletedDownloadFile{fileId='" + this.fileId + '\'' + ", originalFileLocation='" + this.originalFileLocation + '\'' + ", newFileLocation='" + this.newFileLocation + '\'' + ", fileSize=" + this.fileSize + ", originalNetworkAddress='" + this.originalNetworkAddress + '\'' + '}';
    }
}

