/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.Batch;
import com.novoda.downloadmanager.BatchFile;
import com.novoda.downloadmanager.CompletedDownloadFile;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.StorageRoot;
import java.util.ArrayList;
import java.util.List;

public class CompletedDownloadBatch {
    private final DownloadBatchId downloadBatchId;
    private final DownloadBatchTitle downloadBatchTitle;
    private final long downloadedDateTimeInMillis;
    private final List<CompletedDownloadFile> completedDownloadFiles;
    private final StorageRoot storageRoot;

    public CompletedDownloadBatch(DownloadBatchId downloadBatchId, DownloadBatchTitle downloadBatchTitle, long downloadedDateTimeInMillis, List<CompletedDownloadFile> completedDownloadFiles, StorageRoot storageRoot) {
        this.downloadBatchId = downloadBatchId;
        this.downloadBatchTitle = downloadBatchTitle;
        this.downloadedDateTimeInMillis = downloadedDateTimeInMillis;
        this.completedDownloadFiles = completedDownloadFiles;
        this.storageRoot = storageRoot;
    }

    public DownloadBatchId downloadBatchId() {
        return this.downloadBatchId;
    }

    public DownloadBatchTitle downloadBatchTitle() {
        return this.downloadBatchTitle;
    }

    public long downloadedDateTimeInMillis() {
        return this.downloadedDateTimeInMillis;
    }

    public List<CompletedDownloadFile> completedDownloadFiles() {
        return this.completedDownloadFiles;
    }

    public StorageRoot storageRoot() {
        return this.storageRoot;
    }

    public Batch asBatch() {
        return new Batch(this.storageRoot, this.downloadBatchId, this.downloadBatchTitle.asString(), this.asBatchFiles());
    }

    private List<BatchFile> asBatchFiles() {
        ArrayList<BatchFile> batchFiles = new ArrayList<BatchFile>(this.completedDownloadFiles.size());
        for (CompletedDownloadFile completedDownloadFile : this.completedDownloadFiles) {
            batchFiles.add(completedDownloadFile.asBatchFile());
        }
        return batchFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedDownloadBatch that = (CompletedDownloadBatch)o;
        if (this.downloadedDateTimeInMillis != that.downloadedDateTimeInMillis) {
            return false;
        }
        if (this.downloadBatchId != null ? !this.downloadBatchId.equals(that.downloadBatchId) : that.downloadBatchId != null) {
            return false;
        }
        if (this.downloadBatchTitle != null ? !this.downloadBatchTitle.equals(that.downloadBatchTitle) : that.downloadBatchTitle != null) {
            return false;
        }
        if (this.completedDownloadFiles != null ? !this.completedDownloadFiles.equals(that.completedDownloadFiles) : that.completedDownloadFiles != null) {
            return false;
        }
        return this.storageRoot != null ? this.storageRoot.equals(that.storageRoot) : that.storageRoot == null;
    }

    public int hashCode() {
        int result = this.downloadBatchId != null ? this.downloadBatchId.hashCode() : 0;
        result = 31 * result + (this.downloadBatchTitle != null ? this.downloadBatchTitle.hashCode() : 0);
        result = 31 * result + (int)(this.downloadedDateTimeInMillis ^ this.downloadedDateTimeInMillis >>> 32);
        result = 31 * result + (this.completedDownloadFiles != null ? this.completedDownloadFiles.hashCode() : 0);
        result = 31 * result + (this.storageRoot != null ? this.storageRoot.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CompletedDownloadBatch{downloadBatchId=" + this.downloadBatchId + ", downloadBatchTitle=" + this.downloadBatchTitle + ", downloadedDateTimeInMillis=" + this.downloadedDateTimeInMillis + ", completedDownloadFiles=" + this.completedDownloadFiles + ", storageRoot=" + this.storageRoot + '}';
    }
}

