/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.ActionScheduler;
import com.novoda.downloadmanager.FileCallbackThrottle;
import com.novoda.downloadmanager.FileCallbackThrottleByProgressIncrease;
import com.novoda.downloadmanager.FileCallbackThrottleByTime;
import com.novoda.downloadmanager.SchedulerFactory;
import java.util.concurrent.TimeUnit;

final class CallbackThrottleCreator {
    private static final Class<? extends FileCallbackThrottle> NO_CUSTOM_CALLBACK_THROTTLE = null;
    private static final TimeUnit UNUSED_TIME_UNIT = TimeUnit.SECONDS;
    private static final int UNUSED_FREQUENCY = 0;
    private final Type type;
    private final TimeUnit timeUnit;
    private final long frequency;
    private final Class<? extends FileCallbackThrottle> customCallbackThrottle;

    static CallbackThrottleCreator byTime(TimeUnit timeUnit, long quantity) {
        return new CallbackThrottleCreator(Type.THROTTLE_BY_TIME, timeUnit, quantity, NO_CUSTOM_CALLBACK_THROTTLE);
    }

    static CallbackThrottleCreator byProgressIncrease() {
        return new CallbackThrottleCreator(Type.THROTTLE_BY_PROGRESS_INCREASE, UNUSED_TIME_UNIT, 0L, NO_CUSTOM_CALLBACK_THROTTLE);
    }

    static CallbackThrottleCreator byCustomThrottle(Class<? extends FileCallbackThrottle> customCallbackThrottle) {
        return new CallbackThrottleCreator(Type.CUSTOM, UNUSED_TIME_UNIT, 0L, customCallbackThrottle);
    }

    private CallbackThrottleCreator(Type type, TimeUnit timeUnit, long frequency, Class<? extends FileCallbackThrottle> customCallbackThrottle) {
        this.type = type;
        this.timeUnit = timeUnit;
        this.frequency = frequency;
        this.customCallbackThrottle = customCallbackThrottle;
    }

    FileCallbackThrottle create() {
        switch (this.type) {
            case THROTTLE_BY_TIME: {
                ActionScheduler actionScheduler = SchedulerFactory.createFixedRateTimerScheduler(this.timeUnit.toMillis(this.frequency));
                return new FileCallbackThrottleByTime(actionScheduler);
            }
            case THROTTLE_BY_PROGRESS_INCREASE: {
                return new FileCallbackThrottleByProgressIncrease();
            }
            case CUSTOM: {
                return this.createCallbackThrottle();
            }
        }
        throw new IllegalStateException("type " + (Object)((Object)this.type) + " not supported.");
    }

    private FileCallbackThrottle createCallbackThrottle() {
        if (this.customCallbackThrottle == null) {
            throw new CustomCallbackThrottleException("CustomCallbackThrottle class cannot be accessed, is it public?");
        }
        try {
            ClassLoader systemClassLoader = this.getClass().getClassLoader();
            Class<?> customCallbackThrottleClass = systemClassLoader.loadClass(this.customCallbackThrottle.getCanonicalName());
            return (FileCallbackThrottle)customCallbackThrottleClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new CustomCallbackThrottleException(this.customCallbackThrottle, "Class cannot be accessed, is it public?", e);
        }
        catch (ClassNotFoundException e) {
            throw new CustomCallbackThrottleException(this.customCallbackThrottle, "Class does not exist", e);
        }
        catch (InstantiationException e) {
            throw new CustomCallbackThrottleException(this.customCallbackThrottle, "Class cannot be instantiated", e);
        }
    }

    private static class CustomCallbackThrottleException
    extends RuntimeException {
        CustomCallbackThrottleException(Class customClass, String message, Exception cause) {
            super(customClass.getSimpleName() + ": " + message, cause);
        }

        CustomCallbackThrottleException(String message) {
            super(message);
        }
    }

    static enum Type {
        THROTTLE_BY_TIME,
        THROTTLE_BY_PROGRESS_INCREASE,
        CUSTOM;

    }
}

