/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.StorageCapacityReader;
import com.novoda.downloadmanager.StorageRequirementRule;
import java.io.File;

class ByteBasedRemainingStorageRequirementRule
implements StorageRequirementRule {
    private final StorageCapacityReader storageCapacityReader;
    private final long bytesRemainingAfterDownload;

    ByteBasedRemainingStorageRequirementRule(StorageCapacityReader storageCapacityReader, long bytesRemainingAfterDownload) {
        this.storageCapacityReader = storageCapacityReader;
        this.bytesRemainingAfterDownload = bytesRemainingAfterDownload;
    }

    @Override
    public boolean hasViolatedRule(File storageDirectory, FileSize downloadFileSize) {
        long storageCapacityInBytes = this.storageCapacityReader.storageCapacityInBytes(storageDirectory.getPath());
        long usableStorageInBytes = storageDirectory.getUsableSpace();
        long remainingStorageAfterDownloadInBytes = usableStorageInBytes - downloadFileSize.remainingSize();
        Logger.v("Storage capacity in bytes: ", storageCapacityInBytes);
        Logger.v("Usable storage in bytes: ", usableStorageInBytes);
        Logger.v("Minimum required storage in bytes: ", this.bytesRemainingAfterDownload);
        return remainingStorageAfterDownloadInBytes < this.bytesRemainingAfterDownload;
    }
}

