/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.InternalBatchFileBuilder;
import com.novoda.downloadmanager.LiteBatchFileBuilder;
import com.novoda.downloadmanager.Optional;
import com.novoda.downloadmanager.StorageRoot;

public class BatchFile {
    private final String networkAddress;
    private final String path;
    private final Optional<DownloadFileId> downloadFileId;

    BatchFile(String networkAddress, Optional<DownloadFileId> downloadFileId, String path) {
        this.networkAddress = networkAddress;
        this.downloadFileId = downloadFileId;
        this.path = path;
    }

    static InternalBatchFileBuilder from(StorageRoot storageRoot, DownloadBatchId downloadBatchId, String networkAddress) {
        return new LiteBatchFileBuilder(storageRoot, downloadBatchId, networkAddress);
    }

    public String networkAddress() {
        return this.networkAddress;
    }

    public String path() {
        return this.path;
    }

    public Optional<DownloadFileId> downloadFileId() {
        return this.downloadFileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchFile batchFile = (BatchFile)o;
        if (this.networkAddress != null ? !this.networkAddress.equals(batchFile.networkAddress) : batchFile.networkAddress != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(batchFile.path) : batchFile.path != null) {
            return false;
        }
        return this.downloadFileId != null ? this.downloadFileId.equals(batchFile.downloadFileId) : batchFile.downloadFileId == null;
    }

    public int hashCode() {
        int result = this.networkAddress != null ? this.networkAddress.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.downloadFileId != null ? this.downloadFileId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BatchFile{networkAddress='" + this.networkAddress + '\'' + ", path='" + this.path + '\'' + ", downloadFileId=" + this.downloadFileId + '}';
    }
}

