/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.BatchBuilder;
import com.novoda.downloadmanager.BatchFile;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.LiteBatchBuilder;
import com.novoda.downloadmanager.StorageRoot;
import java.util.ArrayList;
import java.util.List;

public class Batch {
    private final StorageRoot storageRoot;
    private final DownloadBatchId downloadBatchId;
    private final String title;
    private final List<BatchFile> batchFiles;

    public static BatchBuilder with(StorageRoot storageRoot, DownloadBatchId downloadBatchId, String title) {
        return new LiteBatchBuilder(storageRoot, downloadBatchId, title, new ArrayList<BatchFile>());
    }

    Batch(StorageRoot storageRoot, DownloadBatchId downloadBatchId, String title, List<BatchFile> batchFiles) {
        this.storageRoot = storageRoot;
        this.downloadBatchId = downloadBatchId;
        this.title = title;
        this.batchFiles = batchFiles;
    }

    public DownloadBatchId downloadBatchId() {
        return this.downloadBatchId;
    }

    public StorageRoot storageRoot() {
        return this.storageRoot;
    }

    public String title() {
        return this.title;
    }

    public List<BatchFile> batchFiles() {
        return this.batchFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Batch batch = (Batch)o;
        if (this.storageRoot != null ? !this.storageRoot.equals(batch.storageRoot) : batch.storageRoot != null) {
            return false;
        }
        if (this.downloadBatchId != null ? !this.downloadBatchId.equals(batch.downloadBatchId) : batch.downloadBatchId != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(batch.title) : batch.title != null) {
            return false;
        }
        return this.batchFiles != null ? this.batchFiles.equals(batch.batchFiles) : batch.batchFiles == null;
    }

    public int hashCode() {
        int result = this.storageRoot != null ? this.storageRoot.hashCode() : 0;
        result = 31 * result + (this.downloadBatchId != null ? this.downloadBatchId.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.batchFiles != null ? this.batchFiles.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Batch{storageRoot=" + this.storageRoot + ", downloadBatchId=" + this.downloadBatchId + ", title='" + this.title + '\'' + ", batchFiles=" + this.batchFiles + '}';
    }
}

