/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import com.novoda.downloadmanager.lib.IOHelpers;
import com.novoda.downloadmanager.lib.StopRequestException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class TarFileTruncator {
    private static final String COPY_SUFFIX = ".tmp";
    private static final byte BYTE_ZERO = 0;
    private static final int BLOCK_SIZE = 512;
    private static final int NO_BYTES_READ = -1;

    TarFileTruncator() {
    }

    public long truncateIfNeeded(String fileOriginal) throws StopRequestException {
        String fileCopy = fileOriginal + COPY_SUFFIX;
        long newLength = this.copyFileTruncatingLastBytesIfNeeded(fileOriginal, fileCopy);
        this.replace(fileOriginal, fileCopy);
        return newLength;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long copyFileTruncatingLastBytesIfNeeded(String fileOriginal, String fileCopy) throws StopRequestException {
        out = null;
        outFd = null;
        in = null;
        try {
            fileInputStream = new FileInputStream(fileOriginal);
            out = fileOutputStream = new FileOutputStream(fileCopy);
            outFd = fileOutputStream.getFD();
            in = fileInputStream;
            buffer = new byte[512];
            readTotal = 0;
            while (true) {
                readLast = this.readBlock(fileInputStream, buffer);
                if (readLast == -1 || this.isFullOfZeroes(buffer)) {
                    var11_12 = readTotal;
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException e) {
            try {
                throw new StopRequestException(492, (Throwable)e);
            }
            catch (Throwable var13_14) {
                IOHelpers.closeAfterWrite(out, outFd);
                IOHelpers.closeQuietly(in);
                throw var13_14;
            }
        }
        IOHelpers.closeAfterWrite(out, outFd);
        IOHelpers.closeQuietly(in);
        return var11_12;
lbl-1000:
        // 1 sources

        {
            out.write(buffer, 0, readLast);
            readTotal += readLast;
            if (readLast == 512) ** continue;
            var11_13 = readTotal;
        }
        IOHelpers.closeAfterWrite(out, outFd);
        IOHelpers.closeQuietly(in);
        return var11_13;
    }

    private boolean isFullOfZeroes(byte[] buffer) {
        for (byte b : buffer) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private int readBlock(FileInputStream fileInputStream, byte[] buffer) throws IOException {
        int read;
        int readLast;
        for (read = 0; read < 512; read += readLast) {
            readLast = fileInputStream.read(buffer, read, 512 - read);
            if (readLast != -1) continue;
            return read;
        }
        return read;
    }

    private void replace(String fileOriginal, String fileCopy) {
        File oldFile = new File(fileOriginal);
        File newFile = new File(fileCopy);
        boolean deleted = oldFile.delete();
        boolean renamed = newFile.renameTo(oldFile);
        if (!deleted || !renamed) {
            throw new IllegalStateException("Could not replace file by truncated one");
        }
    }
}

