/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.text.TextUtils;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.StopRequestException;
import com.novoda.notils.logger.simple.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

class StorageManager {
    private static final long MAX_DOWNLOAD_DATA_DIR_SIZE_BYTES = 0x6400000L;
    private static final long DOWNLOAD_DATA_DIR_LOW_SPACE_THRESHOLD_BYTES = 0xA00000L;
    private final File externalStorageDir;
    private final File internalStorageDir;
    private final File systemCacheDir;
    private final File downloadDataDir;
    private static final int FREQUENCY_OF_CHECKS_ON_SPACE_AVAILABILITY = 0x100000;
    private int bytesDownloadedSinceLastCheckOnSpace = 0;
    private final ContentResolver contentResolver;
    private final DownloadsUriProvider downloadsUriProvider;
    private static final int FREQUENCY_OF_DATABASE_N_FILESYSTEM_CLEANUP = 250;
    private int numDownloadsSoFar = 0;
    private Thread cleanupThread = null;

    StorageManager(ContentResolver contentResolver, File externalStorageDir, File internalStorageDir, File systemCacheDir, File downloadDataDir, DownloadsUriProvider downloadsUriProvider) {
        this.contentResolver = contentResolver;
        this.externalStorageDir = externalStorageDir;
        this.internalStorageDir = internalStorageDir;
        this.systemCacheDir = systemCacheDir;
        this.downloadDataDir = downloadDataDir;
        this.downloadsUriProvider = downloadsUriProvider;
        this.startThreadToCleanupDatabaseAndPurgeFileSystem();
    }

    synchronized void incrementNumDownloadsSoFar() {
        if (++this.numDownloadsSoFar % 250 == 0) {
            this.startThreadToCleanupDatabaseAndPurgeFileSystem();
        }
    }

    private synchronized void startThreadToCleanupDatabaseAndPurgeFileSystem() {
        if (this.cleanupThread != null && this.cleanupThread.isAlive()) {
            return;
        }
        this.cleanupThread = new Thread(){

            @Override
            public void run() {
                StorageManager.this.removeSpuriousFiles();
                StorageManager.this.trimDatabase();
            }
        };
        this.cleanupThread.start();
    }

    void verifySpaceBeforeWritingToFile(int destination, String path, long length) throws StopRequestException {
        if (this.incrementBytesDownloadedSinceLastCheckOnSpace(length) < 0x100000) {
            return;
        }
        this.verifySpace(destination, path, length);
    }

    void verifySpace(int destination, String path, long length) throws StopRequestException {
        this.resetBytesDownloadedSinceLastCheckOnSpace();
        File dir = null;
        if (path == null) {
            throw new IllegalArgumentException("path can't be null");
        }
        switch (destination) {
            case 1: 
            case 2: 
            case 3: {
                dir = this.downloadDataDir;
                break;
            }
            case 0: {
                dir = this.externalStorageDir;
                break;
            }
            case 5: {
                dir = this.systemCacheDir;
                break;
            }
            case 4: {
                if (path.startsWith(this.externalStorageDir.getPath())) {
                    dir = this.externalStorageDir;
                    break;
                }
                if (path.startsWith(this.downloadDataDir.getPath())) {
                    dir = this.downloadDataDir;
                    break;
                }
                if (path.startsWith(this.systemCacheDir.getPath())) {
                    dir = this.systemCacheDir;
                    break;
                }
                if (!path.startsWith(this.internalStorageDir.getPath())) break;
                dir = this.internalStorageDir;
            }
        }
        if (dir == null) {
            throw new IllegalStateException("invalid combination of destination: " + destination + ", path: " + path);
        }
        this.findSpace(dir, length, destination);
    }

    private synchronized void findSpace(File root, long targetBytes, int destination) throws StopRequestException {
        if (targetBytes == 0L) {
            return;
        }
        if (!(destination != 4 && destination != 0 || Environment.getExternalStorageState().equals("mounted"))) {
            throw new StopRequestException(199, "external media not mounted");
        }
        long bytesAvailable = this.getAvailableBytesInFileSystemAtGivenRoot(root);
        if (bytesAvailable < 0xA00000L) {
            this.discardPurgeableFiles(destination, 0xA00000L);
            this.removeSpuriousFiles();
            bytesAvailable = this.getAvailableBytesInFileSystemAtGivenRoot(root);
            if (bytesAvailable < 0xA00000L) {
                if (root.equals(this.systemCacheDir)) {
                    Log.w((Object[])new Object[]{"System cache dir ('/cache') is running low on space.space available (in bytes): " + bytesAvailable});
                } else {
                    throw new StopRequestException(198, "space in the filesystem rooted at: " + root + " is below 10% availability. stopping this download.");
                }
            }
        }
        if (root.equals(this.downloadDataDir)) {
            bytesAvailable = this.getAvailableBytesInDownloadsDataDir(this.downloadDataDir);
            if (bytesAvailable < 0xA00000L) {
                Log.w((Object[])new Object[]{"Downloads data dir: " + root + " is running low on space. space available (in bytes): " + bytesAvailable});
            }
            if (bytesAvailable < targetBytes) {
                this.discardPurgeableFiles(destination, 0xA00000L);
                this.removeSpuriousFiles();
                bytesAvailable = this.getAvailableBytesInDownloadsDataDir(this.downloadDataDir);
            }
        }
        if (bytesAvailable < targetBytes) {
            throw new StopRequestException(198, "not enough free space in the filesystem rooted at: " + root + " and unable to free any more");
        }
    }

    private long getAvailableBytesInDownloadsDataDir(File root) {
        File[] files = root.listFiles();
        long space = 0x6400000L;
        if (files == null) {
            return space;
        }
        for (File file : files) {
            space -= file.length();
        }
        return space;
    }

    private long getAvailableBytesInFileSystemAtGivenRoot(File root) {
        StatFs stat = new StatFs(root.getPath());
        long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
        long size = (long)stat.getBlockSize() * availableBlocks;
        return size;
    }

    File locateDestinationDirectory(String mimeType, int destination, long contentLength) throws StopRequestException {
        switch (destination) {
            case 1: 
            case 2: 
            case 3: {
                return this.downloadDataDir;
            }
            case 5: {
                return this.systemCacheDir;
            }
            case 0: {
                File base = new File(this.externalStorageDir.getPath() + "/download");
                if (!base.isDirectory() && !base.mkdir()) {
                    throw new StopRequestException(492, "unable to create external downloads directory " + base.getPath());
                }
                return base;
            }
        }
        throw new IllegalStateException("unexpected value for destination: " + destination);
    }

    File getDownloadDataDirectory() {
        return this.downloadDataDir;
    }

    public static File getDownloadDataDirectory(Context context) {
        return context.getCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long discardPurgeableFiles(int destination, long targetBytes) {
        Log.i((Object[])new Object[]{"discardPurgeableFiles: destination = " + destination + ", targetBytes = " + targetBytes});
        String destStr = destination == 5 ? String.valueOf(destination) : String.valueOf(2);
        String[] bindArgs = new String[]{destStr};
        Cursor cursor = this.contentResolver.query(this.downloadsUriProvider.getAllDownloadsUri(), null, "( status = '200' AND destination = ? )", bindArgs, "last_modified_timestamp");
        if (cursor == null) {
            return 0L;
        }
        long totalFreed = 0L;
        try {
            int dataIndex = cursor.getColumnIndex("_data");
            while (cursor.moveToNext() && totalFreed < targetBytes) {
                String data = cursor.getString(dataIndex);
                if (TextUtils.isEmpty((CharSequence)data)) continue;
                File file = new File(data);
                Log.d((Object[])new Object[]{"purging " + file.getAbsolutePath() + " for " + file.length() + " bytes"});
                totalFreed += file.length();
                file.delete();
                long id = cursor.getLong(cursor.getColumnIndex("_id"));
                this.contentResolver.delete(ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)id), null, null);
            }
        }
        finally {
            cursor.close();
        }
        Log.i((Object[])new Object[]{"Purged files, freed " + totalFreed + " for " + targetBytes + " requested"});
        return totalFreed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSpuriousFiles() {
        Log.i((Object[])new Object[]{"in removeSpuriousFiles"});
        ArrayList<File> files = new ArrayList<File>();
        File[] listOfFiles = this.systemCacheDir.listFiles();
        if (listOfFiles != null) {
            files.addAll(Arrays.asList(listOfFiles));
        }
        if ((listOfFiles = this.downloadDataDir.listFiles()) != null) {
            files.addAll(Arrays.asList(listOfFiles));
        }
        if (files.size() == 0) {
            return;
        }
        try (Cursor cursor = this.contentResolver.query(this.downloadsUriProvider.getAllDownloadsUri(), new String[]{"_data"}, null, null, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String filename = cursor.getString(0);
                    if (TextUtils.isEmpty((CharSequence)filename)) continue;
                    Log.v((Object[])new Object[]{"in removeSpuriousFiles, preserving file " + filename});
                    files.remove(new File(filename));
                }
            }
        }
        int myUid = Process.myUid();
        for (File file : files) {
            String path = file.getAbsolutePath();
            Log.v((Object[])new Object[]{"deleting spurious file " + path});
            if (!file.delete()) continue;
            Log.v((Object[])new Object[]{"spurious file deleted"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimDatabase() {
        block9: {
            Log.i((Object[])new Object[]{"in trimDatabase"});
            try (Cursor cursor = null;){
                cursor = this.contentResolver.query(this.downloadsUriProvider.getAllDownloadsUri(), new String[]{"_id"}, "status >= '200'", null, "last_modified_timestamp");
                if (cursor == null) {
                    Log.e((Object[])new Object[]{"null cursor in trimDatabase"});
                    return;
                }
                if (!cursor.moveToFirst()) break block9;
                int columnId = cursor.getColumnIndexOrThrow("_id");
                for (int numDelete = cursor.getCount() - 1000; numDelete > 0; --numDelete) {
                    Uri downloadUri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)cursor.getLong(columnId));
                    this.contentResolver.delete(downloadUri, null, null);
                    if (cursor.moveToNext()) continue;
                    break;
                }
            }
        }
    }

    private synchronized int incrementBytesDownloadedSinceLastCheckOnSpace(long val) {
        this.bytesDownloadedSinceLastCheckOnSpace = (int)((long)this.bytesDownloadedSinceLastCheckOnSpace + val);
        return this.bytesDownloadedSinceLastCheckOnSpace;
    }

    private synchronized void resetBytesDownloadedSinceLastCheckOnSpace() {
        this.bytesDownloadedSinceLastCheckOnSpace = 0;
    }
}

