/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.format.Formatter;
import com.novoda.notils.logger.simple.Log;
import java.util.LinkedList;
import java.util.Queue;

public class SizeLimitActivity
extends Activity
implements DialogInterface.OnCancelListener,
DialogInterface.OnClickListener {
    private final Queue<Intent> downloadsToShow = new LinkedList<Intent>();
    private Dialog dialog;
    private Uri currentUri;
    private Intent currentIntent;

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        Intent intent = this.getIntent();
        if (intent != null) {
            this.downloadsToShow.add(intent);
            this.setIntent(null);
            this.showNextDialog();
        }
        if (this.dialog != null && !this.dialog.isShowing()) {
            this.dialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNextDialog() {
        if (this.dialog != null) {
            return;
        }
        if (this.downloadsToShow.isEmpty()) {
            this.finish();
            return;
        }
        this.currentIntent = this.downloadsToShow.poll();
        this.currentUri = this.currentIntent.getData();
        try (Cursor cursor = this.getContentResolver().query(this.currentUri, null, null, null, null);){
            if (!cursor.moveToFirst()) {
                Log.e((Object[])new Object[]{"Empty cursor for URI " + this.currentUri});
                this.dialogClosed();
                return;
            }
            this.showDialog(cursor);
        }
    }

    private void showDialog(Cursor cursor) {
        int size = cursor.getInt(cursor.getColumnIndexOrThrow("total_bytes"));
        String sizeString = Formatter.formatFileSize((Context)this, (long)size);
        String queueText = "Queue";
        boolean isWifiRequired = this.currentIntent.getExtras().getBoolean("isWifiRequired");
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, 2);
        if (isWifiRequired) {
            builder.setTitle((CharSequence)"Download too large for operator network").setMessage((CharSequence)("You must use Wi-Fi to complete this" + sizeString + " download. " + "\n\n Touch " + queueText + "to start this download the next time " + "you're connected to a Wi-Fi network.")).setPositiveButton((CharSequence)"Queue", (DialogInterface.OnClickListener)this).setNegativeButton((CharSequence)"Cancel", (DialogInterface.OnClickListener)this);
        } else {
            builder.setTitle((CharSequence)"Queue for download later?").setMessage((CharSequence)("Starting this " + sizeString + " download now may shorten your batter life and/or result in " + "excessive usage of your mobile data connection. Which can lead to charges by your mobile operator " + "depending on your data plan." + "\n\n Touch " + queueText + " to start this download the next time you're connected to a Wi-Fi network.")).setPositiveButton((CharSequence)"", (DialogInterface.OnClickListener)this).setNegativeButton((CharSequence)"", (DialogInterface.OnClickListener)this);
        }
        this.dialog = builder.setOnCancelListener((DialogInterface.OnCancelListener)this).show();
    }

    public void onCancel(DialogInterface dialog) {
        this.dialogClosed();
    }

    private void dialogClosed() {
        this.dialog = null;
        this.currentUri = null;
        this.showNextDialog();
    }

    public void onClick(@NonNull DialogInterface dialog, int which) {
        boolean isRequired = this.currentIntent.getExtras().getBoolean("isWifiRequired");
        if (isRequired && which == -2) {
            this.getContentResolver().delete(this.currentUri, null, null);
        } else if (!isRequired && which == -1) {
            ContentValues values = new ContentValues();
            values.put("bypass_recommended_size_limit", Boolean.valueOf(true));
            this.getContentResolver().update(this.currentUri, values, null, null);
        }
        this.dialogClosed();
    }
}

