/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentValues;
import com.novoda.downloadmanager.lib.BatchInfo;
import com.novoda.downloadmanager.lib.Request;
import java.util.ArrayList;
import java.util.List;

public class RequestBatch {
    private final BatchInfo batchInfo;
    private final List<Request> requests;

    RequestBatch(BatchInfo batchInfo, List<Request> requests) {
        this.batchInfo = batchInfo;
        this.requests = requests;
    }

    public String getTitle() {
        return this.batchInfo.getTitle();
    }

    public String getDescription() {
        return this.batchInfo.getDescription();
    }

    public String getBigPictureUrl() {
        return this.batchInfo.getBigPictureUrl();
    }

    public String getExtraData() {
        return this.batchInfo.getExtraData();
    }

    List<Request> getRequests() {
        return this.requests;
    }

    public void addRequest(Request request) {
        this.requests.add(request);
    }

    ContentValues toContentValues() {
        ContentValues values = new ContentValues();
        values.put("batch_title", this.batchInfo.getTitle());
        values.put("batch_description", this.batchInfo.getDescription());
        values.put("batch_notificationBigPictureResourceId", this.batchInfo.getBigPictureUrl());
        values.put("visibility", Integer.valueOf(this.batchInfo.getVisibility()));
        values.put("extra_data", this.batchInfo.getExtraData());
        return values;
    }

    public static class Builder {
        private String title;
        private String description;
        private String bigPictureUrl;
        private int visibility;
        private String extraData;

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withBigPictureUrl(String bigPictureUrl) {
            this.bigPictureUrl = bigPictureUrl;
            return this;
        }

        public Builder withVisibility(int visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder withExtraData(String extraData) {
            this.extraData = extraData;
            return this;
        }

        public RequestBatch build() {
            BatchInfo batchInfo = new BatchInfo(this.title, this.description, this.bigPictureUrl, this.visibility, this.extraData);
            return new RequestBatch(batchInfo, new ArrayList<Request>());
        }
    }
}

