/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentValues;
import android.net.Uri;
import android.os.Environment;
import android.util.Pair;
import com.novoda.downloadmanager.lib.GlobalState;
import com.novoda.downloadmanager.lib.RequestBatch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Request {
    public static final int NETWORK_MOBILE = 1;
    public static final int NETWORK_WIFI = 2;
    public static final int NETWORK_BLUETOOTH = 4;
    private final List<Pair<String, String>> requestHeaders = new ArrayList<Pair<String, String>>();
    private Uri uri;
    private Uri destinationUri;
    private CharSequence title = "";
    private CharSequence description = "";
    private String mimeType;
    private int allowedNetworkTypes = -1;
    private boolean roamingAllowed = true;
    private boolean meteredAllowed = true;
    private boolean isVisibleInDownloadsUi = true;
    private boolean scannable = false;
    private String notificationExtras;
    private String bigPictureUrl = "";
    private long batchId = -1L;
    private String extraData;
    private boolean alwaysResume;
    private boolean allowTarUpdates;
    static final int SCANNABLE_VALUE_YES = 0;
    static final int SCANNABLE_VALUE_NO = 2;
    private int notificationVisibility = 0;

    public Request(Uri uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
            throw new IllegalArgumentException("Can only download HTTP/HTTPS URIs: " + uri);
        }
        this.uri = uri;
    }

    Request(String uriString) {
        this.uri = Uri.parse((String)uriString);
    }

    public Request setDestinationUri(Uri uri) {
        this.destinationUri = uri;
        return this;
    }

    public Request setDestinationInExternalFilesDir(String dirType, String subPath) {
        File file = GlobalState.getContext().getExternalFilesDir(dirType);
        if (file == null) {
            throw new IllegalStateException("Failed to get external storage files directory");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
            }
        } else if (!file.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
        }
        this.setDestinationFromBase(file, subPath);
        return this;
    }

    public Request setDestinationInInternalFilesDir(String dirType, String subPath) {
        File file = new File(GlobalState.getContext().getFilesDir(), dirType);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
            }
        } else if (!file.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
        }
        this.setDestinationFromBase(file, subPath);
        return this;
    }

    public Request setDestinationInExternalPublicDir(String dirType, String subPath) {
        File file = Environment.getExternalStoragePublicDirectory((String)dirType);
        if (file == null) {
            throw new IllegalStateException("Failed to get external storage public directory");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
            }
        } else if (!file.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
        }
        this.setDestinationFromBase(file, subPath);
        return this;
    }

    private void setDestinationFromBase(File base, String subPath) {
        if (subPath == null) {
            throw new NullPointerException("subPath cannot be null");
        }
        this.destinationUri = Uri.withAppendedPath((Uri)Uri.fromFile((File)base), (String)subPath);
    }

    public void allowScanningByMediaScanner() {
        this.scannable = true;
    }

    public Request alwaysAttemptResume() {
        this.alwaysResume = true;
        return this;
    }

    public Request allowTarUpdates() {
        this.allowTarUpdates = true;
        this.alwaysAttemptResume();
        return this;
    }

    public Request addRequestHeader(String header, String value) {
        if (header == null) {
            throw new NullPointerException("header cannot be null");
        }
        if (header.contains(":")) {
            throw new IllegalArgumentException("header may not contain ':'");
        }
        if (value == null) {
            value = "";
        }
        this.requestHeaders.add((Pair<String, String>)Pair.create((Object)header, (Object)value));
        return this;
    }

    public Request setTitle(CharSequence title) {
        this.title = title;
        return this;
    }

    public Request setDescription(CharSequence description) {
        this.description = description;
        return this;
    }

    public Request setBigPictureUrl(String bigPictureUrl) {
        this.bigPictureUrl = bigPictureUrl;
        return this;
    }

    Request setBatchId(long batchId) {
        this.batchId = batchId;
        return this;
    }

    public Request setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Deprecated
    public Request setShowRunningNotification(boolean show) {
        return show ? this.setNotificationVisibility(0) : this.setNotificationVisibility(2);
    }

    public Request setNotificationVisibility(int visibility) {
        this.notificationVisibility = visibility;
        return this;
    }

    public Request setAllowedNetworkTypes(int flags) {
        this.allowedNetworkTypes = flags;
        return this;
    }

    public Request setAllowedOverRoaming(boolean allowed) {
        this.roamingAllowed = allowed;
        return this;
    }

    public Request setAllowedOverMetered(boolean allow) {
        this.meteredAllowed = allow;
        return this;
    }

    public Request setVisibleInDownloadsUi(boolean isVisible) {
        this.isVisibleInDownloadsUi = isVisible;
        return this;
    }

    public Request setNotificationExtra(String extra) {
        this.notificationExtras = extra;
        return this;
    }

    public Request setExtraData(String extra) {
        this.extraData = extra;
        return this;
    }

    long getBatchId() {
        return this.batchId;
    }

    ContentValues toContentValues() {
        ContentValues values = new ContentValues();
        assert (this.uri != null);
        values.put("uri", this.uri.toString());
        if (this.destinationUri != null) {
            values.put("destination", Integer.valueOf(4));
            values.put("hint", this.destinationUri.toString());
        } else {
            values.put("destination", Integer.valueOf(2));
        }
        values.put("scanned", Integer.valueOf(this.scannable ? 0 : 2));
        if (!this.requestHeaders.isEmpty()) {
            this.encodeHttpHeaders(values);
        }
        this.putIfNonNull(values, "mimetype", this.mimeType);
        values.put("allowed_network_types", Integer.valueOf(this.allowedNetworkTypes));
        values.put("allow_roaming", Boolean.valueOf(this.roamingAllowed));
        values.put("allow_metered", Boolean.valueOf(this.meteredAllowed));
        values.put("is_visible_in_downloads_ui", Boolean.valueOf(this.isVisibleInDownloadsUi));
        values.put("notificationextras", this.notificationExtras);
        values.put("batch_id", Long.valueOf(this.batchId));
        values.put("extra_data", this.extraData);
        values.put("always_resume", Boolean.valueOf(this.alwaysResume));
        values.put("allow_tar_updates", Boolean.valueOf(this.allowTarUpdates));
        return values;
    }

    private void encodeHttpHeaders(ContentValues values) {
        int index = 0;
        for (Pair<String, String> header : this.requestHeaders) {
            String headerString = (String)header.first + ": " + (String)header.second;
            values.put("http_header_" + index, headerString);
            ++index;
        }
    }

    private void putIfNonNull(ContentValues contentValues, String key, Object value) {
        if (value != null) {
            contentValues.put(key, value.toString());
        }
    }

    RequestBatch asBatch() {
        RequestBatch requestBatch = new RequestBatch.Builder().withTitle(this.title.toString()).withDescription(this.description.toString()).withBigPictureUrl(this.bigPictureUrl).withVisibility(this.notificationVisibility).build();
        requestBatch.addRequest(this);
        return requestBatch;
    }
}

