/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import java.lang.reflect.Field;

final class Reflector {
    private static final String CLASS_NAME = "com.novoda.downloadmanager.Authority";
    private static final String CONSTANT_FULL_NAME = "com.novoda.downloadmanager.Authority.AUTHORITY";
    private static String cachedAuthority;

    private Reflector() {
    }

    static String reflectAuthority() {
        if (cachedAuthority == null) {
            try {
                Class<?> authorityClass = Class.forName(CLASS_NAME);
                Field authorityField = authorityClass.getDeclaredField("AUTHORITY");
                Object o = authorityField.get(authorityClass);
                cachedAuthority = (String)o;
            }
            catch (ClassNotFoundException e) {
                Reflector.throwNoAuthorityClass();
            }
            catch (NoSuchFieldException e) {
                Reflector.throwNoAuthorityField();
            }
            catch (IllegalAccessException e) {
                Reflector.throwHiddenFieldName();
            }
            catch (ClassCastException e) {
                Reflector.throwNotAString();
            }
        }
        return cachedAuthority;
    }

    private static void throwNotAString() {
        throw new IllegalArgumentException("com.novoda.downloadmanager.Authority.AUTHORITY is not a string");
    }

    private static void throwHiddenFieldName() {
        throw new IllegalStateException("com.novoda.downloadmanager.Authority.AUTHORITY is not a visible field");
    }

    private static void throwNoAuthorityField() {
        throw new NullPointerException("com.novoda.downloadmanager.Authority.AUTHORITY was not defined");
    }

    private static void throwNoAuthorityClass() {
        throw new NullPointerException("com.novoda.downloadmanager.Authority is not defined. See the documentation.");
    }
}

