/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.app.DownloadManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.novoda.downloadmanager.lib.NetworkMeter;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.notils.logger.simple.Log;

class RealSystemFacade
implements SystemFacade {
    private final Context context;

    public RealSystemFacade(Context context) {
        this.context = context;
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public NetworkInfo getActiveNetworkInfo(int uid) {
        throw new IllegalStateException("We can't implement this :-(");
    }

    @Override
    public NetworkInfo getActiveNetworkInfo() {
        return ((ConnectivityManager)this.context.getSystemService("connectivity")).getActiveNetworkInfo();
    }

    @Override
    public boolean isActiveNetworkMetered() {
        ConnectivityManager conn = (ConnectivityManager)this.context.getSystemService("connectivity");
        return NetworkMeter.Factory.get(conn).isActiveNetworkMetered();
    }

    @Override
    public boolean isNetworkRoaming() {
        boolean isRoaming;
        ConnectivityManager connectivity = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (connectivity == null) {
            Log.w((Object[])new Object[]{"couldn't get connectivity manager"});
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        boolean isMobile = info != null && info.getType() == 0;
        TelephonyManager telephony = (TelephonyManager)this.context.getSystemService("phone");
        boolean bl = isRoaming = isMobile && telephony.isNetworkRoaming();
        if (isRoaming) {
            Log.v((Object[])new Object[]{"network is roaming"});
        }
        return isRoaming;
    }

    @Override
    public Long getMaxBytesOverMobile() {
        return DownloadManager.getMaxBytesOverMobile((Context)this.context);
    }

    @Override
    public Long getRecommendedMaxBytesOverMobile() {
        return DownloadManager.getRecommendedMaxBytesOverMobile((Context)this.context);
    }

    @Override
    public void sendBroadcast(Intent intent) {
        this.context.sendBroadcast(intent);
    }

    @Override
    public boolean userOwnsPackage(int uid, String packageName) throws PackageManager.NameNotFoundException {
        return this.context.getPackageManager().getApplicationInfo((String)packageName, (int)0).uid == uid;
    }
}

