/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import com.novoda.downloadmanager.lib.DownloadManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Query {
    public static final int ORDER_ASCENDING = 1;
    public static final int ORDER_DESCENDING = 2;
    private static final String ORDER_BY_LIVENESS = String.format(Locale.US, "CASE %1$s WHEN %2$d THEN 1 WHEN %3$d THEN 2 WHEN %4$d THEN 3 WHEN %5$d THEN 4 WHEN %6$d THEN 5 ELSE 6 END, _id ASC", "status", 192, 190, 193, 498, 200);
    private long[] downloadIds = null;
    private long[] batchIds = null;
    private Integer statusFlags = null;
    private boolean onlyIncludeVisibleInDownloadsUi = false;
    private String[] filterNotificiationExtras;
    private String[] filterExtraData;
    private String orderString = "last_modified_timestamp DESC";

    public Query setFilterById(long ... downloadIds) {
        this.downloadIds = downloadIds;
        return this;
    }

    public Query setFilterByBatchId(long ... batchIds) {
        this.batchIds = batchIds;
        return this;
    }

    public Query setFilterByNotificationExtras(String ... extras) {
        this.filterNotificiationExtras = extras;
        return this;
    }

    public Query setFilterByExtraData(String ... extraData) {
        this.filterExtraData = extraData;
        return this;
    }

    public Query setFilterByStatus(int flags) {
        this.statusFlags = flags;
        return this;
    }

    public Query setOnlyIncludeVisibleInDownloadsUi(boolean value) {
        this.onlyIncludeVisibleInDownloadsUi = value;
        return this;
    }

    public Query orderBy(String column, int direction) {
        String resolvedOrderColumn;
        if (direction != 1 && direction != 2) {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
        switch (column) {
            case "last_modified_timestamp": {
                resolvedOrderColumn = "last_modified_timestamp";
                break;
            }
            case "total_size": {
                resolvedOrderColumn = "total_bytes";
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot order by " + column);
            }
        }
        String orderDirection = direction == 1 ? "ASC" : "DESC";
        this.orderString = resolvedOrderColumn + " " + orderDirection;
        return this;
    }

    public Query orderByLiveness() {
        this.orderString = ORDER_BY_LIVENESS;
        return this;
    }

    Cursor runQuery(ContentResolver resolver, String[] projection, Uri baseUri) {
        ArrayList<String> selectionParts = new ArrayList<String>();
        String[] selectionArgs = this.getIdsAsStringArray(this.downloadIds);
        this.filterByDownloadIds(selectionParts);
        this.filterByBatchIds(selectionParts);
        this.filterByNotificationExtras(selectionParts);
        this.filterByExtraData(selectionParts);
        this.filterByStatus(selectionParts);
        if (this.onlyIncludeVisibleInDownloadsUi) {
            selectionParts.add("is_visible_in_downloads_ui != '0'");
        }
        selectionParts.add("deleted != '1'");
        String selection = Query.joinStrings(" AND ", selectionParts);
        return resolver.query(baseUri, projection, selection, selectionArgs, this.orderString);
    }

    private String[] getIdsAsStringArray(long[] ids) {
        if (ids == null) {
            return null;
        }
        return Query.longArrayToStringArray(ids);
    }

    private void filterByDownloadIds(List<String> selectionParts) {
        if (this.downloadIds == null) {
            return;
        }
        selectionParts.add(DownloadManager.getWhereClauseFor(this.downloadIds, "_id"));
    }

    private void filterByBatchIds(List<String> selectionParts) {
        if (this.batchIds == null || this.batchIds.length == 0) {
            return;
        }
        selectionParts.add(this.getWhereClauseForBatchIds(this.batchIds));
    }

    private String getWhereClauseForBatchIds(long[] ids) {
        String[] idStrings = Query.longArrayToStringArray(ids);
        return "batch_id IN (" + Query.joinStrings(",", Arrays.asList(idStrings)) + ")";
    }

    private void filterByNotificationExtras(List<String> selectionParts) {
        if (this.filterNotificiationExtras == null || this.filterNotificiationExtras.length == 0) {
            return;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String filterExtra : this.filterNotificiationExtras) {
            parts.add(this.notificationExtrasClause(filterExtra));
        }
        selectionParts.add("(" + Query.joinStrings(" OR ", parts) + ")");
    }

    private void filterByExtraData(List<String> selectionParts) {
        if (this.filterExtraData == null) {
            return;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String filterExtra : this.filterExtraData) {
            parts.add(this.extraDataClause(filterExtra));
        }
        selectionParts.add(Query.joinStrings(" OR ", parts));
    }

    private void filterByStatus(List<String> selectionParts) {
        if (this.statusFlags == null) {
            return;
        }
        ArrayList<String> parts = new ArrayList<String>();
        if ((this.statusFlags & 1) != 0) {
            parts.add(this.statusClause("=", 190));
        }
        if ((this.statusFlags & 2) != 0) {
            parts.add(this.statusClause("=", 192));
        }
        if ((this.statusFlags & 4) != 0) {
            parts.add(this.statusClause("=", 193));
            parts.add(this.statusClause("=", 194));
            parts.add(this.statusClause("=", 195));
            parts.add(this.statusClause("=", 196));
        }
        if ((this.statusFlags & 8) != 0) {
            parts.add(this.statusClause("=", 200));
        }
        if ((this.statusFlags & 0x20) != 0) {
            parts.add(this.statusClause("=", 188));
        }
        if ((this.statusFlags & 0x10) != 0) {
            parts.add("(" + this.statusClause(">=", 400) + " AND " + this.statusClause("<", 600) + ")");
        }
        selectionParts.add(Query.joinStrings(" OR ", parts));
    }

    private static String joinStrings(String joiner, Iterable<String> parts) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (!first) {
                builder.append(joiner);
            }
            builder.append(part);
            first = false;
        }
        return builder.toString();
    }

    private static String[] longArrayToStringArray(long[] longs) {
        String[] strings = new String[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            strings[i] = Long.toString(longs[i]);
        }
        return strings;
    }

    private String notificationExtrasClause(String extra) {
        return "notificationextras = '" + extra + "'";
    }

    private String extraDataClause(String extra) {
        return "extra_data = '" + extra + "'";
    }

    private String statusClause(String operator, int value) {
        return "status" + operator + "'" + value + "'";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Order {
    }
}

