/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcelable;
import com.novoda.downloadmanager.lib.DownloadDrmHelper;
import com.novoda.downloadmanager.lib.DownloadManager;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.Query;
import java.io.File;

class OpenHelper {
    private final DownloadManager downloadManager;
    private final DownloadsUriProvider downloadsUriProvider;

    public OpenHelper(DownloadManager downloadManager, DownloadsUriProvider downloadsUriProvider) {
        this.downloadManager = downloadManager;
        this.downloadsUriProvider = downloadsUriProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent buildViewIntent(Context context, long id) {
        this.downloadManager.setAccessAllDownloads(true);
        try (Cursor cursor = this.downloadManager.query(new Query().setFilterById(id));){
            if (!cursor.moveToFirst()) {
                throw new IllegalArgumentException("Missing download " + id);
            }
            Uri localUri = OpenHelper.getCursorUri(cursor, "local_uri");
            File file = OpenHelper.getCursorFile(cursor, "local_filename");
            String mimeType = OpenHelper.getCursorString(cursor, "media_type");
            mimeType = DownloadDrmHelper.getOriginalMimeType(context, file, mimeType);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(1);
            if ("application/vnd.android.package-archive".equals(mimeType)) {
                intent.setDataAndType(localUri, mimeType);
                Uri remoteUri = OpenHelper.getCursorUri(cursor, "uri");
                intent.putExtra("android.intent.extra.ORIGINATING_URI", (Parcelable)remoteUri);
                intent.putExtra("android.intent.extra.REFERRER", (Parcelable)this.getRefererUri(context, id));
                intent.putExtra("android.intent.extra.ORIGINATING_UID", this.getOriginatingUid(context, id));
            } else if ("file".equals(localUri.getScheme())) {
                intent.setDataAndType(ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)id), mimeType);
            } else {
                intent.setDataAndType(localUri, mimeType);
            }
            Intent intent2 = intent;
            return intent2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Uri getRefererUri(Context context, long id) {
        Uri headersUri = Uri.withAppendedPath((Uri)ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)id), (String)"headers");
        try (Cursor headers = context.getContentResolver().query(headersUri, null, null, null, null);){
            while (headers.moveToNext()) {
                String header = OpenHelper.getCursorString(headers, "header");
                if (!"Referer".equalsIgnoreCase(header)) continue;
                Uri uri = OpenHelper.getCursorUri(headers, "value");
                return uri;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOriginatingUid(Context context, long id) {
        Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)id);
        Cursor cursor = context.getContentResolver().query(uri, new String[]{"uid"}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    int n = cursor.getInt(cursor.getColumnIndexOrThrow("uid"));
                    return n;
                }
            }
            finally {
                cursor.close();
            }
        }
        return -1;
    }

    private static String getCursorString(Cursor cursor, String column) {
        return cursor.getString(cursor.getColumnIndexOrThrow(column));
    }

    private static Uri getCursorUri(Cursor cursor, String column) {
        return Uri.parse((String)OpenHelper.getCursorString(cursor, column));
    }

    private static long getCursorLong(Cursor cursor, String column) {
        return cursor.getLong(cursor.getColumnIndexOrThrow(column));
    }

    private static File getCursorFile(Cursor cursor, String column) {
        return new File(cursor.getString(cursor.getColumnIndexOrThrow(column)));
    }
}

