/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.novoda.downloadmanager.lib.NotificationImageRetriever;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;

class OkHttpNotificationImageRetriever
implements NotificationImageRetriever {
    private final OkHttpClient client = new OkHttpClient();
    private String imageUrl;
    private Bitmap bitmap;

    @Override
    public Bitmap retrieveImage(String imageUrl) {
        if (imageUrl.equals(this.imageUrl)) {
            return this.bitmap;
        }
        return this.fetchBitmap(imageUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap fetchBitmap(String imageUrl) {
        Bitmap bitmap;
        Request request = new Request.Builder().get().url(imageUrl).build();
        Response response = this.client.newCall(request).execute();
        InputStream inputStream = response.body().byteStream();
        try {
            this.bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            this.imageUrl = imageUrl;
            bitmap = this.bitmap;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        inputStream.close();
        return bitmap;
    }
}

