/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.novoda.downloadmanager.R;
import com.novoda.downloadmanager.lib.BatchInfo;
import com.novoda.downloadmanager.lib.DownloadBatch;
import com.novoda.downloadmanager.lib.DownloadReceiver;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.downloadmanager.lib.NotificationImageRetriever;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

class NotificationDisplayer {
    private final Context context;
    private final NotificationManager notificationManager;
    private final NotificationImageRetriever imageRetriever;
    private final Resources resources;
    private final DownloadsUriProvider downloadsUriProvider;
    private final LongSparseArray<Long> downloadSpeed = new LongSparseArray();

    public NotificationDisplayer(Context context, NotificationManager notificationManager, NotificationImageRetriever imageRetriever, Resources resources, DownloadsUriProvider downloadsUriProvider) {
        this.context = context;
        this.notificationManager = notificationManager;
        this.imageRetriever = imageRetriever;
        this.resources = resources;
        this.downloadsUriProvider = downloadsUriProvider;
    }

    public void buildAndShowNotification(SimpleArrayMap<String, Collection<DownloadBatch>> clusters, String notificationId, long firstShown) {
        int type = this.getNotificationTagType(notificationId);
        Collection cluster = (Collection)clusters.get((Object)notificationId);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context);
        builder.setWhen(firstShown);
        this.buildIcon(type, builder);
        this.buildActionIntents(notificationId, type, cluster, builder);
        Notification notification = this.buildTitlesAndDescription(type, cluster, builder);
        this.notificationManager.notify(notificationId.hashCode(), notification);
    }

    private int getNotificationTagType(String tag) {
        return Integer.parseInt(tag.substring(0, tag.indexOf(58)));
    }

    private void buildIcon(int type, NotificationCompat.Builder builder) {
        switch (type) {
            case 1: {
                builder.setSmallIcon(0x1080081);
                break;
            }
            case 2: 
            case 4: {
                builder.setSmallIcon(17301642);
                break;
            }
            case 3: {
                builder.setSmallIcon(17301634);
                break;
            }
            default: {
                builder.setSmallIcon(17301642);
            }
        }
    }

    private void buildActionIntents(String tag, int type, Collection<DownloadBatch> cluster, NotificationCompat.Builder builder) {
        if (type == 1 || type == 2) {
            Uri uri = new Uri.Builder().scheme("active-dl").appendPath(tag).build();
            Intent clickIntent = new Intent("android.intent.action.DOWNLOAD_LIST", uri, this.context, DownloadReceiver.class);
            clickIntent.putExtra("extra_click_download_ids", this.getDownloadIds(cluster));
            builder.setContentIntent(PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)clickIntent, (int)0x8000000));
            builder.setOngoing(true);
            DownloadBatch batch = cluster.iterator().next();
            Intent cancelIntent = new Intent("android.intent.action.DOWNLOAD_CANCEL", null, this.context, DownloadReceiver.class);
            cancelIntent.putExtra("com.novoda.extra.BATCH_ID", batch.getBatchId());
            PendingIntent pendingCancelIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)cancelIntent, (int)0x8000000);
            builder.addAction(R.drawable.dl__ic_action_cancel, (CharSequence)this.context.getString(R.string.dl__cancel), pendingCancelIntent);
        } else if (type == 3) {
            DownloadBatch batch = cluster.iterator().next();
            FileDownloadInfo fileDownloadInfo = batch.getDownloads().get(0);
            Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)fileDownloadInfo.getId());
            builder.setAutoCancel(true);
            String action = DownloadStatus.isError(batch.getStatus()) ? "android.intent.action.DOWNLOAD_LIST" : "android.intent.action.DOWNLOAD_OPEN";
            Intent intent = new Intent(action, uri, this.context, DownloadReceiver.class);
            intent.putExtra("extra_click_download_ids", this.getDownloadIds(cluster));
            intent.putExtra("com.novoda.extra.BATCH_ID", batch.getBatchId());
            builder.setContentIntent(PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0x8000000));
            Intent hideIntent = new Intent("android.intent.action.DOWNLOAD_HIDE", uri, this.context, DownloadReceiver.class);
            hideIntent.putExtra("com.novoda.extra.BATCH_ID", batch.getBatchId());
            builder.setDeleteIntent(PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)hideIntent, (int)0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Notification buildTitlesAndDescription(int type, Collection<DownloadBatch> cluster, NotificationCompat.Builder builder) {
        String remainingText = null;
        String percentText = null;
        if (type == 1) {
            long currentBytes = 0L;
            long totalBytes = 0L;
            long totalBytesPerSecond = 0L;
            LongSparseArray<Long> longSparseArray = this.downloadSpeed;
            synchronized (longSparseArray) {
                for (DownloadBatch batch : cluster) {
                    for (FileDownloadInfo info : batch.getDownloads()) {
                        if (!info.hasTotalBytes()) continue;
                        currentBytes += info.getCurrentBytes();
                        totalBytes += info.getTotalBytes();
                        Long bytesPerSecond = (Long)this.downloadSpeed.get(info.getId());
                        if (bytesPerSecond == null) continue;
                        totalBytesPerSecond += bytesPerSecond.longValue();
                    }
                }
            }
            if (totalBytes > 0L) {
                int percent = (int)(currentBytes * 100L / totalBytes);
                percentText = this.context.getString(R.string.dl__download_percent, new Object[]{percent});
                if (totalBytesPerSecond > 0L) {
                    long remainingMillis = (totalBytes - currentBytes) * 1000L / totalBytesPerSecond;
                    remainingText = this.context.getString(R.string.dl__duration, new Object[]{this.formatDuration(remainingMillis)});
                }
                builder.setProgress(100, percent, false);
            } else {
                builder.setProgress(100, 0, true);
            }
        }
        ArrayList<DownloadBatch> currentBatches = new ArrayList<DownloadBatch>();
        for (DownloadBatch batch : cluster) {
            currentBatches.add(batch);
        }
        if (currentBatches.size() == 1) {
            DownloadBatch batch = (DownloadBatch)currentBatches.iterator().next();
            return this.buildSingleNotification(type, builder, batch, remainingText, percentText);
        }
        return this.buildStackedNotification(type, builder, currentBatches, remainingText, percentText);
    }

    private Notification buildSingleNotification(int type, NotificationCompat.Builder builder, DownloadBatch batch, String remainingText, String percentText) {
        NotificationCompat.BigPictureStyle style = new NotificationCompat.BigPictureStyle();
        String imageUrl = batch.getInfo().getBigPictureUrl();
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            Bitmap bitmap = this.imageRetriever.retrieveImage(imageUrl);
            style.bigPicture(bitmap);
        }
        CharSequence title = this.getDownloadTitle(batch.getInfo());
        builder.setContentTitle(title);
        style.setBigContentTitle(title);
        if (type == 1) {
            String description = batch.getInfo().getDescription();
            if (TextUtils.isEmpty((CharSequence)description)) {
                this.setSecondaryNotificationText(builder, style, remainingText);
            } else {
                this.setSecondaryNotificationText(builder, style, description);
            }
            builder.setContentInfo((CharSequence)percentText);
        } else if (type == 2) {
            this.setSecondaryNotificationText(builder, style, this.context.getString(R.string.dl__download_size_requires_wifi));
        } else if (type == 3) {
            this.setSecondaryNotificationText(builder, style, this.context.getString(R.string.dl__download_complete));
        } else if (type == 4) {
            this.setSecondaryNotificationText(builder, style, this.context.getString(R.string.dl__download_unsuccessful));
        } else if (type == 5) {
            this.setSecondaryNotificationText(builder, style, this.context.getString(R.string.dl__download_cancelled));
        }
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            builder.setStyle((NotificationCompat.Style)style);
        }
        return builder.build();
    }

    private CharSequence getDownloadTitle(BatchInfo batch) {
        String title = batch.getTitle();
        if (TextUtils.isEmpty((CharSequence)title)) {
            return this.context.getString(R.string.dl__title_unknown);
        }
        return title;
    }

    private void setSecondaryNotificationText(NotificationCompat.Builder builder, NotificationCompat.BigPictureStyle style, String description) {
        builder.setContentText((CharSequence)description);
        style.setSummaryText((CharSequence)description);
    }

    private Notification buildStackedNotification(int type, NotificationCompat.Builder builder, Collection<DownloadBatch> currentBatches, String remainingText, String percentText) {
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle(builder);
        for (DownloadBatch batch : currentBatches) {
            inboxStyle.addLine(this.getDownloadTitle(batch.getInfo()));
        }
        if (type == 1) {
            builder.setContentTitle((CharSequence)this.resources.getQuantityString(R.plurals.dl__notif_summary_active, currentBatches.size(), new Object[]{currentBatches.size()}));
            builder.setContentInfo((CharSequence)percentText);
            this.setSecondaryNotificationText(builder, inboxStyle, remainingText);
        } else if (type == 2) {
            builder.setContentTitle((CharSequence)this.resources.getQuantityString(R.plurals.dl__notif_summary_waiting, currentBatches.size(), new Object[]{currentBatches.size()}));
            this.setSecondaryNotificationText(builder, inboxStyle, this.context.getString(R.string.dl__download_size_requires_wifi));
        } else if (type == 3) {
            this.setSecondaryNotificationText(builder, inboxStyle, this.context.getString(R.string.dl__download_complete));
        } else if (type == 4) {
            this.setSecondaryNotificationText(builder, inboxStyle, this.context.getString(R.string.dl__download_unsuccessful));
        } else if (type == 5) {
            this.setSecondaryNotificationText(builder, inboxStyle, this.context.getString(R.string.dl__download_cancelled));
        }
        return inboxStyle.build();
    }

    private void setSecondaryNotificationText(NotificationCompat.Builder builder, NotificationCompat.InboxStyle style, String description) {
        builder.setContentText((CharSequence)description);
        style.setSummaryText((CharSequence)description);
    }

    private long[] getDownloadIds(Collection<DownloadBatch> batches) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DownloadBatch batch : batches) {
            for (FileDownloadInfo fileDownloadInfo : batch.getDownloads()) {
                ids.add(fileDownloadInfo.getId());
            }
        }
        long[] idArray = new long[ids.size()];
        int idsSize = ids.size();
        for (int i = 0; i < idsSize; ++i) {
            idArray[i] = (Long)ids.get(i);
        }
        return idArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDownloadSpeed(long id, long bytesPerSecond) {
        LongSparseArray<Long> longSparseArray = this.downloadSpeed;
        synchronized (longSparseArray) {
            if (bytesPerSecond != 0L) {
                this.downloadSpeed.put(id, (Object)bytesPerSecond);
            } else {
                this.downloadSpeed.remove(id);
            }
        }
    }

    private CharSequence formatDuration(long millis) {
        if (millis >= 3600000L) {
            int hours = (int)TimeUnit.MILLISECONDS.toHours(millis + TimeUnit.MINUTES.toMillis(30L));
            return this.resources.getQuantityString(R.plurals.dl__duration_hours, hours, new Object[]{hours});
        }
        if (millis >= 60000L) {
            int minutes = (int)TimeUnit.MILLISECONDS.toMinutes(millis + TimeUnit.SECONDS.toMillis(30L));
            return this.resources.getQuantityString(R.plurals.dl__duration_minutes, minutes, new Object[]{minutes});
        }
        int seconds = (int)TimeUnit.MILLISECONDS.toSeconds(millis + 500L);
        return this.resources.getQuantityString(R.plurals.dl__duration_seconds, seconds, new Object[]{seconds});
    }

    public void cancelStaleTags(List<Integer> staleTagsToBeRemoved) {
        for (Integer tag : staleTagsToBeRemoved) {
            this.notificationManager.cancel(tag.intValue());
        }
    }

    public void cancelAll() {
        this.notificationManager.cancelAll();
    }
}

