/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.net.NetworkInfo;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.downloadmanager.lib.SystemFacade;

class NetworkChecker {
    private final SystemFacade systemFacade;

    NetworkChecker(SystemFacade systemFacade) {
        this.systemFacade = systemFacade;
    }

    public FileDownloadInfo.NetworkState checkCanUseNetwork(FileDownloadInfo downloadInfo) {
        NetworkInfo info = this.systemFacade.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return FileDownloadInfo.NetworkState.NO_CONNECTION;
        }
        if (NetworkInfo.DetailedState.BLOCKED.equals((Object)info.getDetailedState())) {
            return FileDownloadInfo.NetworkState.BLOCKED;
        }
        if (this.systemFacade.isNetworkRoaming() && !downloadInfo.allowRoaming()) {
            return FileDownloadInfo.NetworkState.CANNOT_USE_ROAMING;
        }
        if (this.systemFacade.isActiveNetworkMetered() && !downloadInfo.allowMetered()) {
            return FileDownloadInfo.NetworkState.TYPE_DISALLOWED_BY_REQUESTOR;
        }
        return this.checkIsNetworkTypeAllowed(downloadInfo, info.getType());
    }

    private FileDownloadInfo.NetworkState checkIsNetworkTypeAllowed(FileDownloadInfo downloadInfo, int networkType) {
        Long recommendedMaxBytesOverMobile;
        if (downloadInfo.getTotalBytes() <= 0L) {
            return FileDownloadInfo.NetworkState.OK;
        }
        if (networkType == 1) {
            return FileDownloadInfo.NetworkState.OK;
        }
        Long maxBytesOverMobile = this.systemFacade.getMaxBytesOverMobile();
        if (maxBytesOverMobile != null && downloadInfo.getTotalBytes() > maxBytesOverMobile) {
            return FileDownloadInfo.NetworkState.UNUSABLE_DUE_TO_SIZE;
        }
        if (downloadInfo.isRecommendedSizeLimitBypassed() && (recommendedMaxBytesOverMobile = this.systemFacade.getRecommendedMaxBytesOverMobile()) != null && downloadInfo.getTotalBytes() > recommendedMaxBytesOverMobile) {
            return FileDownloadInfo.NetworkState.RECOMMENDED_UNUSABLE_DUE_TO_SIZE;
        }
        return FileDownloadInfo.NetworkState.OK;
    }
}

