/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.net.Uri;
import android.os.Environment;
import android.os.SystemClock;
import android.webkit.MimeTypeMap;
import com.novoda.downloadmanager.lib.DownloadDrmHelper;
import com.novoda.downloadmanager.lib.StopRequestException;
import com.novoda.downloadmanager.lib.StorageManager;
import com.novoda.notils.logger.simple.Log;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Helpers {
    public static Random sRandom = new Random(SystemClock.uptimeMillis());
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"([^\"]*)\"");
    private static final Object UNIQUE_LOCK = new Object();

    private Helpers() {
    }

    private static String parseContentDisposition(String contentDisposition) {
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    static String generateSaveFile(String url, String hint, String contentDisposition, String contentLocation, String mimeType, int destination, long contentLength, StorageManager storageManager) throws StopRequestException {
        String path;
        if (contentLength < 0L) {
            contentLength = 0L;
        }
        File base = null;
        if (destination == 4) {
            path = Uri.parse((String)hint).getPath();
        } else {
            base = storageManager.locateDestinationDirectory(mimeType, destination, contentLength);
            path = Helpers.chooseFilename(url, hint, contentDisposition, contentLocation);
        }
        storageManager.verifySpace(destination, path, contentLength);
        if (DownloadDrmHelper.isDrmConvertNeeded(mimeType)) {
            path = DownloadDrmHelper.modifyDrmFwLockFileExtension(path);
        }
        path = Helpers.getFullPath(path, mimeType, destination, base);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFullPath(String filename, String mimeType, int destination, File base) throws StopRequestException {
        boolean missingExtension;
        String extension = null;
        int dotIndex = filename.lastIndexOf(46);
        boolean bl = missingExtension = dotIndex < 0 || dotIndex < filename.lastIndexOf(47);
        if (destination == 4) {
            if (missingExtension) {
                extension = "";
            } else {
                extension = filename.substring(dotIndex);
                filename = filename.substring(0, dotIndex);
            }
        } else if (missingExtension) {
            extension = Helpers.chooseExtensionFromMimeType(mimeType, true);
        } else {
            extension = Helpers.chooseExtensionFromFilename(mimeType, filename, dotIndex);
            filename = filename.substring(0, dotIndex);
        }
        boolean recoveryDir = "recovery".equalsIgnoreCase(filename + extension);
        if (base != null) {
            filename = base.getPath() + File.separator + filename;
        }
        Log.v((Object[])new Object[]{"target file: " + filename + extension});
        Object object = UNIQUE_LOCK;
        synchronized (object) {
            String path = Helpers.chooseUniqueFilenameLocked(destination, filename, extension, recoveryDir);
            try {
                new File(path).createNewFile();
            }
            catch (IOException e) {
                throw new StopRequestException(492, "Failed to create target file " + path, e);
            }
            return path;
        }
    }

    private static String chooseFilename(String url, String hint, String contentDisposition, String contentLocation) {
        String decodedUrl;
        int index;
        String decodedContentLocation;
        int index2;
        String filename = null;
        if (hint != null && !hint.endsWith("/")) {
            Log.v((Object[])new Object[]{"getting filename from hint"});
            index2 = hint.lastIndexOf(47) + 1;
            filename = index2 > 0 ? hint.substring(index2) : hint;
        }
        if (filename == null && contentDisposition != null && (filename = Helpers.parseContentDisposition(contentDisposition)) != null) {
            Log.v((Object[])new Object[]{"getting filename from content-disposition"});
            index2 = filename.lastIndexOf(47) + 1;
            if (index2 > 0) {
                filename = filename.substring(index2);
            }
        }
        if (filename == null && contentLocation != null && (decodedContentLocation = Uri.decode((String)contentLocation)) != null && !decodedContentLocation.endsWith("/") && decodedContentLocation.indexOf(63) < 0) {
            Log.v((Object[])new Object[]{"getting filename from content-location"});
            index = decodedContentLocation.lastIndexOf(47) + 1;
            filename = index > 0 ? decodedContentLocation.substring(index) : decodedContentLocation;
        }
        if (filename == null && (decodedUrl = Uri.decode((String)url)) != null && !decodedUrl.endsWith("/") && decodedUrl.indexOf(63) < 0 && (index = decodedUrl.lastIndexOf(47) + 1) > 0) {
            Log.v((Object[])new Object[]{"getting filename from uri"});
            filename = decodedUrl.substring(index);
        }
        if (filename == null) {
            Log.v((Object[])new Object[]{"using default filename"});
            filename = "downloadfile";
        }
        filename = Helpers.replaceInvalidVfatCharacters(filename);
        return filename;
    }

    private static String chooseExtensionFromMimeType(String mimeType, boolean useDefaults) {
        String extension = null;
        if (mimeType != null) {
            extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (extension != null) {
                Log.v((Object[])new Object[]{"adding extension from type"});
                extension = "." + extension;
            } else {
                Log.v((Object[])new Object[]{"couldn't find extension for " + mimeType});
            }
        }
        if (extension == null) {
            if (mimeType != null && mimeType.toLowerCase(Locale.US).startsWith("text/")) {
                if (mimeType.equalsIgnoreCase("text/html")) {
                    Log.v((Object[])new Object[]{"adding default html extension"});
                    extension = ".html";
                } else if (useDefaults) {
                    Log.v((Object[])new Object[]{"adding default text extension"});
                    extension = ".txt";
                }
            } else if (useDefaults) {
                Log.v((Object[])new Object[]{"adding default binary extension"});
                extension = ".bin";
            }
        }
        return extension;
    }

    private static String chooseExtensionFromFilename(String mimeType, String filename, int lastDotIndex) {
        String typeFromExt;
        String extension = null;
        if (!(mimeType == null || (typeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(filename.substring(lastDotIndex + 1))) != null && typeFromExt.equalsIgnoreCase(mimeType))) {
            extension = Helpers.chooseExtensionFromMimeType(mimeType, false);
            if (extension != null) {
                Log.v((Object[])new Object[]{"substituting extension from type"});
            } else {
                Log.v((Object[])new Object[]{"couldn't find extension for " + mimeType});
            }
        }
        if (extension == null) {
            Log.v((Object[])new Object[]{"keeping extension"});
            extension = filename.substring(lastDotIndex);
        }
        return extension;
    }

    private static String chooseUniqueFilenameLocked(int destination, String filename, String extension, boolean recoveryDir) throws StopRequestException {
        String fullFilename = filename + extension;
        if (!new File(fullFilename).exists() && (!recoveryDir || destination != 1 && destination != 5 && destination != 2 && destination != 3)) {
            return fullFilename;
        }
        filename = filename + "-";
        int sequence = 1;
        for (int magnitude = 1; magnitude < 1000000000; magnitude *= 10) {
            for (int iteration = 0; iteration < 9; ++iteration) {
                fullFilename = filename + sequence + extension;
                if (!new File(fullFilename).exists()) {
                    return fullFilename;
                }
                Log.v((Object[])new Object[]{"file with sequence number " + sequence + " exists"});
                sequence += sRandom.nextInt(magnitude) + 1;
            }
        }
        throw new StopRequestException(492, "failed to generate an unused filename on internal download storage");
    }

    static boolean isFilenameValid(String filename, File downloadsDataDir) {
        return (filename = filename.replaceFirst("/+", "/")).startsWith(Environment.getDownloadCacheDirectory().toString()) || filename.startsWith(downloadsDataDir.toString()) || filename.startsWith(Environment.getExternalStorageDirectory().toString());
    }

    public static void validateSelection(String selection, Set<String> allowedColumns) {
        try {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Lexer lexer = new Lexer(selection, allowedColumns);
            Helpers.parseExpression(lexer);
            if (lexer.currentToken() != 9) {
                throw new IllegalArgumentException("syntax error");
            }
        }
        catch (RuntimeException ex) {
            Log.d((Object[])new Object[]{"invalid selection [" + selection + "] triggered " + ex});
        }
    }

    private static void parseExpression(Lexer lexer) {
        while (true) {
            if (lexer.currentToken() == 1) {
                lexer.advance();
                Helpers.parseExpression(lexer);
                if (lexer.currentToken() != 2) {
                    throw new IllegalArgumentException("syntax error, unmatched parenthese");
                }
                lexer.advance();
            } else {
                Helpers.parseStatement(lexer);
            }
            if (lexer.currentToken() != 3) break;
            lexer.advance();
        }
    }

    private static void parseStatement(Lexer lexer) {
        if (lexer.currentToken() != 4) {
            throw new IllegalArgumentException("syntax error, expected column name");
        }
        lexer.advance();
        if (lexer.currentToken() == 5) {
            lexer.advance();
            if (lexer.currentToken() != 6) {
                throw new IllegalArgumentException("syntax error, expected quoted string");
            }
            lexer.advance();
            return;
        }
        if (lexer.currentToken() == 7) {
            lexer.advance();
            if (lexer.currentToken() != 8) {
                throw new IllegalArgumentException("syntax error, expected NULL");
            }
            lexer.advance();
            return;
        }
        throw new IllegalArgumentException("syntax error after column name");
    }

    private static String replaceInvalidVfatCharacters(String filename) {
        boolean START_CTRLCODE = false;
        int END_CTRLCODE = 31;
        int QUOTEDBL = 34;
        int ASTERISK = 42;
        int SLASH = 47;
        int COLON = 58;
        int LESS = 60;
        int GREATER = 62;
        int QUESTION = 63;
        int BACKSLASH = 92;
        int BAR = 124;
        int DEL = 127;
        int UNDERSCORE = 95;
        StringBuffer sb = new StringBuffer();
        boolean isRepetition = false;
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if ('\u0000' <= ch && ch <= '\u001f' || ch == '\"' || ch == '*' || ch == '/' || ch == ':' || ch == '<' || ch == '>' || ch == '?' || ch == '\\' || ch == '|' || ch == '\u007f') {
                if (isRepetition) continue;
                sb.append('_');
                isRepetition = true;
                continue;
            }
            sb.append(ch);
            isRepetition = false;
        }
        return sb.toString();
    }

    private static class Lexer {
        public static final int TOKEN_START = 0;
        public static final int TOKEN_OPEN_PAREN = 1;
        public static final int TOKEN_CLOSE_PAREN = 2;
        public static final int TOKEN_AND_OR = 3;
        public static final int TOKEN_COLUMN = 4;
        public static final int TOKEN_COMPARE = 5;
        public static final int TOKEN_VALUE = 6;
        public static final int TOKEN_IS = 7;
        public static final int TOKEN_NULL = 8;
        public static final int TOKEN_END = 9;
        private final String selection;
        private final Set<String> allowedColumns;
        private final char[] chars;
        private int offset = 0;
        private int currentToken = 0;

        public Lexer(String selection, Set<String> allowedColumns) {
            this.selection = selection;
            this.allowedColumns = allowedColumns;
            this.chars = new char[this.selection.length()];
            this.selection.getChars(0, this.chars.length, this.chars, 0);
            this.advance();
        }

        public int currentToken() {
            return this.currentToken;
        }

        public void advance() {
            char[] chars = this.chars;
            while (this.offset < chars.length && chars[this.offset] == ' ') {
                ++this.offset;
            }
            if (this.offset == chars.length) {
                this.currentToken = 9;
                return;
            }
            if (chars[this.offset] == '(') {
                ++this.offset;
                this.currentToken = 1;
                return;
            }
            if (chars[this.offset] == ')') {
                ++this.offset;
                this.currentToken = 2;
                return;
            }
            if (chars[this.offset] == '?') {
                ++this.offset;
                this.currentToken = 6;
                return;
            }
            if (chars[this.offset] == '=') {
                ++this.offset;
                this.currentToken = 5;
                if (this.offset < chars.length && chars[this.offset] == '=') {
                    ++this.offset;
                }
                return;
            }
            if (chars[this.offset] == '>') {
                ++this.offset;
                this.currentToken = 5;
                if (this.offset < chars.length && chars[this.offset] == '=') {
                    ++this.offset;
                }
                return;
            }
            if (chars[this.offset] == '<') {
                ++this.offset;
                this.currentToken = 5;
                if (this.offset < chars.length && (chars[this.offset] == '=' || chars[this.offset] == '>')) {
                    ++this.offset;
                }
                return;
            }
            if (chars[this.offset] == '!') {
                ++this.offset;
                this.currentToken = 5;
                if (this.offset < chars.length && chars[this.offset] == '=') {
                    ++this.offset;
                    return;
                }
                throw new IllegalArgumentException("Unexpected character after !");
            }
            if (Lexer.isIdentifierStart(chars[this.offset])) {
                int startOffset = this.offset++;
                while (this.offset < chars.length && Lexer.isIdentifierChar(chars[this.offset])) {
                    ++this.offset;
                }
                String word = this.selection.substring(startOffset, this.offset);
                if (this.offset - startOffset <= 4) {
                    if (word.equals("IS")) {
                        this.currentToken = 7;
                        return;
                    }
                    if (word.equals("OR") || word.equals("AND")) {
                        this.currentToken = 3;
                        return;
                    }
                    if (word.equals("NULL")) {
                        this.currentToken = 8;
                        return;
                    }
                }
                if (this.allowedColumns.contains(word)) {
                    this.currentToken = 4;
                    return;
                }
                throw new IllegalArgumentException("unrecognized column or keyword");
            }
            if (chars[this.offset] == '\'') {
                ++this.offset;
                while (this.offset < chars.length) {
                    if (chars[this.offset] == '\'') {
                        if (this.offset + 1 >= chars.length || chars[this.offset + 1] != '\'') break;
                        ++this.offset;
                    }
                    ++this.offset;
                }
                if (this.offset == chars.length) {
                    throw new IllegalArgumentException("unterminated string");
                }
                ++this.offset;
                this.currentToken = 6;
                return;
            }
            throw new IllegalArgumentException("illegal character: " + chars[this.offset]);
        }

        private static boolean isIdentifierStart(char c) {
            return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private static boolean isIdentifierChar(char c) {
            return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }
    }
}

