/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.novoda.downloadmanager.lib.DownloadScanner;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.RandomNumberGenerator;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.notils.logger.simple.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class FileDownloadInfo {
    private static final String TAR_MIME_TYPE = "application/x-tar";
    private long id;
    private String uri;
    private boolean scannable;
    private boolean noIntegrity;
    private String hint;
    private String fileName;
    private String mimeType;
    private int destination;
    private int control;
    private int status;
    private int numFailed;
    private int retryAfter;
    private long lastMod;
    private String notificationClassName;
    private String extras;
    private String cookies;
    private String userAgent;
    private String referer;
    private long totalBytes;
    private long currentBytes;
    private String eTag;
    private int uid;
    private int mediaScanned;
    private boolean deleted;
    private String mediaProviderUri;
    private int allowedNetworkTypes;
    private boolean allowRoaming;
    private boolean allowMetered;
    private int bypassRecommendedSizeLimit;
    private long batchId;
    private boolean alwaysResume;
    private boolean allowTarUpdates;
    private final List<Pair<String, String>> requestHeaders = new ArrayList<Pair<String, String>>();
    private final SystemFacade systemFacade;
    private final RandomNumberGenerator randomNumberGenerator;
    private final DownloadsUriProvider downloadsUriProvider;

    FileDownloadInfo(SystemFacade systemFacade, RandomNumberGenerator randomNumberGenerator, DownloadsUriProvider downloadsUriProvider) {
        this.systemFacade = systemFacade;
        this.randomNumberGenerator = randomNumberGenerator;
        this.downloadsUriProvider = downloadsUriProvider;
    }

    public long getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isNoIntegrity() {
        return this.noIntegrity;
    }

    public String getHint() {
        return this.hint;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getDestination() {
        return this.destination;
    }

    public int getControl() {
        return this.control;
    }

    public int getStatus() {
        return this.status;
    }

    public int getNumFailed() {
        return this.numFailed;
    }

    public String getNotificationClassName() {
        return this.notificationClassName;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCurrentBytes() {
        return this.currentBytes;
    }

    public String getETag() {
        return this.eTag;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getMediaProviderUri() {
        return this.mediaProviderUri;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public boolean allowMetered() {
        return this.allowMetered;
    }

    public boolean allowRoaming() {
        return this.allowRoaming;
    }

    public boolean isRecommendedSizeLimitBypassed() {
        return this.bypassRecommendedSizeLimit == 0;
    }

    public String getExtras() {
        return this.extras;
    }

    public Collection<Pair<String, String>> getHeaders() {
        return Collections.unmodifiableList(this.requestHeaders);
    }

    public long restartTime(long now) {
        if (this.numFailed == 0) {
            return now;
        }
        if (this.retryAfter > 0) {
            return this.lastMod + (long)this.retryAfter;
        }
        return this.lastMod + (long)(30 * (1000 + this.randomNumberGenerator.generate()) * (1 << this.numFailed - 1));
    }

    private int translateNetworkTypeToApiFlag(int networkType) {
        switch (networkType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 7: {
                return 4;
            }
        }
        return 0;
    }

    private NetworkState checkSizeAllowedForNetwork(int networkType) {
        Long recommendedMaxBytesOverMobile;
        if (this.totalBytes <= 0L) {
            return NetworkState.OK;
        }
        if (networkType == 1) {
            return NetworkState.OK;
        }
        Long maxBytesOverMobile = this.systemFacade.getMaxBytesOverMobile();
        if (maxBytesOverMobile != null && this.totalBytes > maxBytesOverMobile) {
            return NetworkState.UNUSABLE_DUE_TO_SIZE;
        }
        if (this.bypassRecommendedSizeLimit == 0 && (recommendedMaxBytesOverMobile = this.systemFacade.getRecommendedMaxBytesOverMobile()) != null && this.totalBytes > recommendedMaxBytesOverMobile) {
            return NetworkState.RECOMMENDED_UNUSABLE_DUE_TO_SIZE;
        }
        return NetworkState.OK;
    }

    public boolean isSubmittedOrRunning() {
        return DownloadStatus.isSubmitted(this.status) || DownloadStatus.isRunning(this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startScanIfReady(DownloadScanner scanner) {
        FileDownloadInfo fileDownloadInfo = this;
        synchronized (fileDownloadInfo) {
            boolean isReady = this.shouldScanFile();
            if (isReady) {
                scanner.requestScan(this);
            }
            return isReady;
        }
    }

    public boolean isOnCache() {
        return this.destination == 1 || this.destination == 5 || this.destination == 3 || this.destination == 2;
    }

    public Uri getMyDownloadsUri() {
        return ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getContentUri(), (long)this.id);
    }

    public Uri getAllDownloadsUri() {
        return ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)this.id);
    }

    private boolean shouldScanFile() {
        return this.mediaScanned == 0 && (this.getDestination() == 0 || this.getDestination() == 4 || this.getDestination() == 6) && DownloadStatus.isSuccess(this.getStatus()) && this.scannable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queryDownloadStatus(ContentResolver resolver, long id, DownloadsUriProvider downloadsUriProvider) {
        try (Cursor cursor = resolver.query(ContentUris.withAppendedId((Uri)downloadsUriProvider.getAllDownloadsUri(), (long)id), new String[]{"status"}, null, null, null);){
            if (cursor.moveToFirst()) {
                int n = cursor.getInt(0);
                return n;
            }
            int n = 190;
            return n;
        }
    }

    public boolean hasTotalBytes() {
        return this.totalBytes != -1L;
    }

    public boolean hasUnknownTotalBytes() {
        return !this.hasTotalBytes();
    }

    private void addHeader(String header, String value) {
        this.requestHeaders.add((Pair<String, String>)Pair.create((Object)header, (Object)value));
    }

    private void clearHeaders() {
        this.requestHeaders.clear();
    }

    public boolean isResumable() {
        return this.alwaysResume || this.eTag != null && this.isNoIntegrity();
    }

    public boolean shouldAllowTarUpdate(String mimeType) {
        if (!this.allowTarUpdates) {
            return false;
        }
        if (TAR_MIME_TYPE.equals(mimeType)) {
            return true;
        }
        Log.e((Object[])new Object[]{"Flag allowTarUpdates set but file not matching Tar mimeType, functionality will be disabled."});
        return false;
    }

    static final class ControlStatus {
        private int control;
        private int status;

        public ControlStatus(int control, int status) {
            this.control = control;
            this.status = status;
        }

        public boolean isPaused() {
            return this.control == 1;
        }

        public boolean isCanceled() {
            return this.status == 490;
        }

        static final class Reader {
            private final ContentResolver contentResolver;
            private final DownloadsUriProvider downloadsUriProvider;

            public Reader(ContentResolver contentResolver, DownloadsUriProvider downloadsUriProvider) {
                this.contentResolver = contentResolver;
                this.downloadsUriProvider = downloadsUriProvider;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ControlStatus newControlStatus(long id) {
                String[] projection = new String[]{"control", "status"};
                Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)id);
                try (Cursor downloadsCursor = this.contentResolver.query(uri, projection, null, null, null);){
                    downloadsCursor.moveToFirst();
                    int control = downloadsCursor.getInt(0);
                    int status = downloadsCursor.getInt(1);
                    ControlStatus controlStatus = new ControlStatus(control, status);
                    return controlStatus;
                }
            }
        }
    }

    public static class Reader {
        private final ContentResolver resolver;
        private final Cursor cursor;

        public Reader(ContentResolver resolver, Cursor cursor) {
            this.resolver = resolver;
            this.cursor = cursor;
        }

        public FileDownloadInfo newDownloadInfo(SystemFacade systemFacade, DownloadsUriProvider downloadsUriProvider) {
            RandomNumberGenerator randomNumberGenerator = new RandomNumberGenerator();
            FileDownloadInfo info = new FileDownloadInfo(systemFacade, randomNumberGenerator, downloadsUriProvider);
            this.updateFromDatabase(info);
            this.readRequestHeaders(info);
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateFromDatabase(FileDownloadInfo info) {
            info.id = this.getLong("_id");
            info.uri = this.getString("uri");
            info.scannable = this.getInt("scanned") == 1;
            info.noIntegrity = this.getInt("no_integrity") == 1;
            info.hint = this.getString("hint");
            info.fileName = this.getString("_data");
            info.mimeType = this.getString("mimetype");
            info.destination = this.getInt("destination");
            info.status = this.getInt("status");
            info.numFailed = this.getInt("numfailed");
            int retryRedirect = this.getInt("method");
            info.retryAfter = retryRedirect & 0xFFFFFFF;
            info.lastMod = this.getLong("last_modified_timestamp");
            info.notificationClassName = this.getString("notificationclass");
            info.extras = this.getString("notificationextras");
            info.cookies = this.getString("cookiedata");
            info.userAgent = this.getString("useragent");
            info.referer = this.getString("referer");
            info.totalBytes = this.getLong("total_bytes");
            info.currentBytes = this.getLong("current_bytes");
            info.eTag = this.getString("etag");
            info.uid = this.getInt("uid");
            info.mediaScanned = this.getInt("scanned");
            info.deleted = this.getInt("deleted") == 1;
            info.mediaProviderUri = this.getString("mediaprovider_uri");
            info.allowedNetworkTypes = this.getInt("allowed_network_types");
            info.allowRoaming = this.getInt("allow_roaming") != 0;
            info.allowMetered = this.getInt("allow_metered") != 0;
            info.bypassRecommendedSizeLimit = this.getInt("bypass_recommended_size_limit");
            info.batchId = this.getLong("batch_id");
            info.alwaysResume = this.getInt("always_resume") != 0;
            info.allowTarUpdates = this.getInt("allow_tar_updates") != 0;
            Reader reader = this;
            synchronized (reader) {
                info.control = this.getInt("control");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readRequestHeaders(FileDownloadInfo info) {
            info.clearHeaders();
            Uri headerUri = Uri.withAppendedPath((Uri)info.getAllDownloadsUri(), (String)"headers");
            try (Cursor cursor = this.resolver.query(headerUri, null, null, null, null);){
                int headerIndex = cursor.getColumnIndexOrThrow("header");
                int valueIndex = cursor.getColumnIndexOrThrow("value");
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    info.addHeader(cursor.getString(headerIndex), cursor.getString(valueIndex));
                    cursor.moveToNext();
                }
            }
            if (info.cookies != null) {
                info.addHeader("Cookie", info.cookies);
            }
            if (info.referer != null) {
                info.addHeader("Referer", info.referer);
            }
        }

        private String getString(String column) {
            int index = this.cursor.getColumnIndexOrThrow(column);
            String s = this.cursor.getString(index);
            return TextUtils.isEmpty((CharSequence)s) ? null : s;
        }

        private Integer getInt(String column) {
            return this.cursor.getInt(this.cursor.getColumnIndexOrThrow(column));
        }

        private Long getLong(String column) {
            return this.cursor.getLong(this.cursor.getColumnIndexOrThrow(column));
        }
    }

    public static enum NetworkState {
        OK,
        NO_CONNECTION,
        UNUSABLE_DUE_TO_SIZE,
        RECOMMENDED_UNUSABLE_DUE_TO_SIZE,
        CANNOT_USE_ROAMING,
        TYPE_DISALLOWED_BY_REQUESTOR,
        BLOCKED;

    }
}

