/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.net.Uri;
import com.novoda.downloadmanager.lib.DownloadProvider;

class DownloadsUriProvider {
    private final Uri publiclyAccessibleDownloadsUri;
    private final Uri downloadsByBatchUri;
    private final Uri allDownloadsUri;
    private final Uri batchesUri;
    private final Uri contentUri;
    private final Uri downloadsWithoutProgressUri;
    private final Uri batchesWithoutProgressUri;

    public static DownloadsUriProvider getInstance() {
        return LazyInitialisationHelper.INSTANCE;
    }

    private static DownloadsUriProvider newInstance() {
        String authority = "content://" + DownloadProvider.AUTHORITY;
        Uri publiclyAccessibleDownloadsUri = Uri.parse((String)(authority + "/" + "public_downloads"));
        Uri downloadsByBatchUri = Uri.parse((String)(authority + "/downloads_by_batch"));
        Uri allDownloadsUri = Uri.parse((String)(authority + "/all_downloads"));
        Uri batchesUri = Uri.parse((String)(authority + "/batches"));
        Uri contentUri = Uri.parse((String)(authority + "/my_downloads"));
        Uri downloadsByStatusUri = Uri.parse((String)(authority + "/downloads_without_progress"));
        Uri batchesByStatusUri = Uri.parse((String)(authority + "/batches_without_progress"));
        return new DownloadsUriProvider(publiclyAccessibleDownloadsUri, downloadsByBatchUri, allDownloadsUri, batchesUri, contentUri, downloadsByStatusUri, batchesByStatusUri);
    }

    DownloadsUriProvider(Uri publiclyAccessibleDownloadsUri, Uri downloadsByBatchUri, Uri allDownloadsUri, Uri batchesUri, Uri contentUri, Uri downloadsWithoutProgressUri, Uri batchesWithoutProgressUri) {
        this.publiclyAccessibleDownloadsUri = publiclyAccessibleDownloadsUri;
        this.downloadsByBatchUri = downloadsByBatchUri;
        this.allDownloadsUri = allDownloadsUri;
        this.batchesUri = batchesUri;
        this.contentUri = contentUri;
        this.downloadsWithoutProgressUri = downloadsWithoutProgressUri;
        this.batchesWithoutProgressUri = batchesWithoutProgressUri;
    }

    public Uri getPubliclyAccessibleDownloadsUri() {
        return this.publiclyAccessibleDownloadsUri;
    }

    public Uri getDownloadsByBatchUri() {
        return this.downloadsByBatchUri;
    }

    public Uri getAllDownloadsUri() {
        return this.allDownloadsUri;
    }

    public Uri getBatchesUri() {
        return this.batchesUri;
    }

    public Uri getContentUri() {
        return this.contentUri;
    }

    public Uri getDownloadsWithoutProgressUri() {
        return this.downloadsWithoutProgressUri;
    }

    public Uri getBatchesWithoutProgressUri() {
        return this.batchesWithoutProgressUri;
    }

    static /* synthetic */ DownloadsUriProvider access$100() {
        return DownloadsUriProvider.newInstance();
    }

    private static class LazyInitialisationHelper {
        private static final DownloadsUriProvider INSTANCE = DownloadsUriProvider.access$100();

        private LazyInitialisationHelper() {
        }
    }
}

