/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.database.Cursor;
import android.net.Uri;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import java.util.ArrayList;
import java.util.List;

class DownloadsRepository {
    private final ContentResolver contentResolver;
    private final DownloadInfoCreator downloadInfoCreator;
    private final DownloadsUriProvider downloadsUriProvider;

    public DownloadsRepository(ContentResolver contentResolver, DownloadInfoCreator downloadInfoCreator, DownloadsUriProvider downloadsUriProvider) {
        this.contentResolver = contentResolver;
        this.downloadInfoCreator = downloadInfoCreator;
        this.downloadsUriProvider = downloadsUriProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileDownloadInfo> getAllDownloads() {
        try (Cursor downloadsCursor = this.contentResolver.query(this.downloadsUriProvider.getAllDownloadsUri(), null, null, null, "_id ASC");){
            ArrayList<FileDownloadInfo> downloads = new ArrayList<FileDownloadInfo>();
            FileDownloadInfo.Reader reader = new FileDownloadInfo.Reader(this.contentResolver, downloadsCursor);
            while (downloadsCursor.moveToNext()) {
                downloads.add(this.downloadInfoCreator.create(reader));
            }
            ArrayList<FileDownloadInfo> arrayList = downloads;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDownloadInfo getDownloadFor(long id) {
        Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)id);
        try (Cursor downloadsCursor = this.contentResolver.query(uri, null, null, null, null);){
            downloadsCursor.moveToFirst();
            FileDownloadInfo.Reader reader = new FileDownloadInfo.Reader(this.contentResolver, downloadsCursor);
            FileDownloadInfo fileDownloadInfo = this.downloadInfoCreator.create(reader);
            return fileDownloadInfo;
        }
    }

    public FileDownloadInfo.ControlStatus getDownloadInfoControlStatusFor(long id) {
        FileDownloadInfo.ControlStatus.Reader reader = new FileDownloadInfo.ControlStatus.Reader(this.contentResolver, this.downloadsUriProvider);
        return this.downloadInfoCreator.create(reader, id);
    }

    static interface DownloadInfoCreator {
        public FileDownloadInfo create(FileDownloadInfo.Reader var1);

        public FileDownloadInfo.ControlStatus create(FileDownloadInfo.ControlStatus.Reader var1, long var2);
    }
}

