/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.TrafficStats;
import android.os.PowerManager;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Pair;
import com.novoda.downloadmanager.lib.BatchCompletionBroadcaster;
import com.novoda.downloadmanager.lib.BatchRepository;
import com.novoda.downloadmanager.lib.DownloadDrmHelper;
import com.novoda.downloadmanager.lib.DownloadNotifier;
import com.novoda.downloadmanager.lib.DownloadReadyChecker;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.DownloadsRepository;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.downloadmanager.lib.Helpers;
import com.novoda.downloadmanager.lib.IOHelpers;
import com.novoda.downloadmanager.lib.NetworkChecker;
import com.novoda.downloadmanager.lib.SizeLimitActivity;
import com.novoda.downloadmanager.lib.StopRequestException;
import com.novoda.downloadmanager.lib.StorageManager;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.downloadmanager.lib.TarFileTruncator;
import com.novoda.notils.logger.simple.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;

class DownloadThread
implements Runnable {
    public static final String EXTRA_IS_WIFI_REQUIRED = "isWifiRequired";
    private static final String TAG = "DownloadManager-DownloadThread";
    private static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int DEFAULT_TIMEOUT = 20000;
    private final Context context;
    private final FileDownloadInfo originalDownloadInfo;
    private final SystemFacade systemFacade;
    private final StorageManager storageManager;
    private final DownloadNotifier downloadNotifier;
    private final BatchCompletionBroadcaster batchCompletionBroadcaster;
    private final BatchRepository batchRepository;
    private final DownloadsUriProvider downloadsUriProvider;
    private final DownloadsRepository downloadsRepository;
    private final NetworkChecker networkChecker;
    private final DownloadReadyChecker downloadReadyChecker;
    private final TarFileTruncator tarFileTruncator;
    private volatile boolean policyDirty;

    public DownloadThread(Context context, SystemFacade systemFacade, FileDownloadInfo originalDownloadInfo, StorageManager storageManager, DownloadNotifier downloadNotifier, BatchCompletionBroadcaster batchCompletionBroadcaster, BatchRepository batchRepository, DownloadsUriProvider downloadsUriProvider, DownloadsRepository downloadsRepository, NetworkChecker networkChecker, DownloadReadyChecker downloadReadyChecker, TarFileTruncator tarFileTruncator) {
        this.context = context;
        this.systemFacade = systemFacade;
        this.originalDownloadInfo = originalDownloadInfo;
        this.storageManager = storageManager;
        this.downloadNotifier = downloadNotifier;
        this.batchCompletionBroadcaster = batchCompletionBroadcaster;
        this.batchRepository = batchRepository;
        this.downloadsUriProvider = downloadsUriProvider;
        this.downloadsRepository = downloadsRepository;
        this.networkChecker = networkChecker;
        this.downloadReadyChecker = downloadReadyChecker;
        this.tarFileTruncator = tarFileTruncator;
    }

    private String userAgent() {
        String userAgent = this.originalDownloadInfo.getUserAgent();
        if (userAgent == null) {
            userAgent = "AndroidDownloadManager";
        }
        return userAgent;
    }

    private static String normalizeMimeType(String type) {
        if (type == null) {
            return null;
        }
        int semicolonIndex = (type = type.trim().toLowerCase(Locale.ROOT)).indexOf(59);
        if (semicolonIndex != -1) {
            type = type.substring(0, semicolonIndex);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        try {
            this.runInternal();
        }
        finally {
            this.downloadNotifier.notifyDownloadSpeed(this.originalDownloadInfo.getId(), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runInternal() {
        downloadStatus = FileDownloadInfo.queryDownloadStatus(this.getContentResolver(), this.originalDownloadInfo.getId(), this.downloadsUriProvider);
        if (downloadStatus == 200) {
            Log.d((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " already finished; skipping"});
            return;
        }
        if (DownloadStatus.isCancelled(downloadStatus)) {
            Log.d((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " already cancelled; skipping"});
            return;
        }
        if (DownloadStatus.isError(downloadStatus)) {
            Log.d((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " already failed: status = " + downloadStatus + "; skipping"});
            return;
        }
        if (DownloadStatus.isDeleting(downloadStatus)) {
            Log.d((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " is deleting: status = " + downloadStatus + "; skipping"});
            return;
        }
        currentBatch = this.batchRepository.retrieveBatchFor(this.originalDownloadInfo);
        if (!this.downloadReadyChecker.canDownload(currentBatch)) {
            Log.d((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " is not ready to download: skipping"});
            return;
        }
        if (downloadStatus != 192) {
            contentValues = new ContentValues();
            contentValues.put("status", Integer.valueOf(192));
            this.context.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), contentValues, null, null);
            this.updateBatchStatus(this.originalDownloadInfo.getBatchId(), this.originalDownloadInfo.getId());
        }
        state = new State(this.originalDownloadInfo);
        wakeLock = null;
        finalStatus = 491;
        numFailed = this.originalDownloadInfo.getNumFailed();
        errorMsg = null;
        powerManager = (PowerManager)this.context.getSystemService("power");
        try {
            wakeLock = powerManager.newWakeLock(1, "DownloadManager-DownloadThread");
            wakeLock.acquire();
            Log.i((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " starting"});
            networkInfo = this.systemFacade.getActiveNetworkInfo();
            if (networkInfo != null) {
                state.networkType = networkInfo.getType();
            }
            TrafficStats.setThreadStatsTag((int)-255);
            try {
                state.url = new URL(state.requestUri);
            }
            catch (MalformedURLException e) {
                throw new StopRequestException(400, (Throwable)e);
            }
            this.executeDownload(state);
            this.finalizeDestinationFile(state);
            finalStatus = 200;
        }
        catch (StopRequestException error) {
            block20: {
                errorMsg = error.getMessage();
                msg = "Aborting request for download " + this.originalDownloadInfo.getId() + ": " + errorMsg;
                Log.w((String)msg, (Throwable)error);
                finalStatus = error.getFinalStatus();
                if (finalStatus == 194) {
                    throw new IllegalStateException("Execution should always throw final error codes");
                }
                if (!DownloadThread.isStatusRetryable(finalStatus)) break block20;
                numFailed = state.gotData ? 1 : ++numFailed;
                if (numFailed >= 5) break block20;
                info = this.systemFacade.getActiveNetworkInfo();
                finalStatus = info != null && info.getType() == state.networkType && info.isConnected() != false ? 194 : 195;
            }
            TrafficStats.clearThreadStatsTag();
            this.cleanupDestination(state, finalStatus);
            this.notifyDownloadCompleted(state, finalStatus, errorMsg, numFailed);
            Log.i((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " finished with status " + DownloadStatus.statusToString(finalStatus)});
            if (wakeLock != null) {
                wakeLock.release();
            }
        }
        catch (Throwable ex) {
            errorMsg = ex.getMessage();
            msg = "Exception for id " + this.originalDownloadInfo.getId() + ": " + errorMsg;
            Log.w((String)msg, (Throwable)ex);
            finalStatus = 491;
            {
                catch (Throwable var12_16) {
                    TrafficStats.clearThreadStatsTag();
                    this.cleanupDestination(state, finalStatus);
                    this.notifyDownloadCompleted(state, finalStatus, errorMsg, numFailed);
                    Log.i((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " finished with status " + DownloadStatus.statusToString(finalStatus)});
                    if (wakeLock != null) {
                        wakeLock.release();
                    }
                    throw var12_16;
                }
            }
            TrafficStats.clearThreadStatsTag();
            this.cleanupDestination(state, finalStatus);
            this.notifyDownloadCompleted(state, finalStatus, errorMsg, numFailed);
            Log.i((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " finished with status " + DownloadStatus.statusToString(finalStatus)});
            if (wakeLock != null) {
                wakeLock.release();
            } else {
                ** GOTO lbl95
            }
        }
        TrafficStats.clearThreadStatsTag();
        this.cleanupDestination(state, finalStatus);
        this.notifyDownloadCompleted(state, finalStatus, errorMsg, numFailed);
        Log.i((Object[])new Object[]{"Download " + this.originalDownloadInfo.getId() + " finished with status " + DownloadStatus.statusToString(finalStatus)});
        if (wakeLock != null) {
            wakeLock.release();
        }
        this.storageManager.incrementNumDownloadsSoFar();
    }

    private void executeDownload(State state) throws StopRequestException {
        state.resetBeforeExecute();
        this.setupDestinationFile(state);
        if (this.originalDownloadInfo.shouldAllowTarUpdate(state.mimeType)) {
            state.totalBytes = -1L;
        }
        if (state.currentBytes == state.totalBytes) {
            Log.i((Object[])new Object[]{"Skipping initiating request for download " + this.originalDownloadInfo.getId() + "; already completed"});
            return;
        }
        block17: while (state.redirectionCount++ < 5) {
            HttpURLConnection conn = null;
            try {
                this.checkConnectivity();
                conn = (HttpURLConnection)state.url.openConnection();
                conn.setInstanceFollowRedirects(false);
                conn.setConnectTimeout(20000);
                conn.setReadTimeout(20000);
                this.addRequestHeaders(state, conn);
                int responseCode = conn.getResponseCode();
                switch (responseCode) {
                    case 200: {
                        if (state.continuingDownload) {
                            throw new StopRequestException(489, "Expected partial, but received OK");
                        }
                        this.processResponseHeaders(state, conn);
                        this.transferData(state, conn);
                        return;
                    }
                    case 206: {
                        if (!state.continuingDownload) {
                            throw new StopRequestException(489, "Expected OK, but received partial");
                        }
                        this.transferData(state, conn);
                        return;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String location = conn.getHeaderField("Location");
                        state.url = new URL(state.url, location);
                        if (responseCode != 301) continue block17;
                        state.requestUri = state.url.toString();
                        continue block17;
                    }
                    case 416: {
                        throw new StopRequestException(489, "Requested range not satisfiable");
                    }
                    case 503: {
                        this.parseRetryAfterHeaders(state, conn);
                        throw new StopRequestException(503, conn.getResponseMessage());
                    }
                    case 500: {
                        throw new StopRequestException(500, conn.getResponseMessage());
                    }
                }
                StopRequestException.throwUnhandledHttpError(responseCode, conn.getResponseMessage());
            }
            catch (UnknownHostException e) {
                throw new StopRequestException(404, (Throwable)e);
            }
            catch (IOException e) {
                throw new StopRequestException(495, (Throwable)e);
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
        throw new StopRequestException(497, "Too many redirects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferData(State state, HttpURLConnection conn) throws StopRequestException {
        Object drmClient = null;
        InputStream in = null;
        FileOutputStream out = null;
        FileDescriptor outFd = null;
        try {
            try {
                in = conn.getInputStream();
            }
            catch (IOException e) {
                throw new StopRequestException(495, (Throwable)e);
            }
            try {
                if (DownloadDrmHelper.isDrmConvertNeeded(state.mimeType)) {
                    throw new IllegalStateException("DRM not supported atm");
                }
                out = new FileOutputStream(state.filename, true);
                outFd = out.getFD();
            }
            catch (IOException e) {
                throw new StopRequestException(492, (Throwable)e);
            }
            this.transferData(state, in, out, outFd);
        }
        catch (Throwable throwable) {
            DownloadThread.closeQuietly(in);
            IOHelpers.closeAfterWrite(out, outFd);
            throw throwable;
        }
        DownloadThread.closeQuietly(in);
        IOHelpers.closeAfterWrite(out, outFd);
    }

    private void checkConnectivity() throws StopRequestException {
        this.policyDirty = false;
        FileDownloadInfo.NetworkState networkUsable = this.networkChecker.checkCanUseNetwork(this.originalDownloadInfo);
        if (networkUsable != FileDownloadInfo.NetworkState.OK) {
            int status = 195;
            if (networkUsable == FileDownloadInfo.NetworkState.UNUSABLE_DUE_TO_SIZE) {
                status = 196;
                this.notifyPauseDueToSize(true);
            } else if (networkUsable == FileDownloadInfo.NetworkState.RECOMMENDED_UNUSABLE_DUE_TO_SIZE) {
                status = 196;
                this.notifyPauseDueToSize(false);
            }
            throw new StopRequestException(status, networkUsable.name());
        }
    }

    void notifyPauseDueToSize(boolean isWifiRequired) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(this.originalDownloadInfo.getAllDownloadsUri());
        intent.setClassName(SizeLimitActivity.class.getPackage().getName(), SizeLimitActivity.class.getName());
        intent.setFlags(0x10000000);
        intent.putExtra(EXTRA_IS_WIFI_REQUIRED, isWifiRequired);
        this.context.startActivity(intent);
    }

    private void transferData(State state, InputStream in, OutputStream out, FileDescriptor outFd) throws StopRequestException {
        byte[] data = new byte[4096];
        while (true) {
            int bytesRead;
            if ((bytesRead = this.readFromResponse(state, data, in)) == -1) {
                this.handleEndOfStream(state, out, outFd);
                return;
            }
            state.gotData = true;
            this.writeDataToDestination(state, data, bytesRead, out);
            state.currentBytes += (long)bytesRead;
            this.reportProgress(state);
            this.checkPausedOrCanceled();
        }
    }

    private void finalizeDestinationFile(State state) {
        if (state.filename != null) {
            this.setPermissions(state.filename, 420, -1, -1);
        }
    }

    private void cleanupDestination(State state, int finalStatus) {
        if (state.filename != null && DownloadStatus.isError(finalStatus)) {
            Log.d((Object[])new Object[]{"cleanupDestination() deleting " + state.filename});
            boolean deleted = new File(state.filename).delete();
            if (!deleted) {
                Log.e((Object[])new Object[]{"File not deleted"});
            }
            state.filename = null;
        }
    }

    private void checkPausedOrCanceled() throws StopRequestException {
        FileDownloadInfo.ControlStatus controlStatus = this.downloadsRepository.getDownloadInfoControlStatusFor(this.originalDownloadInfo.getId());
        if (controlStatus.isPaused()) {
            throw new StopRequestException(193, "download paused by owner");
        }
        if (controlStatus.isCanceled()) {
            throw new StopRequestException(490, "download canceled");
        }
        if (this.policyDirty) {
            this.checkConnectivity();
        }
    }

    private void reportProgress(State state) {
        long now = SystemClock.elapsedRealtime();
        long sampleDelta = now - state.speedSampleStart;
        if (sampleDelta > 500L) {
            long sampleSpeed = (state.currentBytes - state.speedSampleBytes) * 1000L / sampleDelta;
            state.speed = state.speed == 0L ? sampleSpeed : (state.speed * 3L + sampleSpeed) / 4L;
            if (state.speedSampleStart != 0L) {
                this.downloadNotifier.notifyDownloadSpeed(this.originalDownloadInfo.getId(), state.speed);
            }
            state.speedSampleStart = now;
            state.speedSampleBytes = state.currentBytes;
        }
        if (state.currentBytes - state.bytesNotified > 4096L && now - state.timeLastNotification > 1500L) {
            ContentValues values = new ContentValues();
            values.put("current_bytes", Long.valueOf(state.currentBytes));
            this.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), values, null, null);
            state.bytesNotified = state.currentBytes;
            state.timeLastNotification = now;
        }
    }

    private void writeDataToDestination(State state, byte[] data, int bytesRead, OutputStream out) throws StopRequestException {
        this.storageManager.verifySpaceBeforeWritingToFile(this.originalDownloadInfo.getDestination(), state.filename, bytesRead);
        boolean forceVerified = false;
        while (true) {
            try {
                out.write(data, 0, bytesRead);
                return;
            }
            catch (IOException ex) {
                if (!forceVerified) {
                    this.storageManager.verifySpace(this.originalDownloadInfo.getDestination(), state.filename, bytesRead);
                    forceVerified = true;
                    continue;
                }
                throw new StopRequestException(492, "Failed to write data: " + ex);
            }
            break;
        }
    }

    private void handleEndOfStream(State state, OutputStream out, FileDescriptor outFd) throws StopRequestException {
        boolean lengthMismatched;
        if (this.originalDownloadInfo.shouldAllowTarUpdate(state.mimeType)) {
            IOHelpers.closeAfterWrite(out, outFd);
            state.currentBytes = this.tarFileTruncator.truncateIfNeeded(state.filename);
            this.updateStatusAndPause(state);
            return;
        }
        ContentValues values = new ContentValues(2);
        values.put("current_bytes", Long.valueOf(state.currentBytes));
        if (state.contentLength == -1L) {
            values.put("total_bytes", Long.valueOf(state.currentBytes));
        }
        this.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), values, null, null);
        boolean bl = lengthMismatched = state.contentLength != -1L && state.currentBytes != state.contentLength;
        if (lengthMismatched) {
            if (this.cannotResume(state)) {
                throw new StopRequestException(489, "mismatched content length; unable to resume");
            }
            throw new StopRequestException(495, "closed socket before end of file");
        }
    }

    private void updateStatusAndPause(State state) throws StopRequestException {
        ContentValues values = new ContentValues();
        values.put("status", Integer.valueOf(193));
        values.put("current_bytes", Long.valueOf(state.currentBytes));
        values.put("total_bytes", Long.valueOf(state.currentBytes));
        this.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), values, null, null);
        throw new StopRequestException(193, "download paused by owner");
    }

    private boolean cannotResume(State state) {
        return state.currentBytes > 0L && !this.originalDownloadInfo.isResumable() || DownloadDrmHelper.isDrmConvertNeeded(state.mimeType);
    }

    private int readFromResponse(State state, byte[] data, InputStream entityStream) throws StopRequestException {
        try {
            return entityStream.read(data);
        }
        catch (IOException ex) {
            if ("unexpected end of stream".equals(ex.getMessage())) {
                return -1;
            }
            ContentValues values = new ContentValues(1);
            values.put("current_bytes", Long.valueOf(state.currentBytes));
            this.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), values, null, null);
            if (this.cannotResume(state)) {
                throw new StopRequestException(489, "Failed reading response: " + ex + "; unable to resume", ex);
            }
            throw new StopRequestException(495, "Failed reading response: " + ex, ex);
        }
    }

    private void processResponseHeaders(State state, HttpURLConnection conn) throws StopRequestException {
        this.readResponseHeaders(state, conn);
        state.filename = Helpers.generateSaveFile(this.originalDownloadInfo.getUri(), this.originalDownloadInfo.getHint(), state.contentDisposition, state.contentLocation, state.mimeType, this.originalDownloadInfo.getDestination(), state.contentLength, this.storageManager);
        this.updateDatabaseFromHeaders(state);
        this.checkConnectivity();
    }

    private void updateDatabaseFromHeaders(State state) {
        ContentValues values = new ContentValues(4);
        values.put("_data", state.filename);
        if (state.headerETag != null) {
            values.put("etag", state.headerETag);
        }
        if (state.mimeType != null) {
            values.put("mimetype", state.mimeType);
        }
        values.put("total_bytes", Long.valueOf(state.totalBytes));
        this.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), values, null, null);
    }

    private void readResponseHeaders(State state, HttpURLConnection conn) throws StopRequestException {
        boolean noSizeInfo;
        state.contentDisposition = conn.getHeaderField("Content-Disposition");
        state.contentLocation = conn.getHeaderField("Content-Location");
        if (state.mimeType == null) {
            state.mimeType = DownloadThread.normalizeMimeType(conn.getContentType());
        }
        state.headerETag = conn.getHeaderField("ETag");
        String transferEncoding = conn.getHeaderField("Transfer-Encoding");
        if (transferEncoding == null) {
            state.contentLength = DownloadThread.getHeaderFieldLong(conn, "Content-Length", -1L);
        } else {
            Log.i((Object[])new Object[]{"Ignoring Content-Length since Transfer-Encoding is also defined"});
            state.contentLength = -1L;
        }
        state.totalBytes = state.contentLength;
        boolean bl = noSizeInfo = state.contentLength == -1L && (transferEncoding == null || !transferEncoding.equalsIgnoreCase("chunked"));
        if (!this.originalDownloadInfo.isNoIntegrity() && noSizeInfo) {
            throw new StopRequestException(489, "can't know size of download, giving up");
        }
    }

    private void parseRetryAfterHeaders(State state, HttpURLConnection conn) {
        state.retryAfter = conn.getHeaderFieldInt("Retry-After", -1);
        if (state.retryAfter < 0) {
            state.retryAfter = 0;
        } else {
            if (state.retryAfter < 30) {
                state.retryAfter = 30;
            } else if (state.retryAfter > 86400) {
                state.retryAfter = 86400;
            }
            state.retryAfter += Helpers.sRandom.nextInt(31);
            state.retryAfter *= 1000;
        }
    }

    private void setupDestinationFile(State state) throws StopRequestException {
        File destinationFile;
        if (TextUtils.isEmpty((CharSequence)state.filename)) {
            return;
        }
        Log.i((Object[])new Object[]{"have run thread before for id: " + this.originalDownloadInfo.getId() + ", and state.filename: " + state.filename});
        if (!Helpers.isFilenameValid(state.filename, this.storageManager.getDownloadDataDirectory())) {
            Log.d((Object[])new Object[]{"Yeah we know we are bad for downloading to internal storage"});
        }
        if ((destinationFile = new File(state.filename)).exists()) {
            Log.i((Object[])new Object[]{"resuming download for id: " + this.originalDownloadInfo.getId() + ", and state.filename: " + state.filename});
            long fileLength = destinationFile.length();
            if (fileLength == 0L) {
                Log.d((Object[])new Object[]{"setupDestinationFile() found fileLength=0, deleting " + state.filename});
                destinationFile.delete();
                state.filename = null;
                Log.i((Object[])new Object[]{"resuming download for id: " + this.originalDownloadInfo.getId() + ", BUT starting from scratch again: "});
            } else {
                if (!this.originalDownloadInfo.isResumable()) {
                    Log.d((Object[])new Object[]{"setupDestinationFile() unable to resume download, deleting " + state.filename});
                    destinationFile.delete();
                    throw new StopRequestException(489, "Trying to resume a download that can't be resumed");
                }
                Log.i((Object[])new Object[]{"resuming download for id: " + this.originalDownloadInfo.getId() + ", and starting with file of length: " + fileLength});
                state.currentBytes = (int)fileLength;
                if (this.originalDownloadInfo.getTotalBytes() != -1L) {
                    state.contentLength = this.originalDownloadInfo.getTotalBytes();
                }
                state.headerETag = this.originalDownloadInfo.getETag();
                state.continuingDownload = true;
                Log.i((Object[])new Object[]{"resuming download for id: " + this.originalDownloadInfo.getId() + ", state.currentBytes: " + state.currentBytes + ", and setting continuingDownload to true: "});
            }
        }
    }

    private void addRequestHeaders(State state, HttpURLConnection conn) {
        for (Pair<String, String> header : this.originalDownloadInfo.getHeaders()) {
            conn.addRequestProperty((String)header.first, (String)header.second);
        }
        if (conn.getRequestProperty("User-Agent") == null) {
            conn.addRequestProperty("User-Agent", this.userAgent());
        }
        conn.setRequestProperty("Accept-Encoding", "identity");
        if (state.continuingDownload) {
            if (state.headerETag != null) {
                conn.addRequestProperty("If-Match", state.headerETag);
            }
            conn.addRequestProperty("Range", "bytes=" + state.currentBytes + "-");
        }
    }

    private void notifyDownloadCompleted(State state, int finalStatus, String errorMsg, int numFailed) {
        this.notifyThroughDatabase(state, finalStatus, errorMsg, numFailed);
        if (DownloadStatus.isCompleted(finalStatus)) {
            this.broadcastIntentDownloadComplete(finalStatus);
        } else if (DownloadStatus.isInsufficientSpace(finalStatus)) {
            this.broadcastIntentDownloadFailedInsufficientSpace();
        }
    }

    public void broadcastIntentDownloadComplete(int finalStatus) {
        Intent intent = new Intent("com.novoda.downloadmanager.DOWNLOAD_COMPLETE");
        intent.setPackage(this.getPackageName());
        intent.putExtra("extra_download_id", this.originalDownloadInfo.getId());
        intent.putExtra("extra_download_status", finalStatus);
        intent.setData(this.originalDownloadInfo.getMyDownloadsUri());
        if (this.originalDownloadInfo.getExtras() != null) {
            intent.putExtra("com.novoda.download.lib.KEY_INTENT_EXTRA", this.originalDownloadInfo.getExtras());
        }
        this.context.sendBroadcast(intent);
    }

    public void broadcastIntentDownloadFailedInsufficientSpace() {
        Intent intent = new Intent("com.novoda.downloadmanager.DOWNLOAD_INSUFFICIENT_SPACE");
        intent.setPackage(this.getPackageName());
        intent.putExtra("extra_download_id", this.originalDownloadInfo.getId());
        intent.setData(this.originalDownloadInfo.getMyDownloadsUri());
        if (this.originalDownloadInfo.getExtras() != null) {
            intent.putExtra("com.novoda.download.lib.KEY_INTENT_EXTRA", this.originalDownloadInfo.getExtras());
        }
        this.context.sendBroadcast(intent);
    }

    private String getPackageName() {
        return this.context.getApplicationContext().getPackageName();
    }

    private void notifyThroughDatabase(State state, int finalStatus, String errorMsg, int numFailed) {
        ContentValues values = new ContentValues(8);
        values.put("status", Integer.valueOf(finalStatus));
        values.put("_data", state.filename);
        values.put("mimetype", state.mimeType);
        values.put("last_modified_timestamp", Long.valueOf(this.systemFacade.currentTimeMillis()));
        values.put("numfailed", Integer.valueOf(numFailed));
        values.put("method", Integer.valueOf(state.retryAfter));
        if (!TextUtils.equals((CharSequence)this.originalDownloadInfo.getUri(), (CharSequence)state.requestUri)) {
            values.put("uri", state.requestUri);
        }
        if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
            values.put("errorMsg", errorMsg);
        }
        this.getContentResolver().update(this.originalDownloadInfo.getAllDownloadsUri(), values, null, null);
        this.updateBatchStatus(this.originalDownloadInfo.getBatchId(), this.originalDownloadInfo.getId());
    }

    private ContentResolver getContentResolver() {
        return this.context.getContentResolver();
    }

    private void updateBatchStatus(long batchId, long downloadId) {
        int batchStatus = this.batchRepository.getBatchStatus(batchId);
        this.batchRepository.updateBatchStatus(batchId, batchStatus);
        if (DownloadStatus.isCancelled(batchStatus)) {
            ContentValues values = new ContentValues(1);
            values.put("status", Integer.valueOf(490));
            this.getContentResolver().update(this.downloadsUriProvider.getAllDownloadsUri(), values, "batch_id = ?", new String[]{String.valueOf(batchId)});
        } else if (DownloadStatus.isError(batchStatus)) {
            ContentValues values = new ContentValues(1);
            values.put("status", Integer.valueOf(498));
            this.getContentResolver().update(this.downloadsUriProvider.getAllDownloadsUri(), values, "batch_id = ? AND _id <> ? ", new String[]{String.valueOf(batchId), String.valueOf(downloadId)});
        } else if (DownloadStatus.isSuccess(batchStatus)) {
            this.batchCompletionBroadcaster.notifyBatchCompletedFor(batchId);
        }
    }

    private static long getHeaderFieldLong(URLConnection conn, String field, long defaultValue) {
        try {
            return Long.parseLong(conn.getHeaderField(field));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean isStatusRetryable(int status) {
        switch (status) {
            case 495: 
            case 500: 
            case 503: {
                return true;
            }
        }
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setPermissions(String fileName, int mode, int uid, int gid) {
        try {
            Class<?> fileUtils = Class.forName("android.os.FileUtils");
            Method setPermissions = fileUtils.getMethod("setPermissions", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            setPermissions.invoke(null, fileName, mode, uid, gid);
        }
        catch (Exception e) {
            Log.e((Object[])new Object[]{"Failed to set permissions. Unknown future behaviour."});
        }
    }

    static class State {
        public String filename;
        public String mimeType;
        public int retryAfter = 0;
        public boolean gotData = false;
        public String requestUri;
        public long totalBytes = -1L;
        public long currentBytes = 0L;
        public String headerETag;
        public boolean continuingDownload = false;
        public long bytesNotified = 0L;
        public long timeLastNotification = 0L;
        public int networkType = -1;
        public long speed;
        public long speedSampleStart;
        public long speedSampleBytes;
        public long contentLength = -1L;
        public String contentDisposition;
        public String contentLocation;
        public int redirectionCount;
        public URL url;

        public State(FileDownloadInfo info) {
            this.mimeType = DownloadThread.normalizeMimeType(info.getMimeType());
            this.requestUri = info.getUri();
            this.filename = info.getFileName();
            this.totalBytes = info.getTotalBytes();
            this.currentBytes = info.getCurrentBytes();
        }

        public void resetBeforeExecute() {
            this.contentLength = -1L;
            this.contentDisposition = null;
            this.contentLocation = null;
            this.redirectionCount = 0;
        }
    }
}

