/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

final class DownloadStatus {
    public static final int DELETING = 188;
    public static final int SUBMITTED = 189;
    public static final int PENDING = 190;
    public static final int RUNNING = 192;
    public static final int PAUSED_BY_APP = 193;
    public static final int WAITING_TO_RETRY = 194;
    public static final int WAITING_FOR_NETWORK = 195;
    public static final int QUEUED_FOR_WIFI = 196;
    public static final int INSUFFICIENT_SPACE_ERROR = 198;
    public static final int DEVICE_NOT_FOUND_ERROR = 199;
    public static final int SUCCESS = 200;
    public static final int BAD_REQUEST = 400;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int MIN_ARTIFICIAL_ERROR_STATUS = 488;
    public static final int FILE_ALREADY_EXISTS_ERROR = 488;
    public static final int CANNOT_RESUME = 489;
    public static final int CANCELED = 490;
    public static final int UNKNOWN_ERROR = 491;
    public static final int FILE_ERROR = 492;
    public static final int UNHANDLED_REDIRECT = 493;
    public static final int UNHANDLED_HTTP_CODE = 494;
    public static final int HTTP_DATA_ERROR = 495;
    public static final int HTTP_EXCEPTION = 496;
    public static final int TOO_MANY_REDIRECTS = 497;
    public static final int BATCH_FAILED = 498;

    public static boolean isInformational(int status) {
        return status >= 100 && status < 200;
    }

    public static boolean isSuccess(int status) {
        return status >= 200 && status < 300;
    }

    public static boolean isError(int status) {
        return status >= 400 && status < 600;
    }

    public static boolean isClientError(int status) {
        return status >= 400 && status < 500;
    }

    public static boolean isServerError(int status) {
        return status >= 500 && status < 600;
    }

    public static boolean isNotificationToBeDisplayed(int visibility) {
        return visibility == 1 || visibility == 3;
    }

    public static boolean isCompleted(int status) {
        return DownloadStatus.isSuccess(status) || DownloadStatus.isError(status) && !DownloadStatus.isCancelled(status);
    }

    public static boolean isCancelled(int status) {
        return status == 490;
    }

    public static boolean isSubmitted(int status) {
        return status == 189;
    }

    public static boolean isRunning(int status) {
        return status == 192;
    }

    public static boolean isDeleting(int status) {
        return status == 188;
    }

    public static boolean isInsufficientSpace(int finalStatus) {
        return finalStatus == 198;
    }

    static String statusToString(int status) {
        switch (status) {
            case 190: {
                return "PENDING";
            }
            case 192: {
                return "RUNNING";
            }
            case 193: {
                return "PAUSED_BY_APP";
            }
            case 194: {
                return "WAITING_TO_RETRY";
            }
            case 195: {
                return "WAITING_FOR_NETWORK";
            }
            case 196: {
                return "QUEUED_FOR_WIFI";
            }
            case 198: {
                return "INSUFFICIENT_SPACE_ERROR";
            }
            case 199: {
                return "DEVICE_NOT_FOUND_ERROR";
            }
            case 200: {
                return "SUCCESS";
            }
            case 400: {
                return "BAD_REQUEST";
            }
            case 406: {
                return "NOT_ACCEPTABLE";
            }
            case 411: {
                return "LENGTH_REQUIRED";
            }
            case 412: {
                return "PRECONDITION_FAILED";
            }
            case 488: {
                return "FILE_ALREADY_EXISTS_ERROR";
            }
            case 489: {
                return "CANNOT_RESUME";
            }
            case 490: {
                return "CANCELED";
            }
            case 491: {
                return "UNKNOWN_ERROR";
            }
            case 492: {
                return "FILE_ERROR";
            }
            case 493: {
                return "UNHANDLED_REDIRECT";
            }
            case 494: {
                return "UNHANDLED_HTTP_CODE";
            }
            case 495: {
                return "HTTP_DATA_ERROR";
            }
            case 496: {
                return "HTTP_EXCEPTION";
            }
            case 497: {
                return "TOO_MANY_REDIRECTS";
            }
        }
        return Integer.toString(status);
    }

    private DownloadStatus() {
    }
}

