/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.support.annotation.NonNull;
import com.novoda.downloadmanager.lib.BatchCompletionBroadcaster;
import com.novoda.downloadmanager.lib.BatchRepository;
import com.novoda.downloadmanager.lib.ConcurrentDownloadsLimitProvider;
import com.novoda.downloadmanager.lib.ContentLengthFetcher;
import com.novoda.downloadmanager.lib.DownloadBatch;
import com.novoda.downloadmanager.lib.DownloadClientReadyChecker;
import com.novoda.downloadmanager.lib.DownloadDeleter;
import com.novoda.downloadmanager.lib.DownloadExecutorFactory;
import com.novoda.downloadmanager.lib.DownloadNotifier;
import com.novoda.downloadmanager.lib.DownloadReadyChecker;
import com.novoda.downloadmanager.lib.DownloadReceiver;
import com.novoda.downloadmanager.lib.DownloadScanner;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.DownloadThread;
import com.novoda.downloadmanager.lib.DownloadsRepository;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.downloadmanager.lib.NetworkChecker;
import com.novoda.downloadmanager.lib.NotificationDisplayer;
import com.novoda.downloadmanager.lib.NotificationImageRetriever;
import com.novoda.downloadmanager.lib.NotificationImageRetrieverFactory;
import com.novoda.downloadmanager.lib.OkHttpNotificationImageRetriever;
import com.novoda.downloadmanager.lib.PublicFacingDownloadMarshaller;
import com.novoda.downloadmanager.lib.RealSystemFacade;
import com.novoda.downloadmanager.lib.StorageManager;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.downloadmanager.lib.TarFileTruncator;
import com.novoda.notils.logger.simple.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class DownloadService
extends Service {
    private static final boolean DEBUG_LIFECYCLE = false;
    private final ContentLengthFetcher contentLengthFetcher = new ContentLengthFetcher();
    private SystemFacade systemFacade;
    private AlarmManager alarmManager;
    private StorageManager storageManager;
    private DownloadManagerContentObserver downloadManagerContentObserver;
    private DownloadNotifier downloadNotifier;
    private ExecutorService executor;
    private DownloadScanner downloadScanner;
    private HandlerThread updateThread;
    private Handler updateHandler;
    private volatile int lastStartId;
    private BatchRepository batchRepository;
    private DownloadsRepository downloadsRepository;
    private DownloadDeleter downloadDeleter;
    private DownloadReadyChecker downloadReadyChecker;
    private TarFileTruncator tarFileTruncator;
    private DownloadsUriProvider downloadsUriProvider;
    private BatchCompletionBroadcaster batchCompletionBroadcaster;
    private NetworkChecker networkChecker;
    private static final int MSG_UPDATE = 1;
    private static final int MSG_FINAL_UPDATE = 2;
    private final Handler.Callback updateCallback = new Handler.Callback(){

        public boolean handleMessage(@NonNull Message msg) {
            Process.setThreadPriority((int)10);
            int startId = msg.arg1;
            boolean isActive = DownloadService.this.updateLocked();
            if (msg.what == 2) {
                for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                    if (!entry.getKey().getName().startsWith("pool")) continue;
                    Log.d((Object[])new Object[]{entry.getKey() + ": " + Arrays.toString(entry.getValue())});
                }
                DownloadService.this.downloadNotifier.dumpSpeeds();
                Log.wtf((String)("Final update pass triggered, isActive=" + isActive), (Throwable)new IllegalStateException("someone didn't update correctly"));
            }
            if (isActive) {
                DownloadService.this.enqueueFinalUpdate();
            } else if (DownloadService.this.stopSelfResult(startId)) {
                DownloadService.this.shutDown();
            }
            return true;
        }
    };

    public IBinder onBind(@NonNull Intent intent) {
        throw new UnsupportedOperationException("Cannot bind to Download Manager Service");
    }

    public void onCreate() {
        super.onCreate();
        Log.v((Object[])new Object[]{"Service onCreate"});
        if (this.systemFacade == null) {
            this.systemFacade = new RealSystemFacade((Context)this);
        }
        this.downloadsUriProvider = DownloadsUriProvider.getInstance();
        this.downloadDeleter = new DownloadDeleter(this.getContentResolver());
        this.batchRepository = new BatchRepository(this.getContentResolver(), this.downloadDeleter, this.downloadsUriProvider, this.systemFacade);
        PublicFacingDownloadMarshaller downloadMarshaller = new PublicFacingDownloadMarshaller();
        DownloadClientReadyChecker downloadClientReadyChecker = this.getDownloadClientReadyChecker();
        this.networkChecker = new NetworkChecker(this.systemFacade);
        this.downloadReadyChecker = new DownloadReadyChecker(this.systemFacade, this.networkChecker, downloadClientReadyChecker, downloadMarshaller);
        this.tarFileTruncator = new TarFileTruncator();
        String applicationPackageName = this.getApplicationContext().getPackageName();
        this.batchCompletionBroadcaster = new BatchCompletionBroadcaster((Context)this, applicationPackageName);
        this.alarmManager = (AlarmManager)this.getSystemService("alarm");
        ContentResolver contentResolver = this.getContentResolver();
        File downloadDataDir = StorageManager.getDownloadDataDirectory((Context)this);
        File externalStorageDir = Environment.getExternalStorageDirectory();
        File internalStorageDir = Environment.getDataDirectory();
        File systemCacheDir = Environment.getDownloadCacheDirectory();
        this.storageManager = new StorageManager(contentResolver, externalStorageDir, internalStorageDir, systemCacheDir, downloadDataDir, this.downloadsUriProvider);
        this.updateThread = new HandlerThread("DownloadManager-UpdateThread");
        this.updateThread.start();
        this.updateHandler = new Handler(this.updateThread.getLooper(), this.updateCallback);
        this.downloadScanner = new DownloadScanner(this.getContentResolver(), (Context)this, this.downloadsUriProvider);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        NotificationDisplayer notificationDisplayer = new NotificationDisplayer((Context)this, notificationManager, this.getNotificationImageRetriever(), this.getResources(), this.downloadsUriProvider);
        this.downloadNotifier = new DownloadNotifier((Context)this, notificationDisplayer);
        this.downloadNotifier.cancelAll();
        this.downloadManagerContentObserver = new DownloadManagerContentObserver();
        this.getContentResolver().registerContentObserver(this.downloadsUriProvider.getAllDownloadsUri(), true, (ContentObserver)this.downloadManagerContentObserver);
        PackageManager packageManager = this.getPackageManager();
        String packageName = this.getApplicationContext().getPackageName();
        ConcurrentDownloadsLimitProvider concurrentDownloadsLimitProvider = new ConcurrentDownloadsLimitProvider(packageManager, packageName);
        DownloadExecutorFactory factory = new DownloadExecutorFactory(concurrentDownloadsLimitProvider);
        this.executor = factory.createExecutor();
        this.downloadsRepository = new DownloadsRepository(this.getContentResolver(), new DownloadsRepository.DownloadInfoCreator(){

            @Override
            public FileDownloadInfo create(FileDownloadInfo.Reader reader) {
                return DownloadService.this.createNewDownloadInfo(reader);
            }

            @Override
            public FileDownloadInfo.ControlStatus create(FileDownloadInfo.ControlStatus.Reader reader, long id) {
                return DownloadService.this.createNewDownloadInfoControlStatus(reader, id);
            }
        }, this.downloadsUriProvider);
    }

    private FileDownloadInfo createNewDownloadInfo(FileDownloadInfo.Reader reader) {
        FileDownloadInfo info = reader.newDownloadInfo(this.systemFacade, this.downloadsUriProvider);
        Log.v((Object[])new Object[]{"processing inserted download " + info.getId()});
        return info;
    }

    private FileDownloadInfo.ControlStatus createNewDownloadInfoControlStatus(FileDownloadInfo.ControlStatus.Reader reader, long id) {
        return reader.newControlStatus(id);
    }

    private DownloadClientReadyChecker getDownloadClientReadyChecker() {
        if (this.getApplication() instanceof DownloadClientReadyChecker) {
            return (DownloadClientReadyChecker)this.getApplication();
        }
        return DownloadClientReadyChecker.READY;
    }

    private NotificationImageRetriever getNotificationImageRetriever() {
        if (this.getApplication() instanceof NotificationImageRetrieverFactory) {
            return ((NotificationImageRetrieverFactory)this.getApplication()).createNotificationImageRetriever();
        }
        return new OkHttpNotificationImageRetriever();
    }

    public int onStartCommand(@NonNull Intent intent, int flags, int startId) {
        int returnValue = super.onStartCommand(intent, flags, startId);
        Log.v((Object[])new Object[]{"Service onStart"});
        this.lastStartId = startId;
        this.enqueueUpdate();
        return returnValue;
    }

    public void onDestroy() {
        this.shutDown();
        Log.v((Object[])new Object[]{"Service onDestroy"});
        super.onDestroy();
    }

    private void shutDown() {
        Log.d((Object[])new Object[]{"Shutting down service"});
        this.getContentResolver().unregisterContentObserver((ContentObserver)this.downloadManagerContentObserver);
        this.downloadScanner.shutdown();
        this.updateThread.quit();
    }

    private void enqueueUpdate() {
        this.updateHandler.removeMessages(1);
        this.updateHandler.obtainMessage(1, this.lastStartId, -1).sendToTarget();
    }

    private void enqueueFinalUpdate() {
        this.updateHandler.removeMessages(2);
        this.updateHandler.sendMessageDelayed(this.updateHandler.obtainMessage(2, this.lastStartId, -1), 300000L);
    }

    private boolean updateLocked() {
        boolean isActive = false;
        long nextRetryTimeMillis = Long.MAX_VALUE;
        long now = this.systemFacade.currentTimeMillis();
        List<FileDownloadInfo> allDownloads = this.downloadsRepository.getAllDownloads();
        this.updateTotalBytesFor(allDownloads);
        List<DownloadBatch> downloadBatches = this.batchRepository.retrieveBatchesFor(allDownloads);
        for (DownloadBatch downloadBatch : downloadBatches) {
            if (!downloadBatch.isActive()) continue;
            isActive = true;
            break;
        }
        for (DownloadBatch downloadBatch : downloadBatches) {
            if (downloadBatch.isDeleted() || downloadBatch.prune(this.downloadDeleter)) continue;
            if (!isActive && this.downloadReadyChecker.canDownload(downloadBatch)) {
                this.downloadOrContinueBatch(downloadBatch.getDownloads());
                isActive = true;
            } else if (downloadBatch.scanCompletedMediaIfReady(this.downloadScanner)) {
                isActive = true;
            }
            nextRetryTimeMillis = downloadBatch.nextActionMillis(now, nextRetryTimeMillis);
        }
        this.batchRepository.deleteMarkedBatchesFor(allDownloads);
        this.updateUserVisibleNotification(downloadBatches);
        if (nextRetryTimeMillis > 0L && nextRetryTimeMillis < Long.MAX_VALUE) {
            Log.v((Object[])new Object[]{"scheduling start in " + nextRetryTimeMillis + "ms"});
            Intent intent = new Intent("android.intent.action.DOWNLOAD_WAKEUP");
            intent.setClass((Context)this, DownloadReceiver.class);
            this.alarmManager.set(0, now + nextRetryTimeMillis, PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x40000000));
        }
        return isActive;
    }

    private void downloadOrContinueBatch(List<FileDownloadInfo> downloads) {
        for (FileDownloadInfo info : downloads) {
            if (DownloadStatus.isCompleted(info.getStatus()) || info.isSubmittedOrRunning()) continue;
            this.download(info);
        }
    }

    private void download(FileDownloadInfo info) {
        DownloadThread downloadThread = new DownloadThread((Context)this, this.systemFacade, info, this.storageManager, this.downloadNotifier, this.batchCompletionBroadcaster, this.batchRepository, this.downloadsUriProvider, this.downloadsRepository, this.networkChecker, this.downloadReadyChecker, this.tarFileTruncator);
        ContentValues contentValues = new ContentValues();
        contentValues.put("status", Integer.valueOf(189));
        this.getContentResolver().update(info.getAllDownloadsUri(), contentValues, null, null);
        this.executor.submit(downloadThread);
    }

    private void updateTotalBytesFor(Collection<FileDownloadInfo> downloadInfos) {
        ContentValues values = new ContentValues(1);
        for (FileDownloadInfo downloadInfo : downloadInfos) {
            if (!downloadInfo.hasUnknownTotalBytes()) continue;
            long totalBytes = this.contentLengthFetcher.fetchContentLengthFor(downloadInfo);
            values.put("total_bytes", Long.valueOf(totalBytes));
            this.getContentResolver().update(downloadInfo.getAllDownloadsUri(), values, null, null);
        }
    }

    private void updateUserVisibleNotification(Collection<DownloadBatch> batches) {
        this.downloadNotifier.updateWith(batches);
    }

    protected void dump(FileDescriptor fd, @NonNull PrintWriter writer, String[] args) {
        Log.e((Object[])new Object[]{"I want to dump but nothing to dump into"});
    }

    private class DownloadManagerContentObserver
    extends ContentObserver {
        public DownloadManagerContentObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            DownloadService.this.enqueueUpdate();
        }
    }
}

