/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.SystemClock;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.notils.logger.simple.Log;
import java.util.HashMap;
import java.util.Map;

class DownloadScanner
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final long SCAN_TIMEOUT = 60000L;
    private final ContentResolver resolver;
    private final MediaScannerConnection mediaScannerConnection;
    private final DownloadsUriProvider downloadsUriProvider;
    private Map<String, ScanRequest> pendingRequests = new HashMap<String, ScanRequest>();

    public DownloadScanner(ContentResolver resolver, Context context, DownloadsUriProvider downloadsUriProvider) {
        this.resolver = resolver;
        this.mediaScannerConnection = new MediaScannerConnection(context, (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.downloadsUriProvider = downloadsUriProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingScans() {
        MediaScannerConnection mediaScannerConnection = this.mediaScannerConnection;
        synchronized (mediaScannerConnection) {
            if (this.pendingRequests.isEmpty()) {
                return false;
            }
            long nowRealtime = SystemClock.elapsedRealtime();
            for (ScanRequest req : this.pendingRequests.values()) {
                if (nowRealtime >= req.requestRealtime + 60000L) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestScan(FileDownloadInfo info) {
        Log.v((Object[])new Object[]{"requestScan() for " + info.getFileName()});
        MediaScannerConnection mediaScannerConnection = this.mediaScannerConnection;
        synchronized (mediaScannerConnection) {
            ScanRequest req = new ScanRequest(info.getId(), info.getFileName(), info.getMimeType());
            this.pendingRequests.put(req.path, req);
            if (this.mediaScannerConnection.isConnected()) {
                req.exec(this.mediaScannerConnection);
            } else {
                this.mediaScannerConnection.connect();
            }
        }
    }

    public void shutdown() {
        this.mediaScannerConnection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMediaScannerConnected() {
        MediaScannerConnection mediaScannerConnection = this.mediaScannerConnection;
        synchronized (mediaScannerConnection) {
            for (ScanRequest req : this.pendingRequests.values()) {
                req.exec(this.mediaScannerConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScanCompleted(String path, Uri uri) {
        Uri downloadUri;
        int rows;
        ScanRequest req;
        MediaScannerConnection mediaScannerConnection = this.mediaScannerConnection;
        synchronized (mediaScannerConnection) {
            req = this.pendingRequests.remove(path);
        }
        if (req == null) {
            Log.w((Object[])new Object[]{"Missing request for path " + path});
            return;
        }
        ContentValues values = new ContentValues();
        values.put("scanned", Integer.valueOf(1));
        if (uri != null) {
            values.put("mediaprovider_uri", uri.toString());
        }
        if ((rows = this.resolver.update(downloadUri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)req.id), values, null, null)) == 0) {
            this.resolver.delete(uri, null, null);
        }
    }

    private static class ScanRequest {
        public final long id;
        public final String path;
        public final String mimeType;
        public final long requestRealtime;

        public ScanRequest(long id, String path, String mimeType) {
            this.id = id;
            this.path = path;
            this.mimeType = mimeType;
            this.requestRealtime = SystemClock.elapsedRealtime();
        }

        public void exec(MediaScannerConnection conn) {
            conn.scanFile(this.path, this.mimeType);
        }
    }
}

