/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.widget.Toast;
import com.novoda.downloadmanager.lib.DownloadManager;
import com.novoda.downloadmanager.lib.DownloadService;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.OpenHelper;
import com.novoda.notils.logger.simple.Log;

public class DownloadReceiver
extends BroadcastReceiver {
    private static final String TAG = "DownloadReceiver";
    static final String EXTRA_BATCH_ID = "com.novoda.extra.BATCH_ID";
    private static final int TRUE_THIS_IS_CLEARER_NOW = 1;
    private static Handler sAsyncHandler;
    private final DownloadsUriProvider downloadsUriProvider = DownloadsUriProvider.getInstance();

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        switch (intent.getAction()) {
            case "android.intent.action.BOOT_COMPLETED": 
            case "android.intent.action.MEDIA_MOUNTED": 
            case "android.intent.action.DOWNLOAD_WAKEUP": {
                this.startService(context);
                break;
            }
            case "android.net.conn.CONNECTIVITY_CHANGE": {
                this.checkConnectivityToStartService(context);
                break;
            }
            case "android.intent.action.DOWNLOAD_OPEN": 
            case "android.intent.action.DOWNLOAD_LIST": 
            case "android.intent.action.DOWNLOAD_HIDE": 
            case "android.intent.action.DOWNLOAD_DELETE": 
            case "android.intent.action.DOWNLOAD_CANCEL": {
                this.handleSystemNotificationAction(context, intent);
                break;
            }
        }
    }

    private void checkConnectivityToStartService(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connManager.getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            this.startService(context);
        }
    }

    private void handleSystemNotificationAction(final Context context, final Intent intent) {
        final BroadcastReceiver.PendingResult result = this.goAsync();
        if (result == null) {
            this.handleNotificationBroadcast(context, intent);
        } else {
            sAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    DownloadReceiver.this.handleNotificationBroadcast(context, intent);
                    result.finish();
                }
            });
        }
    }

    private void handleNotificationBroadcast(Context context, Intent intent) {
        String action;
        switch (action = intent.getAction()) {
            case "android.intent.action.DOWNLOAD_LIST": {
                long[] ids = intent.getLongArrayExtra("extra_click_download_ids");
                this.sendNotificationClickedIntent(context, ids);
                break;
            }
            case "android.intent.action.DOWNLOAD_OPEN": {
                long id = ContentUris.parseId((Uri)intent.getData());
                this.openDownload(context, id);
                long batchId = this.getBatchId(intent);
                this.hideNotification(context, batchId);
                break;
            }
            case "android.intent.action.DOWNLOAD_HIDE": {
                long batchId = this.getBatchId(intent);
                this.hideNotification(context, batchId);
                break;
            }
            case "android.intent.action.DOWNLOAD_CANCEL": {
                this.cancelBatchThroughDatabaseState(context, intent);
                break;
            }
            case "android.intent.action.DOWNLOAD_DELETE": {
                this.deleteDownloadThroughDatabaseState(context, intent);
                break;
            }
        }
    }

    private void sendNotificationClickedIntent(Context context, long[] ids) {
        Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)ids[0]);
        Intent appIntent = new Intent("com.novoda.downloadmaanger.DOWNLOAD_NOTIFICATION_CLICKED");
        appIntent.setPackage(context.getPackageName());
        appIntent.putExtra("extra_click_download_ids", ids);
        if (ids.length == 1) {
            appIntent.setData(uri);
        } else {
            appIntent.setData(this.downloadsUriProvider.getContentUri());
        }
        context.sendBroadcast(appIntent);
    }

    private void openDownload(Context context, long id) {
        ContentResolver contentResolver = context.getContentResolver();
        DownloadManager downloadManager = new DownloadManager(context, contentResolver);
        OpenHelper openHelper = new OpenHelper(downloadManager, this.downloadsUriProvider);
        Intent intent = openHelper.buildViewIntent(context, id);
        intent.addFlags(0x10000000);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException ex) {
            Log.d((String)("no activity for " + intent), (Throwable)ex);
            Toast.makeText((Context)context, (CharSequence)"Cannot open file", (int)1).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideNotification(Context context, long batchId) {
        Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getBatchesUri(), (long)batchId);
        try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);){
            if (cursor.moveToFirst()) {
                int status = DownloadReceiver.getInt(cursor, "batch_status");
                int visibility = DownloadReceiver.getInt(cursor, "visibility");
                if ((DownloadStatus.isCancelled(status) || DownloadStatus.isCompleted(status)) && (visibility == 1 || visibility == 3)) {
                    ContentValues values = new ContentValues(1);
                    values.put("visibility", Integer.valueOf(0));
                    context.getContentResolver().update(uri, values, null, null);
                }
            } else {
                Log.w((Object[])new Object[]{"Missing details for download " + batchId});
            }
        }
    }

    private void cancelBatchThroughDatabaseState(Context context, Intent intent) {
        ContentValues downloadValues = new ContentValues(1);
        downloadValues.put("status", Integer.valueOf(490));
        long batchId = this.getBatchId(intent);
        context.getContentResolver().update(this.downloadsUriProvider.getAllDownloadsUri(), downloadValues, "batch_id = ?", new String[]{String.valueOf(batchId)});
        ContentValues batchValues = new ContentValues(1);
        batchValues.put("batch_status", Integer.valueOf(490));
        context.getContentResolver().update(ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getBatchesUri(), (long)batchId), batchValues, null, null);
    }

    private void deleteDownloadThroughDatabaseState(Context context, Intent intent) {
        ContentValues values = new ContentValues(1);
        values.put("deleted", Integer.valueOf(1));
        context.getContentResolver().update(this.getDownloadUri(intent), values, null, null);
    }

    private Uri getDownloadUri(Intent intent) {
        long downloadId = -1L;
        if (intent.getData() != null) {
            downloadId = ContentUris.parseId((Uri)intent.getData());
        }
        return ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getAllDownloadsUri(), (long)downloadId);
    }

    private long getBatchId(Intent intent) {
        return intent.getLongExtra(EXTRA_BATCH_ID, -1L);
    }

    private static int getInt(Cursor cursor, String col) {
        return cursor.getInt(cursor.getColumnIndexOrThrow(col));
    }

    private void startService(Context context) {
        context.startService(new Intent(context, DownloadService.class));
    }

    static {
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        sAsyncHandler = new Handler(thread.getLooper());
    }
}

