/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.os.Environment;
import com.novoda.downloadmanager.lib.DownloadBatch;
import com.novoda.downloadmanager.lib.DownloadClientReadyChecker;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.downloadmanager.lib.NetworkChecker;
import com.novoda.downloadmanager.lib.PublicFacingDownloadMarshaller;
import com.novoda.downloadmanager.lib.SystemFacade;

class DownloadReadyChecker {
    private final SystemFacade systemFacade;
    private final NetworkChecker networkChecker;
    private final DownloadClientReadyChecker downloadClientReadyChecker;
    private final PublicFacingDownloadMarshaller downloadMarshaller;

    DownloadReadyChecker(SystemFacade systemFacade, NetworkChecker networkChecker, DownloadClientReadyChecker downloadClientReadyChecker, PublicFacingDownloadMarshaller downloadMarshaller) {
        this.systemFacade = systemFacade;
        this.networkChecker = networkChecker;
        this.downloadClientReadyChecker = downloadClientReadyChecker;
        this.downloadMarshaller = downloadMarshaller;
    }

    public boolean canDownload(DownloadBatch downloadBatch) {
        if (downloadBatch.getStatus() == 190) {
            return true;
        }
        for (FileDownloadInfo fileDownloadInfo : downloadBatch.getDownloads()) {
            if (this.isDownloadManagerReadyToDownload(fileDownloadInfo)) continue;
            return false;
        }
        return this.downloadClientReadyChecker.isAllowedToDownload(this.downloadMarshaller.marshall(downloadBatch));
    }

    private boolean isDownloadManagerReadyToDownload(FileDownloadInfo downloadInfo) {
        if (downloadInfo.getControl() == 1) {
            return false;
        }
        switch (downloadInfo.getStatus()) {
            case 0: 
            case 190: 
            case 192: {
                return true;
            }
            case 195: 
            case 196: {
                return this.networkChecker.checkCanUseNetwork(downloadInfo) == FileDownloadInfo.NetworkState.OK;
            }
            case 194: {
                long now = this.systemFacade.currentTimeMillis();
                return downloadInfo.restartTime(now) <= now;
            }
            case 199: {
                return Environment.getExternalStorageState().equals("mounted");
            }
            case 198: {
                return false;
            }
        }
        return false;
    }
}

