/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.novoda.downloadmanager.lib.DatabaseFilenameProvider;
import com.novoda.downloadmanager.lib.DatabaseHelper;
import com.novoda.downloadmanager.lib.DownloadManager;
import com.novoda.downloadmanager.lib.DownloadService;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.GlobalState;
import com.novoda.downloadmanager.lib.Helpers;
import com.novoda.downloadmanager.lib.RealSystemFacade;
import com.novoda.downloadmanager.lib.Reflector;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.notils.logger.simple.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DownloadProvider
extends ContentProvider {
    public static final String AUTHORITY = Reflector.reflectAuthority();
    private static final String DB_NAME = "downloads.db";
    private static final String DOWNLOAD_LIST_TYPE = "vnd.android.cursor.dir/download";
    private static final String DOWNLOAD_TYPE = "vnd.android.cursor.item/download";
    private static final String BATCH_LIST_TYPE = "vnd.android.cursor.dir/batch";
    private static final String BATCH_TYPE = "vnd.android.cursor.item/batch";
    private static final String DOWNLOADS_BY_BATCH_TYPE = "vnd.android.cursor.dir/download_by_batch";
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final int MY_DOWNLOADS = 1;
    private static final int MY_DOWNLOADS_ID = 2;
    private static final int ALL_DOWNLOADS = 3;
    private static final int ALL_DOWNLOADS_ID = 4;
    private static final int REQUEST_HEADERS_URI = 5;
    private static final int PUBLIC_DOWNLOAD_ID = 6;
    private static final int BATCHES = 7;
    private static final int BATCHES_ID = 8;
    private static final int DOWNLOADS_BY_BATCH = 9;
    private static final String[] APP_READABLE_COLUMNS_ARRAY = new String[]{"_id", "entity", "_data", "mimetype", "destination", "control", "status", "last_modified_timestamp", "notificationclass", "total_bytes", "current_bytes", "uri", "is_visible_in_downloads_ui", "hint", "mediaprovider_uri", "deleted", "notificationextras", "batch_id", "always_resume", "allow_tar_updates", "_id", "batch_status", "batch_title", "batch_description", "batch_notificationBigPictureResourceId", "visibility", "batch_total_bytes", "batch_current_bytes", "_display_name", "_size"};
    private static final Set<String> APP_READABLE_COLUMNS_SET;
    private static final Map<String, String> COLUMNS_MAP;
    private static final List<String> DOWNLOAD_MANAGER_COLUMNS_LIST;
    private final DownloadsUriProvider downloadsUriProvider = DownloadsUriProvider.getInstance();
    private final Uri[] baseUris = new Uri[]{this.downloadsUriProvider.getContentUri(), this.downloadsUriProvider.getAllDownloadsUri(), this.downloadsUriProvider.getBatchesUri()};
    private SQLiteOpenHelper openHelper;
    private int systemUid = -1;
    private int defcontaineruid = -1;
    private File downloadsDataDir;
    SystemFacade systemFacade;

    public boolean onCreate() {
        if (this.systemFacade == null) {
            this.systemFacade = new RealSystemFacade(this.getContext());
        }
        Context context = this.getContext();
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getApplicationContext().getPackageName();
        DatabaseFilenameProvider databaseFilenameProvider = new DatabaseFilenameProvider(packageManager, packageName, DB_NAME);
        String databaseFilename = databaseFilenameProvider.getDatabaseFilename();
        this.openHelper = new DatabaseHelper(context, databaseFilename);
        this.systemUid = 1000;
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.getContext().getPackageManager().getApplicationInfo("com.android.defcontainer", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.wtf((String)"Could not get ApplicationInfo for com.android.defconatiner", (Throwable)e);
        }
        if (appInfo != null) {
            this.defcontaineruid = appInfo.uid;
        }
        context.startService(new Intent(context, DownloadService.class));
        this.downloadsDataDir = context.getCacheDir();
        return true;
    }

    @NonNull
    public String getType(@NonNull Uri uri) {
        int match = URI_MATCHER.match(uri);
        switch (match) {
            case 1: 
            case 3: {
                return DOWNLOAD_LIST_TYPE;
            }
            case 2: 
            case 4: 
            case 6: {
                String id = this.getDownloadIdFromUri(uri);
                SQLiteDatabase db = this.openHelper.getReadableDatabase();
                String mimeType = DatabaseUtils.stringForQuery((SQLiteDatabase)db, (String)"SELECT mimetype FROM Downloads WHERE _id = ?", (String[])new String[]{id});
                if (TextUtils.isEmpty((CharSequence)mimeType)) {
                    return DOWNLOAD_TYPE;
                }
                return mimeType;
            }
            case 7: {
                return BATCH_LIST_TYPE;
            }
            case 8: {
                return BATCH_TYPE;
            }
            case 9: {
                return DOWNLOADS_BY_BATCH_TYPE;
            }
        }
        Log.v((Object[])new Object[]{"calling getType on an unknown URI: " + uri});
        throw new IllegalArgumentException("Unknown URI: " + uri);
    }

    public Uri insert(@NonNull Uri uri, ContentValues values) {
        SQLiteDatabase db = this.openHelper.getWritableDatabase();
        int match = URI_MATCHER.match(uri);
        if (match == 1) {
            return this.insertDownload(uri, values, db, match);
        }
        if (match == 7) {
            long rowId = db.insert("batches", null, values);
            this.notifyBatchesStatusChanged();
            return ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getBatchesUri(), (long)rowId);
        }
        Log.d((Object[])new Object[]{"calling insert on an unknown/invalid URI: " + uri});
        throw new IllegalArgumentException("Unknown/Invalid URI " + uri);
    }

    @Nullable
    private Uri insertDownload(Uri uri, ContentValues values, SQLiteDatabase db, int match) {
        long rowID;
        ContentValues filteredValues = new ContentValues();
        DownloadProvider.copyString("uri", values, filteredValues);
        DownloadProvider.copyString("entity", values, filteredValues);
        DownloadProvider.copyBoolean("no_integrity", values, filteredValues);
        DownloadProvider.copyString("hint", values, filteredValues);
        DownloadProvider.copyString("mimetype", values, filteredValues);
        Integer dest = values.getAsInteger("destination");
        if (dest != null) {
            boolean hasNonPurgeablePermission;
            if (this.getContext().checkCallingPermission("android.permission.ACCESS_DOWNLOAD_MANAGER_ADVANCED") != 0 && (dest == 1 || dest == 3 || dest == 5)) {
                throw new SecurityException("setting destination to : " + dest + " not allowed, unless PERMISSION_ACCESS_ADVANCED is granted");
            }
            boolean bl = hasNonPurgeablePermission = this.getContext().checkCallingPermission("android.permission.DOWNLOAD_CACHE_NON_PURGEABLE") == 0;
            if (dest == 2 && hasNonPurgeablePermission) {
                dest = 1;
            }
            if (dest == 4) {
                this.getContext().enforcePermission("android.permission.WRITE_EXTERNAL_STORAGE", Binder.getCallingPid(), Binder.getCallingUid(), "need WRITE_EXTERNAL_STORAGE permission to use DESTINATION_FILE_URI");
                this.checkFileUriDestination(values);
            } else if (dest == 5) {
                this.getContext().enforcePermission("android.permission.ACCESS_CACHE_FILESYSTEM", Binder.getCallingPid(), Binder.getCallingUid(), "need ACCESS_CACHE_FILESYSTEM permission to use system cache");
            }
            filteredValues.put("destination", dest);
        }
        DownloadProvider.copyInteger("control", values, filteredValues);
        if (values.getAsInteger("destination") == 6) {
            filteredValues.put("status", Integer.valueOf(200));
            filteredValues.put("total_bytes", values.getAsLong("total_bytes"));
            filteredValues.put("current_bytes", Integer.valueOf(0));
            DownloadProvider.copyInteger("scanned", values, filteredValues);
            DownloadProvider.copyString("_data", values, filteredValues);
        } else {
            filteredValues.put("status", Integer.valueOf(190));
            filteredValues.put("total_bytes", Integer.valueOf(-1));
            filteredValues.put("current_bytes", Integer.valueOf(0));
        }
        long lastMod = this.systemFacade.currentTimeMillis();
        filteredValues.put("last_modified_timestamp", Long.valueOf(lastMod));
        String clazz = values.getAsString("notificationclass");
        if (clazz != null) {
            int uid = Binder.getCallingUid();
            try {
                if (uid == 0 || this.systemFacade.userOwnsPackage(uid, this.getContext().getPackageName())) {
                    filteredValues.put("notificationclass", clazz);
                }
            }
            catch (PackageManager.NameNotFoundException ex) {
                // empty catch block
            }
        }
        DownloadProvider.copyString("notificationextras", values, filteredValues);
        DownloadProvider.copyString("extra_data", values, filteredValues);
        DownloadProvider.copyString("cookiedata", values, filteredValues);
        DownloadProvider.copyString("useragent", values, filteredValues);
        DownloadProvider.copyString("referer", values, filteredValues);
        if (this.getContext().checkCallingPermission("android.permission.ACCESS_DOWNLOAD_MANAGER_ADVANCED") == 0) {
            DownloadProvider.copyInteger("otheruid", values, filteredValues);
        }
        filteredValues.put("uid", Integer.valueOf(Binder.getCallingUid()));
        if (Binder.getCallingUid() == 0) {
            DownloadProvider.copyInteger("uid", values, filteredValues);
        }
        if (values.containsKey("is_visible_in_downloads_ui")) {
            DownloadProvider.copyBoolean("is_visible_in_downloads_ui", values, filteredValues);
        } else {
            boolean isExternal = dest == null || dest == 0;
            filteredValues.put("is_visible_in_downloads_ui", Boolean.valueOf(isExternal));
        }
        DownloadProvider.copyInteger("allowed_network_types", values, filteredValues);
        DownloadProvider.copyBoolean("allow_roaming", values, filteredValues);
        DownloadProvider.copyBoolean("allow_metered", values, filteredValues);
        DownloadProvider.copyBoolean("always_resume", values, filteredValues);
        DownloadProvider.copyBoolean("allow_tar_updates", values, filteredValues);
        DownloadProvider.copyInteger("batch_id", values, filteredValues);
        Log.v((Object[])new Object[]{"initiating download with UID " + filteredValues.getAsInteger("uid")});
        if (filteredValues.containsKey("otheruid")) {
            Log.v((Object[])new Object[]{"other UID " + filteredValues.getAsInteger("otheruid")});
        }
        if ((rowID = db.insert("Downloads", null, filteredValues)) == -1L) {
            Log.d((Object[])new Object[]{"couldn't insert into downloads database"});
            return null;
        }
        this.insertRequestHeaders(db, rowID, values);
        Context context = this.getContext();
        context.startService(new Intent(context, DownloadService.class));
        this.notifyContentChanged(uri, match);
        this.notifyDownloadStatusChanged();
        return ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getContentUri(), (long)rowID);
    }

    private void notifyDownloadStatusChanged() {
        this.getContext().getContentResolver().notifyChange(this.downloadsUriProvider.getDownloadsWithoutProgressUri(), null);
    }

    private void notifyBatchesStatusChanged() {
        this.getContext().getContentResolver().notifyChange(this.downloadsUriProvider.getBatchesWithoutProgressUri(), null);
    }

    private void checkFileUriDestination(ContentValues values) {
        String fileUri = values.getAsString("hint");
        if (fileUri == null) {
            throw new IllegalArgumentException("DESTINATION_FILE_URI must include a file URI under COLUMN_FILE_NAME_HINT");
        }
        Uri uri = Uri.parse((String)fileUri);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals("file")) {
            throw new IllegalArgumentException("Not a file URI: " + uri);
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Invalid file URI: " + uri);
        }
    }

    @NonNull
    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sort) {
        Helpers.validateSelection(selection, APP_READABLE_COLUMNS_SET);
        SQLiteDatabase db = this.openHelper.getReadableDatabase();
        int match = URI_MATCHER.match(uri);
        switch (match) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.queryDownloads(uri, projection, selection, selectionArgs, sort, db, match);
            }
            case 7: 
            case 8: {
                SqlSelection batchSelection = this.getWhereClause(uri, selection, selectionArgs, match);
                return db.query("BatchesWithSizes", projection, batchSelection.getSelection(), batchSelection.getParameters(), null, null, sort);
            }
            case 9: {
                return db.query("DownloadsByBatch", projection, selection, selectionArgs, null, null, sort);
            }
            case 5: {
                if (projection != null || selection != null || sort != null) {
                    throw new UnsupportedOperationException("Request header queries do not support projections, selections or sorting");
                }
                return this.queryRequestHeaders(db, uri);
            }
        }
        Log.v((Object[])new Object[]{"querying unknown URI: " + uri});
        throw new IllegalArgumentException("Unknown URI: " + uri);
    }

    @Nullable
    private Cursor queryDownloads(Uri uri, String[] projection, String selection, String[] selectionArgs, String sort, SQLiteDatabase db, int match) {
        Cursor ret;
        SqlSelection fullSelection = this.getWhereClause(uri, selection, selectionArgs, match);
        if (this.shouldRestrictVisibility()) {
            int i;
            if (projection == null) {
                projection = (String[])APP_READABLE_COLUMNS_ARRAY.clone();
            } else {
                for (i = 0; i < projection.length; ++i) {
                    if (APP_READABLE_COLUMNS_SET.contains(projection[i]) || DOWNLOAD_MANAGER_COLUMNS_LIST.contains(projection[i])) continue;
                    throw new IllegalArgumentException("column " + projection[i] + " is not allowed in queries");
                }
            }
            for (i = 0; i < projection.length; ++i) {
                String newColumn = COLUMNS_MAP.get(projection[i]);
                if (newColumn == null) continue;
                projection[i] = newColumn;
            }
        }
        if (GlobalState.hasVerboseLogging()) {
            this.logVerboseQueryInfo(projection, selection, selectionArgs, sort, db);
        }
        if ((ret = db.query("Downloads", projection, fullSelection.getSelection(), fullSelection.getParameters(), null, null, sort)) == null) {
            Log.v((Object[])new Object[]{"query failed in downloads database"});
        } else {
            ret.setNotificationUri(this.getContext().getContentResolver(), uri);
            Log.v((Object[])new Object[]{"created cursor " + ret + " on behalf of " + Binder.getCallingPid()});
        }
        return ret;
    }

    private void logVerboseQueryInfo(String[] projection, String selection, String[] selectionArgs, String sort, SQLiteDatabase db) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("starting query, database is ");
        if (db != null) {
            sb.append("not ");
        }
        sb.append("null; ");
        if (projection == null) {
            sb.append("projection is null; ");
        } else if (projection.length == 0) {
            sb.append("projection is empty; ");
        } else {
            for (i = 0; i < projection.length; ++i) {
                sb.append("projection[");
                sb.append(i);
                sb.append("] is ");
                sb.append(projection[i]);
                sb.append("; ");
            }
        }
        sb.append("selection is ");
        sb.append(selection);
        sb.append("; ");
        if (selectionArgs == null) {
            sb.append("selectionArgs is null; ");
        } else if (selectionArgs.length == 0) {
            sb.append("selectionArgs is empty; ");
        } else {
            for (i = 0; i < selectionArgs.length; ++i) {
                sb.append("selectionArgs[");
                sb.append(i);
                sb.append("] is ");
                sb.append(selectionArgs[i]);
                sb.append("; ");
            }
        }
        sb.append("sort is ");
        sb.append(sort);
        sb.append(".");
        Log.v((Object[])new Object[]{sb.toString()});
    }

    private String getDownloadIdFromUri(Uri uri) {
        return (String)uri.getPathSegments().get(1);
    }

    private void insertRequestHeaders(SQLiteDatabase db, long downloadId, ContentValues values) {
        ContentValues rowValues = new ContentValues();
        rowValues.put("download_id", Long.valueOf(downloadId));
        for (Map.Entry entry : values.valueSet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("http_header_")) continue;
            String headerLine = entry.getValue().toString();
            if (!headerLine.contains(":")) {
                throw new IllegalArgumentException("Invalid HTTP header line: " + headerLine);
            }
            String[] parts = headerLine.split(":", 2);
            rowValues.put("header", parts[0].trim());
            rowValues.put("value", parts[1].trim());
            db.insert("request_headers", null, rowValues);
        }
    }

    private Cursor queryRequestHeaders(SQLiteDatabase db, Uri uri) {
        String where = "download_id=" + this.getDownloadIdFromUri(uri);
        String[] projection = new String[]{"header", "value"};
        return db.query("request_headers", projection, where, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRequestHeaders(SQLiteDatabase db, String where, String[] whereArgs) {
        String[] projection = new String[]{"_id"};
        try (Cursor cursor = db.query("Downloads", projection, where, whereArgs, null, null, null, null);){
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                long id = cursor.getLong(0);
                String idWhere = "download_id=" + id;
                db.delete("request_headers", idWhere, null);
                cursor.moveToNext();
            }
        }
    }

    private boolean shouldRestrictVisibility() {
        int callingUid = Binder.getCallingUid();
        return Binder.getCallingPid() != Process.myPid() && callingUid != this.systemUid && callingUid != this.defcontaineruid;
    }

    public int update(Uri uri, ContentValues values, String where, String[] whereArgs) {
        int count;
        ContentValues filteredValues;
        Helpers.validateSelection(where, APP_READABLE_COLUMNS_SET);
        SQLiteDatabase db = this.openHelper.getWritableDatabase();
        boolean startService = false;
        if (values.containsKey("deleted") && values.getAsInteger("deleted") == 1) {
            startService = true;
        }
        if (Binder.getCallingPid() != Process.myPid()) {
            filteredValues = new ContentValues();
            DownloadProvider.copyString("entity", values, filteredValues);
            Integer i = values.getAsInteger("control");
            if (i != null) {
                filteredValues.put("control", i);
                startService = true;
            }
            DownloadProvider.copyInteger("control", values, filteredValues);
            DownloadProvider.copyString("mediaprovider_uri", values, filteredValues);
            DownloadProvider.copyInteger("deleted", values, filteredValues);
        } else {
            filteredValues = values;
            Integer status = values.getAsInteger("status");
            boolean isRestart = status != null && status == 190;
            boolean isUserBypassingSizeLimit = values.containsKey("bypass_recommended_size_limit");
            if (isRestart || isUserBypassingSizeLimit) {
                startService = true;
            }
        }
        int match = URI_MATCHER.match(uri);
        switch (match) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                SqlSelection selection = this.getWhereClause(uri, where, whereArgs, match);
                count = filteredValues.size() > 0 ? db.update("Downloads", filteredValues, selection.getSelection(), selection.getParameters()) : 0;
                this.notifyStatusIfDownloadStatusChanged(values);
                break;
            }
            case 7: 
            case 8: {
                SqlSelection batchSelection = this.getWhereClause(uri, where, whereArgs, match);
                count = db.update("batches", values, batchSelection.getSelection(), batchSelection.getParameters());
                this.notifyStatusIfBatchesStatusChanged(values);
                break;
            }
            default: {
                Log.d((Object[])new Object[]{"updating unknown/invalid URI: " + uri});
                throw new UnsupportedOperationException("Cannot update URI: " + uri);
            }
        }
        this.notifyContentChanged(uri, match);
        if (startService) {
            Context context = this.getContext();
            context.startService(new Intent(context, DownloadService.class));
        }
        return count;
    }

    private void notifyStatusIfDownloadStatusChanged(ContentValues values) {
        if (values.containsKey("status")) {
            this.notifyDownloadStatusChanged();
        }
    }

    private void notifyStatusIfBatchesStatusChanged(ContentValues values) {
        if (values.containsKey("batch_status")) {
            this.notifyBatchesStatusChanged();
        }
    }

    private void notifyContentChanged(Uri uri, int uriMatch) {
        Long downloadId = null;
        if (uriMatch == 2 || uriMatch == 4) {
            downloadId = Long.parseLong(this.getDownloadIdFromUri(uri));
        }
        for (Uri uriToNotify : this.baseUris) {
            if (downloadId != null) {
                uriToNotify = ContentUris.withAppendedId((Uri)uriToNotify, (long)downloadId);
            }
            this.getContext().getContentResolver().notifyChange(uriToNotify, null);
        }
    }

    private SqlSelection getWhereClause(Uri uri, String where, String[] whereArgs, int uriMatch) {
        SqlSelection selection = new SqlSelection();
        selection.appendClause(where, whereArgs);
        if (uriMatch == 2 || uriMatch == 4 || uriMatch == 6) {
            selection.appendClause("_id = ?", this.getDownloadIdFromUri(uri));
        }
        if (uriMatch == 8) {
            selection.appendClause("_id = ?", uri.getLastPathSegment());
        }
        if ((uriMatch == 1 || uriMatch == 2) && this.getContext().checkCallingPermission("android.permission.ACCESS_ALL_DOWNLOADS") != 0) {
            String callingUid = String.valueOf(Binder.getCallingUid());
            selection.appendClause("uid= ? OR otheruid= ?", callingUid, callingUid);
        }
        return selection;
    }

    public int delete(@NonNull Uri uri, String where, String[] whereArgs) {
        int count;
        Helpers.validateSelection(where, APP_READABLE_COLUMNS_SET);
        SQLiteDatabase db = this.openHelper.getWritableDatabase();
        int match = URI_MATCHER.match(uri);
        switch (match) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                SqlSelection selection = this.getWhereClause(uri, where, whereArgs, match);
                this.deleteRequestHeaders(db, selection.getSelection(), selection.getParameters());
                count = db.delete("Downloads", selection.getSelection(), selection.getParameters());
                this.notifyDownloadStatusChanged();
                break;
            }
            case 7: 
            case 8: {
                SqlSelection batchSelection = this.getWhereClause(uri, where, whereArgs, match);
                count = db.delete("batches", batchSelection.getSelection(), batchSelection.getParameters());
                this.notifyBatchesStatusChanged();
                break;
            }
            default: {
                Log.d((Object[])new Object[]{"deleting unknown/invalid URI: " + uri});
                throw new UnsupportedOperationException("Cannot delete URI: " + uri);
            }
        }
        this.notifyContentChanged(uri, match);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openFile(@NonNull Uri uri, String mode) throws FileNotFoundException {
        String path;
        if (GlobalState.hasVerboseLogging()) {
            this.logVerboseOpenFileInfo(uri, mode);
        }
        try (Cursor cursor = this.query(uri, new String[]{"_data"}, null, null, null);){
            int count = cursor.getCount();
            if (count != 1) {
                if (count == 0) {
                    throw new FileNotFoundException("No entry for " + uri);
                }
                throw new FileNotFoundException("Multiple items at " + uri);
            }
            cursor.moveToFirst();
            path = cursor.getString(0);
        }
        if (path == null) {
            throw new FileNotFoundException("No filename found.");
        }
        if (!Helpers.isFilenameValid(path, this.downloadsDataDir)) {
            Log.d((Object[])new Object[]{"INTERNAL FILE DOWNLOAD LOL COMMENTED EXCEPTION"});
        }
        if (!"r".equals(mode)) {
            throw new FileNotFoundException("Bad mode for " + uri + ": " + mode);
        }
        ParcelFileDescriptor ret = ParcelFileDescriptor.open((File)new File(path), (int)0x10000000);
        if (ret == null) {
            Log.v((Object[])new Object[]{"couldn't open file"});
            throw new FileNotFoundException("couldn't open file");
        }
        return ret;
    }

    public void dump(FileDescriptor fd, @NonNull PrintWriter writer, String[] args) {
        Log.e((Object[])new Object[]{"I want dump, but nothing to dump into"});
    }

    private void logVerboseOpenFileInfo(Uri uri, String mode) {
        Log.v((Object[])new Object[]{"openFile uri: " + uri + ", mode: " + mode + ", uid: " + Binder.getCallingUid()});
        Cursor cursor = this.query(this.downloadsUriProvider.getContentUri(), new String[]{"_id"}, null, null, "_id");
        if (cursor == null) {
            Log.v((Object[])new Object[]{"null cursor in openFile"});
        } else {
            if (!cursor.moveToFirst()) {
                Log.v((Object[])new Object[]{"empty cursor in openFile"});
            } else {
                do {
                    Log.v((Object[])new Object[]{"row " + cursor.getInt(0) + " available"});
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        cursor = this.query(uri, new String[]{"_data"}, null, null, null);
        if (cursor == null) {
            Log.v((Object[])new Object[]{"null cursor in openFile"});
        } else {
            if (!cursor.moveToFirst()) {
                Log.v((Object[])new Object[]{"empty cursor in openFile"});
            } else {
                String filename = cursor.getString(0);
                Log.v((Object[])new Object[]{"filename in openFile: " + filename});
                if (new File(filename).isFile()) {
                    Log.v((Object[])new Object[]{"file exists in openFile"});
                }
            }
            cursor.close();
        }
    }

    private static void copyInteger(String key, ContentValues from, ContentValues to) {
        Integer i = from.getAsInteger(key);
        if (i != null) {
            to.put(key, i);
        }
    }

    private static void copyBoolean(String key, ContentValues from, ContentValues to) {
        Boolean b = from.getAsBoolean(key);
        if (b != null) {
            to.put(key, b);
        }
    }

    private static void copyString(String key, ContentValues from, ContentValues to) {
        String s = from.getAsString(key);
        if (s != null) {
            to.put(key, s);
        }
    }

    static {
        DOWNLOAD_MANAGER_COLUMNS_LIST = Arrays.asList(DownloadManager.UNDERLYING_COLUMNS);
        URI_MATCHER.addURI(AUTHORITY, "my_downloads", 1);
        URI_MATCHER.addURI(AUTHORITY, "my_downloads/#", 2);
        URI_MATCHER.addURI(AUTHORITY, "all_downloads", 3);
        URI_MATCHER.addURI(AUTHORITY, "all_downloads/#", 4);
        URI_MATCHER.addURI(AUTHORITY, "batches", 7);
        URI_MATCHER.addURI(AUTHORITY, "batches/#", 8);
        URI_MATCHER.addURI(AUTHORITY, "downloads_by_batch", 9);
        URI_MATCHER.addURI(AUTHORITY, "my_downloads/#/headers", 5);
        URI_MATCHER.addURI(AUTHORITY, "all_downloads/#/headers", 5);
        URI_MATCHER.addURI(AUTHORITY, "download", 1);
        URI_MATCHER.addURI(AUTHORITY, "download/#", 2);
        URI_MATCHER.addURI(AUTHORITY, "download/#/headers", 5);
        URI_MATCHER.addURI(AUTHORITY, "public_downloads/#", 6);
        APP_READABLE_COLUMNS_SET = new HashSet<String>();
        Collections.addAll(APP_READABLE_COLUMNS_SET, APP_READABLE_COLUMNS_ARRAY);
        COLUMNS_MAP = new HashMap<String, String>();
        COLUMNS_MAP.put("_display_name", "batch_title AS _display_name");
        COLUMNS_MAP.put("_size", "total_bytes AS _size");
    }

    private static class SqlSelection {
        public final StringBuilder whereClause = new StringBuilder();
        public final List<String> parameters = new ArrayList<String>();

        private SqlSelection() {
        }

        public void appendClause(String newClause, String ... parameters) {
            if (newClause == null || newClause.isEmpty()) {
                return;
            }
            if (this.whereClause.length() != 0) {
                this.whereClause.append(" AND ");
            }
            this.whereClause.append("(");
            this.whereClause.append(newClause);
            this.whereClause.append(")");
            if (parameters != null) {
                for (String parameter : parameters) {
                    this.parameters.add(parameter);
                }
            }
        }

        public String getSelection() {
            return this.whereClause.toString();
        }

        public String[] getParameters() {
            String[] array = new String[this.parameters.size()];
            return this.parameters.toArray(array);
        }
    }
}

