/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import com.novoda.downloadmanager.lib.DownloadBatch;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.NotificationDisplayer;
import com.novoda.notils.logger.simple.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DownloadNotifier {
    static final int TYPE_ACTIVE = 1;
    static final int TYPE_WAITING = 2;
    static final int TYPE_SUCCESS = 3;
    static final int TYPE_FAILED = 4;
    static final int TYPE_CANCELLED = 5;
    private final Context context;
    private final SimpleArrayMap<String, Long> activeNotifications = new SimpleArrayMap();
    private final NotificationDisplayer notificationDisplayer;

    public DownloadNotifier(Context context, NotificationDisplayer notificationDisplayer) {
        this.context = context;
        this.notificationDisplayer = notificationDisplayer;
    }

    public void cancelAll() {
        this.notificationDisplayer.cancelAll();
    }

    public void notifyDownloadSpeed(long id, long bytesPerSecond) {
        this.notificationDisplayer.notifyDownloadSpeed(id, bytesPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWith(Collection<DownloadBatch> batches) {
        SimpleArrayMap<String, Long> simpleArrayMap = this.activeNotifications;
        synchronized (simpleArrayMap) {
            SimpleArrayMap<String, Collection<DownloadBatch>> clusters = this.getClustersByNotificationTag(batches);
            int size = clusters.size();
            for (int i = 0; i < size; ++i) {
                String notificationId = (String)clusters.keyAt(i);
                long firstShown = this.getFirstShownTime(notificationId);
                this.notificationDisplayer.buildAndShowNotification(clusters, notificationId, firstShown);
            }
            List<Integer> staleTagsToBeRemoved = this.getStaleTagsThatWereNotRenewed(clusters);
            this.notificationDisplayer.cancelStaleTags(staleTagsToBeRemoved);
        }
    }

    private long getFirstShownTime(String notificationId) {
        long firstShown;
        if (this.activeNotifications.containsKey((Object)notificationId)) {
            firstShown = (Long)this.activeNotifications.get((Object)notificationId);
        } else {
            firstShown = System.currentTimeMillis();
            this.activeNotifications.put((Object)notificationId, (Object)firstShown);
        }
        return firstShown;
    }

    @NonNull
    private SimpleArrayMap<String, Collection<DownloadBatch>> getClustersByNotificationTag(Collection<DownloadBatch> batches) {
        SimpleArrayMap clustered = new SimpleArrayMap();
        for (DownloadBatch batch : batches) {
            String tag = this.buildNotificationTag(batch);
            this.addBatchToCluster(tag, (SimpleArrayMap<String, Collection<DownloadBatch>>)clustered, batch);
        }
        return clustered;
    }

    private String buildNotificationTag(DownloadBatch batch) {
        int status = batch.getStatus();
        int visibility = batch.getInfo().getVisibility();
        if (status == 196) {
            return "2:" + this.context.getPackageName();
        }
        if (status == 192 && this.shouldShowActiveItem(visibility)) {
            return "1:" + this.context.getPackageName();
        }
        if (DownloadStatus.isError(status) && !DownloadStatus.isCancelled(status) && this.shouldShowCompletedItem(visibility)) {
            return "4:" + batch.getBatchId();
        }
        if (DownloadStatus.isCancelled(status) && this.shouldShowCompletedItem(visibility)) {
            return "5:" + batch.getBatchId();
        }
        if (DownloadStatus.isSuccess(status) && this.shouldShowCompletedItem(visibility)) {
            return "3:" + batch.getBatchId();
        }
        return null;
    }

    private boolean shouldShowActiveItem(int visibility) {
        return visibility == 0 || visibility == 1;
    }

    private boolean shouldShowCompletedItem(int visibility) {
        return visibility == 3 || visibility == 1;
    }

    private void addBatchToCluster(String tag, SimpleArrayMap<String, Collection<DownloadBatch>> cluster, DownloadBatch batch) {
        Collection<DownloadBatch> batches;
        if (tag == null) {
            return;
        }
        if (cluster.containsKey((Object)tag)) {
            batches = (Collection)cluster.get((Object)tag);
        } else {
            batches = new ArrayList();
            cluster.put((Object)tag, batches);
        }
        batches.add(batch);
    }

    private List<Integer> getStaleTagsThatWereNotRenewed(SimpleArrayMap<String, Collection<DownloadBatch>> clustered) {
        ArrayList<Integer> staleTags = new ArrayList<Integer>();
        for (int i = this.activeNotifications.size() - 1; i >= 0; --i) {
            String tag = (String)this.activeNotifications.keyAt(i);
            if (clustered.containsKey((Object)tag)) continue;
            staleTags.add(tag.hashCode());
            this.activeNotifications.removeAt(i);
        }
        return staleTags;
    }

    public void dumpSpeeds() {
        Log.e((Object[])new Object[]{"dump at speed"});
    }
}

