/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.Settings;
import android.text.TextUtils;
import com.novoda.downloadmanager.lib.BatchQuery;
import com.novoda.downloadmanager.lib.BatchRepository;
import com.novoda.downloadmanager.lib.DownloadDeleter;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.GlobalState;
import com.novoda.downloadmanager.lib.Query;
import com.novoda.downloadmanager.lib.RealSystemFacade;
import com.novoda.downloadmanager.lib.Request;
import com.novoda.downloadmanager.lib.RequestBatch;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.notils.logger.simple.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;

public class DownloadManager {
    public static final String EXTRA_EXTRA = "com.novoda.download.lib.KEY_INTENT_EXTRA";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_TITLE = "batch_title";
    public static final String COLUMN_DESCRIPTION = "batch_description";
    public static final String COLUMN_BATCH_ID = "batch_id";
    public static final String COLUMN_BATCH_TOTAL_SIZE_BYTES = "batch_total_bytes";
    public static final String COLUMN_BATCH_CURRENT_SIZE_BYTES = "batch_current_bytes";
    public static final String COLUMN_NOTIFICATION_EXTRAS = "notificationextras";
    public static final String COLUMN_EXTRA_DATA = "extra_data";
    public static final String COLUMN_BATCH_STATUS = "batch_status";
    public static final String COLUMN_URI = "uri";
    public static final String COLUMN_MEDIA_TYPE = "media_type";
    public static final String COLUMN_TOTAL_SIZE_BYTES = "total_size";
    public static final String COLUMN_LOCAL_URI = "local_uri";
    public static final String COLUMN_LOCAL_FILENAME = "local_filename";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_REASON = "reason";
    public static final String COLUMN_BYTES_DOWNLOADED_SO_FAR = "bytes_so_far";
    public static final String COLUMN_LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
    public static final String COLUMN_MEDIAPROVIDER_URI = "mediaprovider_uri";
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_PAUSED = 4;
    public static final int STATUS_SUCCESSFUL = 8;
    public static final int STATUS_FAILED = 16;
    public static final int STATUS_DELETING = 32;
    public static final int ERROR_UNKNOWN = 1000;
    public static final int ERROR_FILE_ERROR = 1001;
    public static final int ERROR_UNHANDLED_HTTP_CODE = 1002;
    public static final int ERROR_HTTP_DATA_ERROR = 1004;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1005;
    public static final int ERROR_INSUFFICIENT_SPACE = 1006;
    public static final int ERROR_DEVICE_NOT_FOUND = 1007;
    public static final int ERROR_CANNOT_RESUME = 1008;
    public static final int ERROR_FILE_ALREADY_EXISTS = 1009;
    public static final int PAUSED_WAITING_TO_RETRY = 1;
    public static final int PAUSED_WAITING_FOR_NETWORK = 2;
    public static final int PAUSED_QUEUED_FOR_WIFI = 3;
    public static final int PAUSED_UNKNOWN = 4;
    public static final String ACTION_DOWNLOAD_COMPLETE = "com.novoda.downloadmanager.DOWNLOAD_COMPLETE";
    public static final String ACTION_BATCH_COMPLETE = "com.novoda.downloadmanager.action.BATCH_COMPLETE";
    public static final String ACTION_DOWNLOAD_INSUFFICIENT_SPACE = "com.novoda.downloadmanager.DOWNLOAD_INSUFFICIENT_SPACE";
    public static final String ACTION_NOTIFICATION_CLICKED = "com.novoda.downloadmaanger.DOWNLOAD_NOTIFICATION_CLICKED";
    public static final String EXTRA_DOWNLOAD_ID = "extra_download_id";
    public static final String EXTRA_BATCH_ID = "com.novoda.downloadmanager.extra.BATCH_ID";
    public static final String EXTRA_DOWNLOAD_STATUS = "extra_download_status";
    public static final String EXTRA_NOTIFICATION_CLICK_DOWNLOAD_IDS = "extra_click_download_ids";
    public static final String[] UNDERLYING_COLUMNS = new String[]{"_id", "_data AS local_filename", "mediaprovider_uri", "destination", "uri", "status", "deleted", "hint", "mimetype AS media_type", "total_bytes AS total_size", "last_modified_timestamp", "current_bytes AS bytes_so_far", "batch_id", "extra_data", "notificationextras", "batch_title", "batch_description", "batch_notificationBigPictureResourceId", "visibility", "batch_status", "extra_data", "last_modified_timestamp", "'placeholder' AS local_uri", "'placeholder' AS reason"};
    private final ContentResolver contentResolver;
    private final DownloadsUriProvider downloadsUriProvider;
    private final SystemFacade systemFacade;
    private Uri baseUri;
    private static final String NON_DOWNLOADMANAGER_DOWNLOAD = "non-dwnldmngr-download-dont-retry2download";

    public DownloadManager(Context context, ContentResolver resolver) {
        this(context, resolver, DownloadsUriProvider.getInstance(), new RealSystemFacade(context), false);
    }

    public DownloadManager(Context context, ContentResolver contentResolver, boolean verboseLogging) {
        this(context, contentResolver, DownloadsUriProvider.getInstance(), new RealSystemFacade(context), verboseLogging);
    }

    DownloadManager(Context context, ContentResolver resolver, DownloadsUriProvider downloadsUriProvider) {
        this(context, resolver, downloadsUriProvider, new RealSystemFacade(context), false);
    }

    DownloadManager(Context context, ContentResolver contentResolver, DownloadsUriProvider downloadsUriProvider, SystemFacade systemFacade, boolean verboseLogging) {
        this.contentResolver = contentResolver;
        this.downloadsUriProvider = downloadsUriProvider;
        this.baseUri = downloadsUriProvider.getContentUri();
        this.systemFacade = systemFacade;
        GlobalState.setContext(context);
        GlobalState.setVerboseLogging(verboseLogging);
    }

    void setAccessAllDownloads(boolean accessAllDownloads) {
        this.baseUri = accessAllDownloads ? this.downloadsUriProvider.getAllDownloadsUri() : this.downloadsUriProvider.getContentUri();
    }

    public long enqueue(Request request) {
        RequestBatch batch = request.asBatch();
        long batchId = this.insert(batch);
        request.setBatchId(batchId);
        return this.insert(request);
    }

    private long insert(Request request) {
        ContentValues values = request.toContentValues();
        Uri downloadUri = this.contentResolver.insert(this.downloadsUriProvider.getContentUri(), values);
        return ContentUris.parseId((Uri)downloadUri);
    }

    public void pauseBatch(long id) {
        ContentValues values = new ContentValues();
        values.put("control", Integer.valueOf(1));
        this.contentResolver.update(this.downloadsUriProvider.getAllDownloadsUri(), values, "batch_id=?", new String[]{String.valueOf(id)});
    }

    public void resumeBatch(long id) {
        ContentValues values = new ContentValues();
        values.put("control", Integer.valueOf(0));
        values.put(COLUMN_STATUS, Integer.valueOf(190));
        String where = "batch_id= ? AND status != ?";
        String[] selectionArgs = new String[]{String.valueOf(id), String.valueOf(190)};
        this.contentResolver.update(this.downloadsUriProvider.getAllDownloadsUri(), values, where, selectionArgs);
        DownloadDeleter downloadDeleter = new DownloadDeleter(this.contentResolver);
        RealSystemFacade systemFacade = new RealSystemFacade(GlobalState.getContext());
        BatchRepository batchRepository = new BatchRepository(this.contentResolver, downloadDeleter, this.downloadsUriProvider, systemFacade);
        batchRepository.updateBatchStatus(id, 190);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownload(URI uri) {
        try (Cursor cursor = null;){
            cursor = this.contentResolver.query(this.downloadsUriProvider.getContentUri(), new String[]{COLUMN_ID}, "hint=?", new String[]{uri.toString()}, null);
            if (cursor.moveToFirst()) {
                long id = cursor.getLong(cursor.getColumnIndexOrThrow(COLUMN_ID));
                this.removeDownloads(id);
                return;
            }
            Log.e((Object[])new Object[]{"Didn't delete anything for uri: " + uri});
        }
    }

    public int removeDownloads(long ... ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("called with nothing to remove. input param 'ids' can't be null");
        }
        ContentValues values = new ContentValues();
        values.put("deleted", Integer.valueOf(1));
        if (ids.length == 1) {
            return this.contentResolver.update(ContentUris.withAppendedId((Uri)this.baseUri, (long)ids[0]), values, null, null);
        }
        return this.contentResolver.update(this.baseUri, values, DownloadManager.getWhereClauseFor(ids, COLUMN_ID), DownloadManager.longArrayToStringArray(ids));
    }

    public int removeBatches(long ... batchIds) {
        if (batchIds == null || batchIds.length == 0) {
            throw new IllegalArgumentException("called with nothing to remove. input param 'batchIds' can't be null");
        }
        this.setDeletingStatusFor(batchIds);
        return this.markBatchesToBeDeleted(batchIds);
    }

    private void setDeletingStatusFor(long[] batchesIds) {
        ContentValues values = new ContentValues(1);
        values.put(COLUMN_STATUS, Integer.valueOf(188));
        if (batchesIds.length == 1) {
            this.contentResolver.update(this.downloadsUriProvider.getContentUri(), values, "batch_id=?", new String[]{String.valueOf(batchesIds[0])});
        } else {
            this.contentResolver.update(this.downloadsUriProvider.getContentUri(), values, DownloadManager.getWhereClauseFor(batchesIds, COLUMN_BATCH_ID), DownloadManager.longArrayToStringArray(batchesIds));
        }
    }

    private int markBatchesToBeDeleted(long[] batchesIds) {
        ContentValues valuesDelete = new ContentValues(1);
        valuesDelete.put("deleted", Integer.valueOf(1));
        if (batchesIds.length == 1) {
            return this.contentResolver.update(ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getBatchesUri(), (long)batchesIds[0]), valuesDelete, null, null);
        }
        return this.contentResolver.update(this.downloadsUriProvider.getBatchesUri(), valuesDelete, DownloadManager.getWhereClauseFor(batchesIds, COLUMN_ID), DownloadManager.longArrayToStringArray(batchesIds));
    }

    public Cursor query(Query query) {
        Cursor underlyingCursor = query.runQuery(this.contentResolver, UNDERLYING_COLUMNS, this.downloadsUriProvider.getDownloadsByBatchUri());
        if (underlyingCursor == null) {
            return null;
        }
        return new CursorTranslator(underlyingCursor, this.downloadsUriProvider.getDownloadsByBatchUri());
    }

    public Cursor query(BatchQuery query) {
        DownloadDeleter downloadDeleter = new DownloadDeleter(this.contentResolver);
        RealSystemFacade systemFacade = new RealSystemFacade(GlobalState.getContext());
        BatchRepository batchRepository = new BatchRepository(this.contentResolver, downloadDeleter, this.downloadsUriProvider, systemFacade);
        Cursor cursor = batchRepository.retrieveFor(query);
        if (cursor == null) {
            return null;
        }
        return new CursorTranslator(cursor, this.downloadsUriProvider.getBatchesUri());
    }

    public ParcelFileDescriptor openDownloadedFile(long id) throws FileNotFoundException {
        return this.contentResolver.openFileDescriptor(this.getDownloadUri(id), "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri getUriForDownloadedFile(long id) {
        Query query = new Query().setFilterById(id);
        try (Cursor cursor = null;){
            int status;
            cursor = this.query(query);
            if (cursor == null) {
                Uri uri = null;
                return uri;
            }
            if (cursor.moveToFirst() && 8 == (status = cursor.getInt(cursor.getColumnIndexOrThrow(COLUMN_STATUS)))) {
                int indx = cursor.getColumnIndexOrThrow("destination");
                int destination = cursor.getInt(indx);
                if (destination == 1 || destination == 5 || destination == 3 || destination == 2) {
                    Uri uri = ContentUris.withAppendedId((Uri)this.downloadsUriProvider.getContentUri(), (long)id);
                    return uri;
                }
                String path = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_LOCAL_FILENAME));
                Uri uri = Uri.fromFile((File)new File(path));
                return uri;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMimeTypeForDownloadedFile(long id) {
        Query query = new Query().setFilterById(id);
        try (Cursor cursor = null;){
            cursor = this.query(query);
            if (cursor == null) {
                String string = null;
                return string;
            }
            if (cursor.moveToFirst()) {
                String string = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_MEDIA_TYPE));
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartDownload(long ... ids) {
        try (Cursor cursor = this.query(new Query().setFilterById(ids));){
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                int status = cursor.getInt(cursor.getColumnIndex(COLUMN_STATUS));
                if (status != 8 && status != 16) {
                    throw new IllegalArgumentException("Cannot restart incomplete download: " + cursor.getLong(cursor.getColumnIndex(COLUMN_ID)));
                }
                cursor.moveToNext();
            }
        }
        ContentValues values = new ContentValues();
        values.put("current_bytes", Integer.valueOf(0));
        values.put("total_bytes", Integer.valueOf(-1));
        values.putNull("_data");
        values.put(COLUMN_STATUS, Integer.valueOf(190));
        values.put("numfailed", Integer.valueOf(0));
        this.contentResolver.update(this.baseUri, values, DownloadManager.getWhereClauseFor(ids, COLUMN_ID), DownloadManager.longArrayToStringArray(ids));
    }

    @TargetApi(value=17)
    public static Long getMaxBytesOverMobile(Context context) {
        try {
            return Settings.Global.getLong((ContentResolver)context.getContentResolver(), (String)"download_manager_max_bytes_over_mobile");
        }
        catch (Settings.SettingNotFoundException exc) {
            return null;
        }
    }

    @TargetApi(value=17)
    public static Long getRecommendedMaxBytesOverMobile(Context context) {
        try {
            return Settings.Global.getLong((ContentResolver)context.getContentResolver(), (String)"download_manager_recommended_max_bytes_over_mobile");
        }
        catch (Settings.SettingNotFoundException exc) {
            return null;
        }
    }

    public long addCompletedDownload(String title, String description, boolean isMediaScannerScannable, String mimeType, String path, long length, boolean showNotification) {
        DownloadManager.validateArgumentIsNonEmpty("title", title);
        DownloadManager.validateArgumentIsNonEmpty("description", description);
        DownloadManager.validateArgumentIsNonEmpty("path", path);
        DownloadManager.validateArgumentIsNonEmpty("mimeType", mimeType);
        if (length < 0L) {
            throw new IllegalArgumentException(" invalid value for param: totalBytes");
        }
        Request request = new Request(NON_DOWNLOADMANAGER_DOWNLOAD).setTitle(title).setDescription(description).setMimeType(mimeType).setNotificationVisibility(showNotification ? 3 : 2);
        ContentValues values = request.toContentValues();
        values.put("destination", Integer.valueOf(6));
        values.put("_data", path);
        values.put(COLUMN_STATUS, Integer.valueOf(200));
        values.put("total_bytes", Long.valueOf(length));
        values.put("scanned", Integer.valueOf(isMediaScannerScannable ? 0 : 2));
        Uri downloadUri = this.contentResolver.insert(this.downloadsUriProvider.getContentUri(), values);
        if (downloadUri == null) {
            return -1L;
        }
        return ContentUris.parseId((Uri)downloadUri);
    }

    private static void validateArgumentIsNonEmpty(String paramName, String val) {
        if (TextUtils.isEmpty((CharSequence)val)) {
            throw new IllegalArgumentException(paramName + " can't be null");
        }
    }

    private Uri getDownloadUri(long id) {
        return ContentUris.withAppendedId((Uri)this.baseUri, (long)id);
    }

    public Uri getContentUri() {
        return this.downloadsUriProvider.getContentUri();
    }

    public Uri getBatchesUri() {
        return this.downloadsUriProvider.getBatchesUri();
    }

    static String getWhereClauseFor(long[] ids, String column) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("(");
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                whereClause.append("OR ");
            }
            whereClause.append(column);
            whereClause.append(" = ? ");
        }
        whereClause.append(")");
        return whereClause.toString();
    }

    private static String[] longArrayToStringArray(long[] ids) {
        String[] whereArgs = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            whereArgs[i] = Long.toString(ids[i]);
        }
        return whereArgs;
    }

    public long enqueue(RequestBatch batch) {
        long batchId = this.insert(batch);
        for (Request request : batch.getRequests()) {
            request.setBatchId(batchId);
            this.insert(request);
        }
        this.notifyAllBatchHasBeenEnqueued();
        return batchId;
    }

    private void notifyAllBatchHasBeenEnqueued() {
        this.contentResolver.notifyChange(this.getBatchesUri(), null);
        this.contentResolver.notifyChange(this.getBatchesWithoutProgressUri(), null);
    }

    private long insert(RequestBatch batch) {
        ContentValues values = batch.toContentValues();
        values.put(COLUMN_BATCH_STATUS, Integer.valueOf(190));
        values.put(COLUMN_LAST_MODIFIED_TIMESTAMP, Long.valueOf(this.systemFacade.currentTimeMillis()));
        Uri batchUri = this.contentResolver.insert(this.downloadsUriProvider.getBatchesUri(), values);
        return ContentUris.parseId((Uri)batchUri);
    }

    public Uri getDownloadsWithoutProgressUri() {
        return this.downloadsUriProvider.getDownloadsWithoutProgressUri();
    }

    public Uri getBatchesWithoutProgressUri() {
        return this.downloadsUriProvider.getBatchesWithoutProgressUri();
    }

    private static class CursorTranslator
    extends CursorWrapper {
        private final Uri baseUri;

        public CursorTranslator(Cursor cursor, Uri baseUri) {
            super(cursor);
            this.baseUri = baseUri;
        }

        public int getInt(int columnIndex) {
            return (int)this.getLong(columnIndex);
        }

        public long getLong(int columnIndex) {
            String columnName;
            switch (columnName = this.getColumnName(columnIndex)) {
                case "reason": {
                    return this.getReason(super.getInt(this.getColumnIndex(DownloadManager.COLUMN_STATUS)));
                }
                case "status": {
                    return this.translateStatus(super.getInt(this.getColumnIndex(DownloadManager.COLUMN_STATUS)));
                }
                case "batch_status": {
                    return this.translateStatus(super.getInt(this.getColumnIndex(DownloadManager.COLUMN_BATCH_STATUS)));
                }
            }
            return super.getLong(columnIndex);
        }

        public String getString(int columnIndex) {
            return this.getColumnName(columnIndex).equals(DownloadManager.COLUMN_LOCAL_URI) ? this.getLocalUri() : super.getString(columnIndex);
        }

        private String getLocalUri() {
            long destinationType = this.getLong(this.getColumnIndex("destination"));
            if (destinationType == 4L || destinationType == 0L || destinationType == 6L) {
                String localPath = this.getString(this.getColumnIndex(DownloadManager.COLUMN_LOCAL_FILENAME));
                if (localPath == null) {
                    return null;
                }
                return Uri.fromFile((File)new File(localPath)).toString();
            }
            long downloadId = this.getLong(this.getColumnIndex(DownloadManager.COLUMN_ID));
            return ContentUris.withAppendedId((Uri)this.baseUri, (long)downloadId).toString();
        }

        private long getReason(int status) {
            switch (this.translateStatus(status)) {
                case 16: {
                    return this.getErrorCode(status);
                }
                case 4: {
                    return this.getPausedReason(status);
                }
            }
            return 0L;
        }

        private long getPausedReason(int status) {
            switch (status) {
                case 194: {
                    return 1L;
                }
                case 195: {
                    return 2L;
                }
                case 196: {
                    return 3L;
                }
            }
            return 4L;
        }

        private long getErrorCode(int status) {
            if (400 <= status && status < 488 || 500 <= status && status < 600) {
                return status;
            }
            switch (status) {
                case 492: {
                    return 1001L;
                }
                case 493: 
                case 494: {
                    return 1002L;
                }
                case 495: {
                    return 1004L;
                }
                case 497: {
                    return 1005L;
                }
                case 198: {
                    return 1006L;
                }
                case 199: {
                    return 1007L;
                }
                case 489: {
                    return 1008L;
                }
                case 488: {
                    return 1009L;
                }
            }
            return 1000L;
        }

        private int translateStatus(int status) {
            switch (status) {
                case 189: 
                case 190: {
                    return 1;
                }
                case 192: {
                    return 2;
                }
                case 193: 
                case 194: 
                case 195: 
                case 196: {
                    return 4;
                }
                case 200: {
                    return 8;
                }
                case 188: {
                    return 32;
                }
            }
            return 16;
        }
    }
}

