/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.annotation.TargetApi;
import android.content.Context;
import android.drm.DrmManagerClient;
import java.io.File;

class DownloadDrmHelper {
    public static final String MIMETYPE_DRM_MESSAGE = "application/vnd.oma.drm.message";
    public static final String EXTENSION_DRM_MESSAGE = ".dm";
    public static final String EXTENSION_INTERNAL_FWDL = ".fl";

    DownloadDrmHelper() {
    }

    public static boolean isDrmConvertNeeded(String mimetype) {
        return MIMETYPE_DRM_MESSAGE.equals(mimetype);
    }

    public static String modifyDrmFwLockFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex != -1) {
            filename = filename.substring(0, extensionIndex);
        }
        return filename.concat(EXTENSION_INTERNAL_FWDL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public static String getOriginalMimeType(Context context, File file, String currentMime) {
        DrmManagerClient client = new DrmManagerClient(context);
        try {
            String rawFile = file.toString();
            if (client.canHandle(rawFile, null)) {
                String string2 = client.getOriginalMimeType(rawFile);
                return string2;
            }
            String string3 = currentMime;
            return string3;
        }
        finally {
            client.release();
        }
    }
}

