/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.text.TextUtils;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.notils.logger.simple.Log;
import java.io.File;

class DownloadDeleter {
    private final ContentResolver resolver;

    public DownloadDeleter(ContentResolver resolver) {
        this.resolver = resolver;
    }

    public void deleteFileAndDatabaseRow(FileDownloadInfo info) {
        this.deleteFileAndMediaReference(info);
        this.resolver.delete(info.getAllDownloadsUri(), null, null);
    }

    public void deleteFileAndMediaReference(FileDownloadInfo info) {
        if (!TextUtils.isEmpty((CharSequence)info.getMediaProviderUri())) {
            this.resolver.delete(Uri.parse((String)info.getMediaProviderUri()), null, null);
        }
        if (!TextUtils.isEmpty((CharSequence)info.getFileName())) {
            this.deleteFileIfExists(info.getFileName());
            ContentValues blankData = new ContentValues();
            blankData.put("_data", (String)null);
            this.resolver.update(info.getAllDownloadsUri(), blankData, null, null);
        }
    }

    private void deleteFileIfExists(String path) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            Log.d((Object[])new Object[]{"deleteFileIfExists() deleting " + path});
            File file = new File(path);
            if (file.exists() && !file.delete()) {
                Log.w((Object[])new Object[]{"file: '" + path + "' couldn't be deleted"});
            }
        }
    }
}

