/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import com.novoda.downloadmanager.lib.BatchInfo;
import com.novoda.downloadmanager.lib.DownloadDeleter;
import com.novoda.downloadmanager.lib.DownloadScanner;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import java.util.List;

class DownloadBatch {
    public static final DownloadBatch DELETED = new DownloadBatch(-1L, null, null, -1, -1L, -1L);
    private final long batchId;
    private final BatchInfo info;
    private final List<FileDownloadInfo> downloads;
    private final int status;
    private final long totalSizeBytes;
    private final long currentSizeBytes;

    public DownloadBatch(long batchId, BatchInfo info, List<FileDownloadInfo> downloads, int status, long totalSizeBytes, long currentSizeBytes) {
        this.batchId = batchId;
        this.info = info;
        this.downloads = downloads;
        this.status = status;
        this.totalSizeBytes = totalSizeBytes;
        this.currentSizeBytes = currentSizeBytes;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public long getTotalSize() {
        return this.totalSizeBytes;
    }

    public long getCurrentSize() {
        return this.currentSizeBytes;
    }

    public BatchInfo getInfo() {
        return this.info;
    }

    public List<FileDownloadInfo> getDownloads() {
        return this.downloads;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this == DELETED;
    }

    public long nextActionMillis(long now, long nextRetryTimeMillis) {
        for (FileDownloadInfo info : this.downloads) {
            long individualRetryTimeMillis = this.getNextActionMillisFor(now, info);
            nextRetryTimeMillis = Math.min(individualRetryTimeMillis, nextRetryTimeMillis);
        }
        return nextRetryTimeMillis;
    }

    private long getNextActionMillisFor(long now, FileDownloadInfo info) {
        if (DownloadStatus.isCompleted(this.status)) {
            return Long.MAX_VALUE;
        }
        if (this.status != 194) {
            return 0L;
        }
        long when = info.restartTime(now);
        if (when <= now) {
            return 0L;
        }
        return when - now;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadBatch that = (DownloadBatch)o;
        return this.batchId == that.batchId;
    }

    public int hashCode() {
        return (int)(this.batchId ^ this.batchId >>> 32);
    }

    public boolean prune(DownloadDeleter downloadDeleter) {
        boolean isDeleted = false;
        for (FileDownloadInfo info : this.downloads) {
            if (info.isDeleted()) {
                downloadDeleter.deleteFileAndDatabaseRow(info);
                isDeleted = true;
                continue;
            }
            if (!DownloadStatus.isCancelled(info.getStatus()) && !DownloadStatus.isError(info.getStatus())) continue;
            downloadDeleter.deleteFileAndMediaReference(info);
            isDeleted = true;
        }
        return isDeleted;
    }

    public boolean isActive() {
        return this.status == 189 || this.status == 192;
    }

    public boolean scanCompletedMediaIfReady(DownloadScanner downloadScanner) {
        for (FileDownloadInfo info : this.downloads) {
            if (!info.startScanIfReady(downloadScanner)) continue;
            return true;
        }
        return false;
    }
}

