/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentValues;
import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import com.novoda.notils.logger.simple.Log;

final class DatabaseHelper
extends SQLiteOpenHelper {
    private static final int DB_VERSION = 1;
    public static final String[] DOWNLOAD_BY_BATCH_VIEW_COLUMNS = new String[]{"Downloads._id AS _id ", "_data", "mediaprovider_uri", "destination", "uri", "status", "Downloads.deleted", "hint", "mimetype", "total_bytes", "Downloads.last_modified_timestamp", "current_bytes", "notificationextras", "Downloads.extra_data", "batch_id", "batch_title", "batch_description", "batch_notificationBigPictureResourceId", "visibility", "batch_status", "BatchesWithSizes.deleted", "batch_total_bytes", "batch_current_bytes"};
    public static final String[] DOWNLOADS_WITHOUT_PROGRESS_VIEW_COLUMNS = new String[]{"Downloads._id AS _id ", "_data", "mediaprovider_uri", "destination", "uri", "status", "hint", "mimetype", "notificationextras", "Downloads.extra_data", "batch_id", "batch_title", "batch_description", "batch_notificationBigPictureResourceId", "batch_status"};
    public static final String[] BATCHES_WITHOUT_PROGRESS_VIEW_COLUMNS = new String[]{"batch_title", "batch_description", "batch_notificationBigPictureResourceId", "batch_status", "extra_data", "last_modified_timestamp"};

    public DatabaseHelper(Context context, String dbName) {
        super(context, dbName, null, 1);
    }

    public void onCreate(@NonNull SQLiteDatabase db) {
        Log.v((Object[])new Object[]{"populating new database"});
        this.createDownloadsTable(db);
        this.createHeadersTable(db);
        this.createBatchesTable(db);
        this.createBatchesWithSizesView(db);
        this.createDownloadsByBatchView(db);
        this.createDownloadsWithoutProgressView(db);
        this.createBatchesWithoutProgressView(db);
        this.makeCacheDownloadsInvisible(db);
    }

    public void onUpgrade(@NonNull SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    private void createDownloadsTable(SQLiteDatabase db) {
        try {
            db.execSQL("DROP TABLE IF EXISTS Downloads");
            db.execSQL("CREATE TABLE Downloads(_id INTEGER PRIMARY KEY AUTOINCREMENT,uri TEXT, method INTEGER, entity TEXT, no_integrity BOOLEAN, hint TEXT, _data TEXT, mimetype TEXT, destination INTEGER, no_system BOOLEAN, control INTEGER, status INTEGER, numfailed INTEGER, last_modified_timestamp BIGINT, notificationclass TEXT, notificationextras TEXT, cookiedata TEXT, useragent TEXT, referer TEXT, total_bytes INTEGER NOT NULL DEFAULT -1, current_bytes INTEGER NOT NULL DEFAULT 0, etag TEXT, uid INTEGER, otheruid INTEGER, allow_roaming INTEGER NOT NULL DEFAULT 0, allowed_network_types INTEGER NOT NULL DEFAULT 0, is_visible_in_downloads_ui INTEGER NOT NULL DEFAULT 1, bypass_recommended_size_limit INTEGER NOT NULL DEFAULT 0, mediaprovider_uri TEXT, deleted BOOLEAN NOT NULL DEFAULT 0, errorMsg TEXT, allow_metered INTEGER NOT NULL DEFAULT 1, batch_id INTEGER, extra_data TEXT, always_resume INTEGER NOT NULL DEFAULT 0, allow_tar_updates INTEGER NOT NULL DEFAULT 0, scanned BOOLEAN);");
        }
        catch (SQLException ex) {
            Log.e((Object[])new Object[]{"couldn't create table in downloads database"});
            throw ex;
        }
    }

    private void makeCacheDownloadsInvisible(SQLiteDatabase db) {
        ContentValues values = new ContentValues();
        values.put("is_visible_in_downloads_ui", Boolean.valueOf(false));
        String cacheSelection = "destination != 0";
        db.update("Downloads", values, cacheSelection, null);
    }

    private void createHeadersTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS request_headers");
        db.execSQL("CREATE TABLE request_headers(_id INTEGER PRIMARY KEY AUTOINCREMENT,download_id INTEGER NOT NULL,header TEXT NOT NULL,value TEXT NOT NULL);");
    }

    private void createBatchesTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS batches");
        db.execSQL("CREATE TABLE batches(_id INTEGER PRIMARY KEY AUTOINCREMENT,batch_title TEXT NOT NULL,batch_description TEXT,batch_notificationBigPictureResourceId TEXT,batch_status INTEGER,visibility INTEGER,deleted BOOLEAN NOT NULL DEFAULT 0,extra_data TEXT,last_modified_timestamp TEXT);");
    }

    private void createDownloadsByBatchView(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS DownloadsByBatch");
        db.execSQL("CREATE VIEW DownloadsByBatch AS SELECT DISTINCT " + this.projectionFrom(DOWNLOAD_BY_BATCH_VIEW_COLUMNS) + " FROM " + "Downloads" + " INNER JOIN " + "BatchesWithSizes" + " ON " + "Downloads" + "." + "batch_id" + " = " + "BatchesWithSizes" + "." + "_id" + ";");
    }

    private void createBatchesWithSizesView(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS BatchesWithSizes");
        db.execSQL("CREATE VIEW BatchesWithSizes AS SELECT DISTINCT batches.*, batch_current_bytes, batch_total_bytes FROM batches INNER JOIN   (SELECT     batch_id,    SUM(current_bytes) AS batch_current_bytes,    MAX(SUM(total_bytes), -1) AS batch_total_bytes    FROM Downloads    GROUP BY batch_id  ) Downloads ON Downloads.batch_id = batches._id;");
    }

    private void createDownloadsWithoutProgressView(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS DownloadsWithoutProgress");
        db.execSQL("CREATE VIEW DownloadsWithoutProgress AS SELECT DISTINCT " + this.projectionFrom(DOWNLOADS_WITHOUT_PROGRESS_VIEW_COLUMNS) + " FROM " + "Downloads" + " INNER JOIN " + "batches" + " ON " + "Downloads" + "." + "batch_id" + " = " + "batches" + "." + "_id" + ";");
    }

    private void createBatchesWithoutProgressView(SQLiteDatabase db) {
        db.execSQL("DROP VIEW IF EXISTS BatchesWithoutProgress");
        db.execSQL("CREATE VIEW BatchesWithoutProgress AS SELECT DISTINCT " + this.projectionFrom(BATCHES_WITHOUT_PROGRESS_VIEW_COLUMNS) + " FROM " + "batches" + ";");
    }

    private String projectionFrom(String[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 7);
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        return sb.toString();
    }
}

