/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.novoda.notils.logger.simple.Log;

class DatabaseFilenameProvider {
    private static final String DATABASE_FILENAME = "com.novoda.downloadmanager.DatabaseFilename";
    private final PackageManager packageManager;
    private final String packageName;
    private final String defaultFilename;

    DatabaseFilenameProvider(@NonNull PackageManager packageManager, @NonNull String packageName, @NonNull String defaultFilename) {
        this.packageManager = packageManager;
        this.packageName = packageName;
        this.defaultFilename = defaultFilename;
    }

    public String getDatabaseFilename() {
        try {
            ApplicationInfo applicationInfo = this.packageManager.getApplicationInfo(this.packageName, 128);
            return this.getDatabaseFilename(applicationInfo.metaData);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((Object[])new Object[]{"Application info not found for: " + this.packageName + " " + e.getMessage()});
            return this.defaultFilename;
        }
    }

    private String getDatabaseFilename(Bundle bundle) {
        if (bundle == null) {
            return this.defaultFilename;
        }
        return bundle.getString(DATABASE_FILENAME, this.defaultFilename);
    }
}

