/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class Criteria {
    private final String selection;
    private final String sort;
    private final String[] selectionArguments;

    Criteria(String selection, String[] selectionArguments, String sort) {
        this.selection = selection;
        this.sort = sort;
        this.selectionArguments = selectionArguments;
    }

    public String getSelection() {
        return this.selection;
    }

    public String[] getSelectionArguments() {
        return Arrays.copyOf(this.selectionArguments, this.selectionArguments.length);
    }

    public String getSort() {
        return this.sort;
    }

    public static enum Wildcard {
        EQUALS("=?"),
        LESS_THAN("<?"),
        MORE_THAN(">?"),
        MORE_THAN_EQUAL(">=?");

        private final String sqlValue;

        private Wildcard(String wildcard) {
            this.sqlValue = wildcard;
        }

        String toSql() {
            return this.sqlValue;
        }
    }

    public static class Builder {
        private static final String SPACE = " ";
        private static final String AND_BETWEEN_SELECTIONS = "AND";
        private static final String OR_BETWEEN_SELECTIONS = "OR";
        private static final String OPEN_BRACKET = "(";
        private static final String CLOSE_BRACKET = ")";
        private final ArgumentBuilder argumentBuilder = new ArgumentBuilder(this);
        private final SortBuilder sortBuilder = new SortBuilder(this);
        private final SelectionBuilder selectionBuilder = new SelectionBuilder(this);

        public ArgumentBuilder withSelection(String selection, Wildcard wildcard) {
            this.selectionBuilder.withSelection(selection).withWildcard(wildcard);
            return this.argumentBuilder;
        }

        public Builder withInnerCriteria(Criteria criteria) {
            this.selectionBuilder.withSelection(OPEN_BRACKET + criteria.getSelection() + CLOSE_BRACKET);
            this.argumentBuilder.withArguments(criteria.getSelectionArguments());
            return this;
        }

        public Builder and() {
            this.selectionBuilder.withSelection(" AND ");
            return this;
        }

        public Builder or() {
            this.selectionBuilder.withSelection(" OR ");
            return this;
        }

        public Builder joinWithOr(List<Criteria> criteriaList) {
            for (Criteria criteria : criteriaList) {
                this.selectionBuilder.withSelection(criteria.getSelection());
                this.argumentBuilder.withArguments(criteria.getSelectionArguments());
                if (!this.isNotLastIn(criteriaList, criteria)) continue;
                this.or();
            }
            return this;
        }

        private boolean isNotLastIn(List<Criteria> criteriaList, Criteria criteria) {
            return criteriaList.indexOf(criteria) != criteriaList.size() - 1;
        }

        public SortBuilder sortBy(String sortColumn) {
            return this.sortBuilder.sortBy(sortColumn);
        }

        public Criteria build() {
            return new Criteria(this.selectionBuilder.build(), this.argumentBuilder.build(), this.sortBuilder.build());
        }

        public static class SortBuilder {
            private static final String ASCENDING_SORT = "ASC";
            private static final String DESCENDING_SORT = "DESC";
            private final Builder builder;
            private String sort = "";

            public SortBuilder(Builder builder) {
                this.builder = builder;
            }

            public Builder ascending() {
                this.sort = this.sort + " ASC ";
                return this.builder;
            }

            public Builder descending() {
                this.sort = this.sort + " DESC ";
                return this.builder;
            }

            private SortBuilder sortBy(String sort) {
                this.sort = this.sort + sort;
                return this;
            }

            String build() {
                return this.sort;
            }
        }

        public static class ArgumentBuilder {
            private final Builder builder;
            private final List<String> selectionArguments;

            ArgumentBuilder(Builder builder) {
                this.builder = builder;
                this.selectionArguments = new ArrayList<String>();
            }

            public Builder withArgument(String argument) {
                this.selectionArguments.add(argument);
                return this.builder;
            }

            private Builder withArguments(String[] arguments) {
                this.selectionArguments.addAll(Arrays.asList(arguments));
                return this.builder;
            }

            String[] build() {
                return this.selectionArguments.toArray(new String[this.selectionArguments.size()]);
            }
        }

        public static class SelectionBuilder {
            private final Builder builder;
            private String selection = "";

            public SelectionBuilder(Builder builder) {
                this.builder = builder;
            }

            private SelectionBuilder withSelection(String selection) {
                this.selection = this.selection + selection;
                return this;
            }

            private Builder withWildcard(Wildcard wildcard) {
                this.selection = this.selection + wildcard.toSql();
                return this.builder;
            }

            String build() {
                return this.selection;
            }
        }
    }
}

