/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.util.Pair;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.notils.logger.simple.Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;

class ContentLengthFetcher {
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final int UNKNOWN_CONTENT_LENGTH = -1;
    private static final int TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String METHOD_HEAD = "HEAD";

    ContentLengthFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fetchContentLengthFor(FileDownloadInfo info) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(info.getUri()).openConnection();
            conn.setInstanceFollowRedirects(true);
            conn.setConnectTimeout(TIMEOUT_MILLIS);
            conn.setReadTimeout(TIMEOUT_MILLIS);
            conn.setRequestMethod(METHOD_HEAD);
            this.addRequestHeaders(info, conn);
            if (conn.getResponseCode() == 200) {
                long l = ContentLengthFetcher.getHeaderFieldLong(conn, HEADER_CONTENT_LENGTH, -1L);
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            Log.e((Object[])new Object[]{"Could not fetch content length."});
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return -1L;
    }

    private static long getHeaderFieldLong(URLConnection conn, String field, long defaultValue) {
        try {
            return Long.parseLong(conn.getHeaderField(field));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private void addRequestHeaders(FileDownloadInfo info, HttpURLConnection conn) {
        for (Pair<String, String> header : info.getHeaders()) {
            conn.addRequestProperty((String)header.first, (String)header.second);
        }
        if (conn.getRequestProperty(HEADER_USER_AGENT) == null) {
            conn.addRequestProperty(HEADER_USER_AGENT, this.userAgent(info));
        }
    }

    private String userAgent(FileDownloadInfo info) {
        String userAgent = info.getUserAgent();
        if (userAgent == null) {
            return "AndroidDownloadManager";
        }
        return userAgent;
    }
}

