/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.novoda.notils.logger.simple.Log;

class ConcurrentDownloadsLimitProvider {
    private static final int DEFAULT_MAX_CONCURRENT_DOWNLOADS = 5;
    private static final String METADATA_MAX_CONCURRENT_DOWNLOADS = "com.novoda.downloadmanager.MaxConcurrentDownloads";
    private final PackageManager packageManager;
    private final String packageName;

    ConcurrentDownloadsLimitProvider(PackageManager packageManager, String packageName) {
        this.packageManager = packageManager;
        this.packageName = packageName;
    }

    public int getConcurrentDownloadsLimit() {
        try {
            ApplicationInfo applicationInfo = this.packageManager.getApplicationInfo(this.packageName, 128);
            return this.getMaximumConcurrentDownloads(applicationInfo.metaData);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((Object[])new Object[]{"Application info not found for: " + this.packageName + " " + e.getMessage()});
            return 5;
        }
    }

    private int getMaximumConcurrentDownloads(Bundle bundle) {
        if (bundle == null) {
            return 5;
        }
        return bundle.getInt(METADATA_MAX_CONCURRENT_DOWNLOADS, 5);
    }
}

