/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.util.SparseIntArray;
import com.novoda.downloadmanager.lib.BatchInfo;
import com.novoda.downloadmanager.lib.BatchQuery;
import com.novoda.downloadmanager.lib.DownloadBatch;
import com.novoda.downloadmanager.lib.DownloadDeleter;
import com.novoda.downloadmanager.lib.DownloadStatus;
import com.novoda.downloadmanager.lib.DownloadsUriProvider;
import com.novoda.downloadmanager.lib.FileDownloadInfo;
import com.novoda.downloadmanager.lib.SystemFacade;
import com.novoda.notils.string.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class BatchRepository {
    private static final List<Integer> PRIORITISED_STATUSES = Arrays.asList(490, 193, 192, 188, 194, 195, 196, 189, 190, 200);
    private static final int PRIORITISED_STATUSES_SIZE = PRIORITISED_STATUSES.size();
    private static final String[] PROJECT_BATCH_ID = new String[]{"_id"};
    private static final String WHERE_DELETED_VALUE_IS = "deleted = ?";
    private static final String[] MARKED_FOR_DELETION = new String[]{"1"};
    private final ContentResolver resolver;
    private final DownloadDeleter downloadDeleter;
    private final DownloadsUriProvider downloadsUriProvider;
    private final SystemFacade systemFacade;

    BatchRepository(ContentResolver resolver, DownloadDeleter downloadDeleter, DownloadsUriProvider downloadsUriProvider, SystemFacade systemFacade) {
        this.resolver = resolver;
        this.downloadDeleter = downloadDeleter;
        this.downloadsUriProvider = downloadsUriProvider;
        this.systemFacade = systemFacade;
    }

    void updateBatchStatus(long batchId, int status) {
        ContentValues values = new ContentValues();
        values.put("batch_status", Integer.valueOf(status));
        values.put("last_modified_timestamp", Long.valueOf(this.systemFacade.currentTimeMillis()));
        this.resolver.update(this.downloadsUriProvider.getBatchesUri(), values, "_id = ?", new String[]{String.valueOf(batchId)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBatchStatus(long batchId) {
        SparseIntArray statusCounts = new SparseIntArray(PRIORITISED_STATUSES_SIZE);
        try (Cursor cursor = null;){
            String[] projection = new String[]{"status"};
            String[] selectionArgs = new String[]{String.valueOf(batchId)};
            cursor = this.resolver.query(this.downloadsUriProvider.getAllDownloadsUri(), projection, "batch_id = ?", selectionArgs, null);
            while (cursor.moveToNext()) {
                int statusCode = cursor.getInt(0);
                if (DownloadStatus.isError(statusCode)) {
                    int n = statusCode;
                    return n;
                }
                int currentStatusCount = statusCounts.get(statusCode);
                statusCounts.put(statusCode, currentStatusCount + 1);
            }
        }
        for (int status : PRIORITISED_STATUSES) {
            if (statusCounts.get(status) <= 0) continue;
            return status;
        }
        return 491;
    }

    public DownloadBatch retrieveBatchFor(FileDownloadInfo download) {
        List<FileDownloadInfo> downloads = Collections.singletonList(download);
        List<DownloadBatch> batches = this.retrieveBatchesFor(downloads);
        for (DownloadBatch batch : batches) {
            if (batch.getBatchId() != download.getBatchId()) continue;
            return batch;
        }
        return DownloadBatch.DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadBatch> retrieveBatchesFor(Collection<FileDownloadInfo> downloads) {
        Cursor batchesCursor = this.resolver.query(this.downloadsUriProvider.getBatchesUri(), null, null, null, null);
        ArrayList<DownloadBatch> batches = new ArrayList<DownloadBatch>(batchesCursor.getCount());
        try {
            int idColumn = batchesCursor.getColumnIndexOrThrow("_id");
            int titleIndex = batchesCursor.getColumnIndexOrThrow("batch_title");
            int descriptionIndex = batchesCursor.getColumnIndexOrThrow("batch_description");
            int bigPictureUrlIndex = batchesCursor.getColumnIndexOrThrow("batch_notificationBigPictureResourceId");
            int statusIndex = batchesCursor.getColumnIndexOrThrow("batch_status");
            int visibilityIndex = batchesCursor.getColumnIndexOrThrow("visibility");
            int extraDataIndex = batchesCursor.getColumnIndexOrThrow("extra_data");
            int totalBatchSizeIndex = batchesCursor.getColumnIndexOrThrow("batch_total_bytes");
            int currentBatchSizeIndex = batchesCursor.getColumnIndexOrThrow("batch_current_bytes");
            while (batchesCursor.moveToNext()) {
                long id = batchesCursor.getLong(idColumn);
                String title = batchesCursor.getString(titleIndex);
                String description = batchesCursor.getString(descriptionIndex);
                String bigPictureUrl = batchesCursor.getString(bigPictureUrlIndex);
                int status = batchesCursor.getInt(statusIndex);
                int visibility = batchesCursor.getInt(visibilityIndex);
                String extraData = batchesCursor.getString(extraDataIndex);
                long totalSizeBytes = batchesCursor.getLong(totalBatchSizeIndex);
                long currentSizeBytes = batchesCursor.getLong(currentBatchSizeIndex);
                BatchInfo batchInfo = new BatchInfo(title, description, bigPictureUrl, visibility, extraData);
                ArrayList<FileDownloadInfo> batchDownloads = new ArrayList<FileDownloadInfo>(1);
                for (FileDownloadInfo fileDownloadInfo : downloads) {
                    if (fileDownloadInfo.getBatchId() != id) continue;
                    batchDownloads.add(fileDownloadInfo);
                }
                batches.add(new DownloadBatch(id, batchInfo, batchDownloads, status, totalSizeBytes, currentSizeBytes));
            }
        }
        finally {
            batchesCursor.close();
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMarkedBatchesFor(Collection<FileDownloadInfo> downloads) {
        ArrayList<Long> batchIdsToDelete = new ArrayList<Long>();
        try (Cursor batchesCursor = this.resolver.query(this.downloadsUriProvider.getBatchesUri(), PROJECT_BATCH_ID, WHERE_DELETED_VALUE_IS, MARKED_FOR_DELETION, null);){
            while (batchesCursor.moveToNext()) {
                long id = batchesCursor.getLong(0);
                batchIdsToDelete.add(id);
            }
        }
        this.deleteBatchesForIds(batchIdsToDelete, downloads);
    }

    private void deleteBatchesForIds(List<Long> batchIdsToDelete, Collection<FileDownloadInfo> downloads) {
        if (batchIdsToDelete.isEmpty()) {
            return;
        }
        for (FileDownloadInfo download : downloads) {
            if (!batchIdsToDelete.contains(download.getBatchId())) continue;
            this.downloadDeleter.deleteFileAndDatabaseRow(download);
        }
        String selection = StringUtils.join(batchIdsToDelete, (String)", ");
        String[] selectionArgs = new String[]{selection};
        this.resolver.delete(this.downloadsUriProvider.getBatchesUri(), "_id IN (?)", selectionArgs);
    }

    public Cursor retrieveFor(BatchQuery query) {
        return this.resolver.query(this.downloadsUriProvider.getBatchesUri(), null, query.getSelection(), query.getSelectionArguments(), query.getSortOrder());
    }
}

