/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager.lib;

import android.support.annotation.NonNull;
import com.novoda.downloadmanager.lib.Criteria;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BatchQuery {
    public static final BatchQuery ALL = new BatchQuery(null, null, null);
    private static final int LOW_END_FAILED_STATUS_CODE = 400;
    private static final int HIGH_END_FAILED_STATUS_CODE = 600;
    private final String selection;
    private final String sortOrder;
    private final String[] selectionArguments;

    BatchQuery(String selection, String[] selectionArguments, String sortOrder) {
        this.selection = selection;
        this.sortOrder = sortOrder;
        this.selectionArguments = selectionArguments;
    }

    String getSelection() {
        return this.selection;
    }

    String getSortOrder() {
        return this.sortOrder;
    }

    String[] getSelectionArguments() {
        return this.selectionArguments;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }

    public static class Builder {
        private final Criteria.Builder builder = new Criteria.Builder();
        private static final String ORDER_BY_LIVENESS = "CASE batch_status WHEN 192 THEN 1 WHEN 190 THEN 2 WHEN 193 THEN 3 WHEN 498 THEN 4 WHEN 200 THEN 5 ELSE 6 END, _id ASC";
        private Criteria.Builder criteriaIdBuilder;
        private Criteria.Builder criteriaStatusBuilder;
        private Criteria.Builder criteriaExtraDataBuilder;

        public Builder withId(long id) {
            this.criteriaIdBuilder = new Criteria.Builder();
            this.criteriaIdBuilder.withSelection("_id", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(id));
            return this;
        }

        public Builder withSortAscendingBy(String sortColumn) {
            this.builder.sortBy(sortColumn).ascending();
            return this;
        }

        public Builder withSortDescendingBy(String sortColumn) {
            this.builder.sortBy(sortColumn).descending();
            return this;
        }

        public Builder withSortByLiveness() {
            this.builder.sortBy(ORDER_BY_LIVENESS);
            return this;
        }

        public Builder withStatusFilter(int statusFlags) {
            this.criteriaStatusBuilder = new Criteria.Builder().joinWithOr(this.buildCriteriaListFrom(statusFlags));
            return this;
        }

        public Builder withExtraData(String extraData) {
            this.criteriaExtraDataBuilder = new Criteria.Builder();
            this.criteriaExtraDataBuilder.withSelection("extra_data", Criteria.Wildcard.EQUALS).withArgument(extraData);
            return this;
        }

        @NonNull
        private List<Criteria> buildCriteriaListFrom(int statusFlags) {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            if ((statusFlags & 1) != 0) {
                Criteria pendingCriteria = new Criteria.Builder().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(190)).build();
                criteriaList.add(pendingCriteria);
            }
            if ((statusFlags & 2) != 0) {
                Criteria runningCriteria = new Criteria.Builder().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(192)).build();
                criteriaList.add(runningCriteria);
            }
            if ((statusFlags & 4) != 0) {
                Criteria pausedCriteria = new Criteria.Builder().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(193)).or().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(194)).or().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(195)).or().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(196)).build();
                criteriaList.add(pausedCriteria);
            }
            if ((statusFlags & 0x20) != 0) {
                Criteria deletingCriteria = new Criteria.Builder().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(188)).build();
                criteriaList.add(deletingCriteria);
            }
            if ((statusFlags & 8) != 0) {
                Criteria successfulCriteria = new Criteria.Builder().withSelection("batch_status", Criteria.Wildcard.EQUALS).withArgument(String.valueOf(200)).build();
                criteriaList.add(successfulCriteria);
            }
            if ((statusFlags & 0x10) != 0) {
                Criteria failedCriteria = new Criteria.Builder().withInnerCriteria(new Criteria.Builder().withSelection("batch_status", Criteria.Wildcard.MORE_THAN_EQUAL).withArgument(String.valueOf(400)).and().withSelection("batch_status", Criteria.Wildcard.LESS_THAN).withArgument(String.valueOf(600)).build()).build();
                criteriaList.add(failedCriteria);
            }
            return criteriaList;
        }

        public BatchQuery build() {
            if (this.criteriaIdBuilder != null) {
                this.builder.withInnerCriteria(this.criteriaIdBuilder.build());
                if (this.criteriaStatusBuilder != null) {
                    this.builder.and();
                }
            }
            if (this.criteriaStatusBuilder != null) {
                this.builder.withInnerCriteria(this.criteriaStatusBuilder.build());
                if (this.criteriaExtraDataBuilder != null) {
                    this.builder.and();
                }
            }
            if (this.criteriaExtraDataBuilder != null) {
                this.builder.withInnerCriteria(this.criteriaExtraDataBuilder.build());
            }
            Criteria criteria = this.builder.build();
            String selection = criteria.getSelection();
            String sortOrder = criteria.getSort();
            String[] selectionArguments = criteria.getSelectionArguments();
            return new BatchQuery(selection, selectionArguments, sortOrder);
        }
    }
}

