/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.helper;

import com.google.gson.Gson;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.dao.SmokeTestData;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import org.dshops.metrics.MetricRegistry;
import org.dshops.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmokeTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmokeTestHelper.class);
    private final Parameters parameters;
    private final Gson gson;
    private final MetricRegistry metricRegistry;
    private final OkHttpClient client;

    public SmokeTestHelper(Parameters parameters, Gson gson, MetricRegistry metricRegistry) {
        this.parameters = parameters;
        this.gson = gson;
        this.metricRegistry = metricRegistry;
        this.client = new OkHttpClient();
        this.client.setConnectTimeout(2L, TimeUnit.SECONDS);
        this.client.setReadTimeout(10L, TimeUnit.MINUTES);
        this.client.setWriteTimeout(2L, TimeUnit.SECONDS);
        this.client.setFollowSslRedirects(false);
        this.client.setFollowRedirects(false);
        this.client.setConnectionPool(new ConnectionPool(15, 60000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmokeTestData ExecuteSmokeTest(String smokeTestUrl, String endPoint, String serviceName, String reason) {
        Response response;
        if (smokeTestUrl == null || smokeTestUrl.isEmpty() || endPoint == null || endPoint.isEmpty()) {
            return null;
        }
        LOGGER.info("Smoke testing EP {} with {}", (Object)endPoint, (Object)smokeTestUrl);
        String url = "http://" + smokeTestUrl.replace("{endPoint}", endPoint);
        Timer timer = this.metricRegistry.timer("smokeTest.duration", new String[]{"serviceName", serviceName, "reason", reason});
        try {
            Request request;
            Request.Builder builder = new Request.Builder().url(url);
            if (this.parameters.getUsername() != null && this.parameters.getUsername().isEmpty() && this.parameters.getPassword() != null && this.parameters.getPassword().isEmpty()) {
                builder.addHeader("Authorization", Credentials.basic((String)this.parameters.getUsername(), (String)this.parameters.getPassword()));
            }
            if ((response = this.client.newCall(request = builder.build()).execute()).isSuccessful()) {
                timer.addTag("result", "success");
                try (InputStream stream = response.body().byteStream();){
                    InputStreamReader reader = new InputStreamReader(stream);
                    SmokeTestData smokeTestData = (SmokeTestData)this.gson.fromJson((Reader)reader, SmokeTestData.class);
                    return smokeTestData;
                }
            }
            timer.addTag("result", "fail");
        }
        catch (Exception ex) {
            timer.addTag("result", "fail");
            LOGGER.warn("Call to {} failed with exception {}", (Object)url, (Object)ex.getMessage());
            SmokeTestData smokeTestData = null;
            return smokeTestData;
        }
        finally {
            timer.stop();
        }
        LOGGER.warn("Call to {} failed with code {}", (Object)url, (Object)response.code());
        SmokeTestData smokeTestData = null;
        return smokeTestData;
    }
}

