/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VipMigrateAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(VipMigrateAction.class);

    @Override
    public Result process(WorkItem workItem) {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            LOGGER.info("Failed the find vip");
            return Result.error;
        }
        switch (vip.getMigration()) {
            case 0: {
                LOGGER.info("Migrating Vip {} step 1 for {}", (Object)workItem.getVip().dns, (Object)workItem.getService().serviceName);
                vip.setMigration(1);
                this.dataAccess.saveVip(vip);
                return Result.success;
            }
            case 1: {
                LOGGER.info("Migrating Vip {} step 2 for {}", (Object)workItem.getVip().dns, (Object)workItem.getService().serviceName);
                vip.setMigration(2);
                this.dataAccess.saveVip(vip);
                return Result.success;
            }
        }
        LOGGER.info("Failed to migrating Vip {} for {}, current state {}", new Object[]{workItem.getVip().dns, workItem.getService().serviceName, vip.getMigration()});
        return Result.error;
    }

    @Override
    public void success(WorkItem workItem) {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            LOGGER.warn("Could not find vip {} being migrated", (Object)workItem.getVip().vipId);
            return;
        }
        vip.setStatus(false, "-");
        this.dataAccess.updateVip(vip);
    }

    @Override
    public void error(WorkItem workItem) {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            LOGGER.warn("Could not find vip {} being migrated", (Object)workItem.getVip().vipId);
            return;
        }
        vip.setStatus(false, "Migration step " + vip.getMigration() + " failed");
        this.dataAccess.updateVip(vip);
    }
}

