/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.HostVipBaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostVipDisableAction
extends HostVipBaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostVipDisableAction.class);

    @Override
    public void updateStatus(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} who's VIP is being disabled", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, true, "Disabling in VIP...");
    }

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Disabling vips for {} {}", (Object)workItem.getHost().hostName, (Object)workItem.getService().serviceName);
        return Result.success;
    }

    @Override
    protected Result processVip(WorkItem workItem, Vip vip) {
        LOGGER.info("Disabling vip {} for {} {}", new Object[]{vip.getDns(), workItem.getHost().hostName, workItem.getService().serviceName});
        return Result.success;
    }

    @Override
    protected String getVerb() {
        return "disable";
    }

    @Override
    protected String getVerbPastTense() {
        return "disabled";
    }

    @Override
    protected String getPreposition() {
        return "in";
    }
}

